/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.bedrock.request;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.MalformedURLException;
import java.time.Instant;
import java.util.UUID;
import net.lenni0451.commons.gson.elements.GsonObject;
import net.lenni0451.commons.httpclient.HttpResponse;
import net.lenni0451.commons.httpclient.content.HttpContent;
import net.lenni0451.commons.httpclient.requests.impl.PostRequest;
import net.raphimc.minecraftauth.bedrock.model.MinecraftSession;
import net.raphimc.minecraftauth.bedrock.responsehandler.MinecraftServicesResponseHandler;
import net.raphimc.minecraftauth.playfab.model.PlayFabToken;
import net.raphimc.minecraftauth.util.UuidUtil;
import net.raphimc.minecraftauth.util.http.content.JsonContent;
import net.raphimc.minecraftauth.xbl.model.XblXstsToken;

public class MinecraftSessionStartRequest
extends PostRequest
implements MinecraftServicesResponseHandler<MinecraftSession> {
    public MinecraftSessionStartRequest(XblXstsToken xstsToken, PlayFabToken playFabToken, String gameVersion, UUID deviceId) throws MalformedURLException {
        super("https://authorization.franchise.minecraft-services.net/api/v1.0/session/start");
        JsonObject device = new JsonObject();
        device.addProperty("applicationType", "MinecraftPE");
        device.addProperty("gameVersion", gameVersion);
        device.addProperty("id", UuidUtil.toUndashedString(deviceId));
        device.addProperty("memory", (Number)0x800000000L);
        device.addProperty("hardwareMemoryTier", (Number)5);
        device.addProperty("platform", "Windows10");
        device.addProperty("playFabTitleId", "20CA2");
        device.addProperty("storePlatform", "uwp.store");
        device.addProperty("type", "Windows10");
        JsonObject user = new JsonObject();
        user.addProperty("language", "en");
        user.addProperty("regionCode", "US");
        user.addProperty("languageCode", "en-US");
        user.addProperty("tokenType", "PlayFab");
        user.addProperty("token", playFabToken.getSessionTicket());
        JsonObject postData = new JsonObject();
        postData.add("device", (JsonElement)device);
        postData.add("user", (JsonElement)user);
        this.setContent((HttpContent)new JsonContent(postData));
        this.setHeader("Authorization", xstsToken.getAuthorizationHeader());
    }

    @Override
    public MinecraftSession handle(HttpResponse response, GsonObject json) throws IOException {
        GsonObject result = json.reqObject("result");
        return new MinecraftSession(Instant.parse(result.reqString("validUntil")).toEpochMilli(), result.reqString("authorizationHeader"));
    }
}

