/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.xbl.responsehandler;

import java.io.IOException;
import java.util.Optional;
import net.lenni0451.commons.gson.elements.GsonObject;
import net.lenni0451.commons.httpclient.HttpResponse;
import net.raphimc.minecraftauth.util.http.responsehandler.JsonHttpResponseHandler;
import net.raphimc.minecraftauth.xbl.exception.XblRequestException;

public interface XblResponseHandler<R>
extends JsonHttpResponseHandler<R> {
    @Override
    default public R handle(HttpResponse response) throws IOException {
        Optional xErrHeader;
        if (response.getStatusCode() >= 300 && (xErrHeader = response.getFirstHeader("X-Err")).isPresent()) {
            throw new XblRequestException(response, Long.parseLong((String)xErrHeader.get()));
        }
        return JsonHttpResponseHandler.super.handle(response);
    }

    @Override
    default public void handleError(HttpResponse response, GsonObject json) throws IOException {
        if (json.hasNumber("XErr")) {
            throw new XblRequestException(response, json.reqLong("XErr"));
        }
    }
}

