/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.raphimc.noteblocklib.format.nbs.NbsSong;
import net.raphimc.noteblocklib.format.nbs.model.NbsCustomInstrument;
import net.raphimc.noteblocklib.format.nbs.model.NbsData;
import net.raphimc.noteblocklib.format.nbs.model.NbsHeader;
import net.raphimc.noteblocklib.format.nbs.model.NbsNote;
import net.raphimc.noteblocklib.model.Note;
import net.raphimc.noteblocklib.model.SongView;

public class SongResampler {
    public static <N extends Note> void changeTickSpeed(SongView<N> songView, float newSpeed) {
        float divider = songView.getSpeed() / newSpeed;
        if (divider == 1.0f) {
            return;
        }
        TreeMap newNotes = new TreeMap();
        for (Map.Entry<Integer, List<N>> entry : songView.getNotes().entrySet()) {
            newNotes.computeIfAbsent(Math.round((float)entry.getKey().intValue() / divider), k -> new ArrayList()).addAll((Collection)entry.getValue());
        }
        songView.setNotes(newNotes);
        songView.setSpeed(newSpeed);
        songView.recalculateLength();
    }

    public static void applyNbsTempoChangers(NbsSong song) {
        SongResampler.applyNbsTempoChangers(song, song.getView());
    }

    public static void applyNbsTempoChangers(NbsSong song, SongView<NbsNote> view) {
        if (((NbsHeader)song.getHeader()).getVersion() < 4) {
            return;
        }
        boolean hasTempoChanger = false;
        for (NbsCustomInstrument nbsCustomInstrument : ((NbsData)song.getData()).getCustomInstruments()) {
            if (!nbsCustomInstrument.getName().equals("Tempo Changer")) continue;
            ((NbsData)song.getData()).getCustomInstruments().remove(nbsCustomInstrument);
            hasTempoChanger = true;
            break;
        }
        if (!hasTempoChanger) {
            return;
        }
        ArrayList<TempoEvent> tempoEvents = new ArrayList<TempoEvent>();
        block1: for (Map.Entry<Integer, List<NbsNote>> entry : view.getNotes().entrySet()) {
            for (NbsNote note : entry.getValue()) {
                if (note.getCustomInstrument() == null || !note.getCustomInstrument().getName().equals("Tempo Changer")) continue;
                tempoEvents.add(new TempoEvent(entry.getKey(), (float)Math.abs(note.getPitch()) / 15.0f));
                entry.getValue().remove(note);
                continue block1;
            }
        }
        if (tempoEvents.isEmpty()) {
            return;
        }
        if (((TempoEvent)tempoEvents.get(0)).getTick() != 0) {
            tempoEvents.add(0, new TempoEvent(0, view.getSpeed()));
        }
        tempoEvents.sort(Comparator.comparingInt(TempoEvent::getTick));
        TreeMap treeMap = new TreeMap();
        float f = tempoEvents.stream().map(TempoEvent::getTicksPerSecond).max(Float::compareTo).orElse(Float.valueOf(view.getSpeed())).floatValue();
        double milliTime = 0.0;
        int lastTick = 0;
        float millisPerTick = ((TempoEvent)tempoEvents.get(0)).getMillisPerTick();
        int tempoEventIdx = 1;
        for (Map.Entry<Integer, List<NbsNote>> entry : view.getNotes().entrySet()) {
            while (tempoEventIdx < tempoEvents.size() && entry.getKey() > ((TempoEvent)tempoEvents.get(tempoEventIdx)).getTick()) {
                TempoEvent tempoEvent = (TempoEvent)tempoEvents.get(tempoEventIdx++);
                milliTime += (double)((float)(tempoEvent.getTick() - lastTick) * millisPerTick);
                lastTick = tempoEvent.getTick();
                millisPerTick = tempoEvent.getMillisPerTick();
            }
            lastTick = entry.getKey();
            treeMap.computeIfAbsent((int)Math.round((milliTime += (double)((float)(entry.getKey() - lastTick) * millisPerTick)) * (double)f / 1000.0), k -> new ArrayList()).addAll((Collection)entry.getValue());
        }
        view.setNotes(treeMap);
        view.setSpeed(f);
        view.recalculateLength();
    }

    private static class TempoEvent {
        private final int tick;
        private final float ticksPerSecond;

        public TempoEvent(int tick, float ticksPerSecond) {
            this.tick = tick;
            this.ticksPerSecond = ticksPerSecond;
        }

        public int getTick() {
            return this.tick;
        }

        public float getTicksPerSecond() {
            return this.ticksPerSecond;
        }

        public float getMillisPerTick() {
            return 1000.0f / this.ticksPerSecond;
        }
    }
}

