/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.model;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import net.raphimc.noteblocklib.model.Note;

public class SongView<N extends Note>
implements Cloneable {
    private String title;
    private int length;
    private float speed;
    private Map<Integer, List<N>> notes;

    public SongView(String title, float speed, Map<Integer, List<N>> notes) {
        this.title = title;
        this.speed = speed;
        this.notes = notes;
        this.recalculateLength();
    }

    private SongView(String title, float speed, int length, Map<Integer, List<N>> notes) {
        this.title = title;
        this.speed = speed;
        this.length = length;
        this.notes = notes;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getLength() {
        return this.length;
    }

    public void recalculateLength() {
        this.length = this.notes.keySet().stream().mapToInt(i -> i).max().orElse(0);
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public List<N> getNotesAtTick(int tick) {
        return this.notes.getOrDefault(tick, Collections.emptyList());
    }

    public void setNotesAtTick(int tick, List<N> notes) {
        this.notes.put(tick, notes);
    }

    public Map<Integer, List<N>> getNotes() {
        return this.notes;
    }

    public void setNotes(Map<Integer, List<N>> notes) {
        this.notes = notes;
    }

    public SongView<N> clone() {
        Map notes = this.notes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((List)e.getValue()).stream().map(n -> n.clone()).collect(Collectors.toList()), SongView.throwingMerger(), TreeMap::new));
        return new SongView<N>(this.title, this.speed, this.length, notes);
    }

    private static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
    }
}

