/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.format.nbs;

import com.google.common.io.LittleEndianDataInputStream;
import com.google.common.io.LittleEndianDataOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.raphimc.noteblocklib.data.MinecraftInstrument;
import net.raphimc.noteblocklib.format.nbs.NbsDefinitions;
import net.raphimc.noteblocklib.format.nbs.model.NbsCustomInstrument;
import net.raphimc.noteblocklib.format.nbs.model.NbsLayer;
import net.raphimc.noteblocklib.format.nbs.model.NbsNote;
import net.raphimc.noteblocklib.format.nbs.model.NbsSong;
import net.raphimc.noteblocklib.model.Note;
import net.raphimc.noteblocklib.model.instrument.Instrument;

public class NbsIo {
    private static final int BUFFER_SIZE = 0x100000;

    public static NbsSong readSong(InputStream is, String fileName) throws IOException {
        short jumpTicks;
        LittleEndianDataInputStream dis = new LittleEndianDataInputStream((InputStream)new BufferedInputStream(is, 0x100000));
        NbsSong song = new NbsSong(fileName);
        short length = dis.readShort();
        if (length == 0) {
            song.setVersion(dis.readByte());
            song.setVanillaInstrumentCount(dis.readUnsignedByte());
            if (song.getVersion() >= 3) {
                song.setLength(dis.readShort());
            } else {
                song.setLength((short)-1);
            }
        } else {
            song.setLength(length);
            song.setVersion((byte)0);
            song.setVanillaInstrumentCount(10);
        }
        if (song.getVersion() < 0 || song.getVersion() > 5) {
            throw new IllegalStateException("Unsupported NBS version: " + song.getVersion());
        }
        song.setLayerCount(dis.readShort());
        song.setTitle(NbsIo.readString(dis));
        song.setAuthor(NbsIo.readString(dis));
        song.setOriginalAuthor(NbsIo.readString(dis));
        song.setDescription(NbsIo.readString(dis));
        song.setTempo(dis.readShort());
        song.setAutoSave(dis.readBoolean());
        song.setAutoSaveInterval(dis.readByte());
        song.setTimeSignature(dis.readByte());
        song.setMinutesSpent(dis.readInt());
        song.setLeftClicks(dis.readInt());
        song.setRightClicks(dis.readInt());
        song.setNoteBlocksAdded(dis.readInt());
        song.setNoteBlocksRemoved(dis.readInt());
        song.setSourceFileName(NbsIo.readString(dis));
        if (song.getVersion() >= 4) {
            song.setLoop(dis.readBoolean());
            song.setMaxLoopCount(dis.readByte());
            song.setLoopStartTick(dis.readShort());
        }
        Map<Integer, NbsLayer> layers = song.getLayers();
        List<NbsCustomInstrument> customInstruments = song.getCustomInstruments();
        int tick = -1;
        while ((jumpTicks = dis.readShort()) != 0) {
            short jumpLayers;
            tick += jumpTicks;
            int layer2 = -1;
            while ((jumpLayers = dis.readShort()) != 0) {
                layer2 += jumpLayers;
                NbsNote note = new NbsNote();
                note.setInstrument((short)dis.readUnsignedByte());
                note.setKey(dis.readByte());
                if (song.getVersion() >= 4) {
                    note.setVelocity(dis.readByte());
                    note.setPanning((short)dis.readUnsignedByte());
                    note.setPitch(dis.readShort());
                }
                layers.computeIfAbsent(layer2, k -> new NbsLayer()).getNotes().put(tick, note);
            }
        }
        if (dis.available() > 0) {
            for (int i = 0; i < song.getLayerCount(); ++i) {
                NbsLayer layer3 = layers.computeIfAbsent(i, k -> new NbsLayer());
                layer3.setName(NbsIo.readString(dis));
                if (song.getVersion() >= 4) {
                    byte lockedByte = dis.readByte();
                    switch (lockedByte) {
                        case 0: {
                            layer3.setStatus(NbsLayer.Status.NONE);
                            break;
                        }
                        case 1: {
                            layer3.setStatus(NbsLayer.Status.LOCKED);
                            break;
                        }
                        case 2: {
                            layer3.setStatus(NbsLayer.Status.SOLO);
                        }
                    }
                }
                layer3.setVolume(dis.readByte());
                if (song.getVersion() < 2) continue;
                layer3.setPanning((short)dis.readUnsignedByte());
            }
        }
        if (dis.available() > 0) {
            int customInstrumentsAmount = dis.readUnsignedByte();
            for (int i = 0; i < customInstrumentsAmount; ++i) {
                NbsCustomInstrument customInstrument = new NbsCustomInstrument();
                customInstrument.setName(NbsIo.readString(dis));
                customInstrument.setSoundFilePath(NbsIo.readString(dis));
                customInstrument.setPitch(dis.readByte());
                customInstrument.setPressKey(dis.readBoolean());
                customInstruments.add(customInstrument);
            }
        }
        IdentityHashMap<NbsCustomInstrument, NbsCustomInstrument> customInstrumentMap = new IdentityHashMap<NbsCustomInstrument, NbsCustomInstrument>(customInstruments.size());
        for (NbsCustomInstrument customInstrument : customInstruments) {
            customInstrumentMap.put(customInstrument, customInstrument.copy().setPitch((byte)45));
        }
        song.getTempoEvents().set(0, (float)song.getTempo() / 100.0f);
        boolean hasSoloLayers = layers.values().stream().anyMatch(layer -> layer.getStatus() == NbsLayer.Status.SOLO);
        for (NbsLayer layer4 : layers.values()) {
            for (Map.Entry<Integer, NbsNote> noteEntry : layer4.getNotes().entrySet()) {
                NbsNote nbsNote = noteEntry.getValue();
                Note note = new Note();
                note.setNbsKey((float)NbsDefinitions.getEffectivePitch(nbsNote) / 100.0f);
                note.setVolume((float)layer4.getVolume() / 100.0f * ((float)nbsNote.getVelocity() / 100.0f));
                if (layer4.getPanning() == 100) {
                    note.setPanning((float)(nbsNote.getPanning() - 100) / 100.0f);
                } else {
                    note.setPanning((float)(layer4.getPanning() - 100 + (nbsNote.getPanning() - 100)) / 200.0f);
                }
                if (nbsNote.getInstrument() < song.getVanillaInstrumentCount()) {
                    note.setInstrument(MinecraftInstrument.fromNbsId((byte)nbsNote.getInstrument()));
                } else {
                    NbsCustomInstrument nbsCustomInstrument = customInstruments.get(nbsNote.getInstrument() - song.getVanillaInstrumentCount());
                    if (song.getVersion() >= 4 && "Tempo Changer".equals(nbsCustomInstrument.getName())) {
                        song.getTempoEvents().set(noteEntry.getKey(), Math.abs((float)nbsNote.getPitch() / 15.0f));
                        continue;
                    }
                    int pitchModifier = nbsCustomInstrument.getPitch() - 45;
                    if (pitchModifier != 0) {
                        note.setNbsKey(note.getNbsKey() + pitchModifier);
                        note.setInstrument((Instrument)customInstrumentMap.get(nbsCustomInstrument));
                    } else {
                        note.setInstrument(nbsCustomInstrument);
                    }
                }
                if (layer4.getStatus() == NbsLayer.Status.LOCKED) {
                    note.setVolume(0.0f);
                } else if (hasSoloLayers && layer4.getStatus() != NbsLayer.Status.SOLO) {
                    note.setVolume(0.0f);
                }
                song.getNotes().add((int)noteEntry.getKey(), note);
            }
        }
        return song;
    }

    /*
     * WARNING - void declaration
     */
    public static void writeSong(NbsSong song, OutputStream os) throws IOException {
        void var5_9;
        if (song.getVersion() < 0 || song.getVersion() > 5) {
            throw new IllegalArgumentException("Unsupported NBS version: " + song.getVersion());
        }
        if (song.getLayerCount() > song.getLayers().size()) {
            throw new IllegalArgumentException("Layer count must be less than or equal to the amount of layers");
        }
        LittleEndianDataOutputStream dos = new LittleEndianDataOutputStream((OutputStream)new BufferedOutputStream(os, 0x100000));
        if (song.getVersion() == 0) {
            dos.writeShort((int)song.getLength());
        } else {
            dos.writeShort(0);
            dos.writeByte((int)song.getVersion());
            dos.writeByte(song.getVanillaInstrumentCount());
            if (song.getVersion() >= 3) {
                dos.writeShort((int)song.getLength());
            }
        }
        dos.writeShort((int)song.getLayerCount());
        NbsIo.writeString(dos, song.getTitleOr(""));
        NbsIo.writeString(dos, song.getAuthorOr(""));
        NbsIo.writeString(dos, song.getOriginalAuthorOr(""));
        NbsIo.writeString(dos, song.getDescriptionOr(""));
        dos.writeShort((int)song.getTempo());
        dos.writeBoolean(song.isAutoSave());
        dos.writeByte((int)song.getAutoSaveInterval());
        dos.writeByte((int)song.getTimeSignature());
        dos.writeInt(song.getMinutesSpent());
        dos.writeInt(song.getLeftClicks());
        dos.writeInt(song.getRightClicks());
        dos.writeInt(song.getNoteBlocksAdded());
        dos.writeInt(song.getNoteBlocksRemoved());
        NbsIo.writeString(dos, song.getSourceFileNameOr(""));
        if (song.getVersion() >= 4) {
            dos.writeBoolean(song.isLoop());
            dos.writeByte((int)song.getMaxLoopCount());
            dos.writeShort((int)song.getLoopStartTick());
        }
        TreeMap<Integer, Map> notes = new TreeMap<Integer, Map>();
        for (Map.Entry<Integer, NbsLayer> entry : song.getLayers().entrySet()) {
            for (Map.Entry<Integer, NbsNote> noteEntry : entry.getValue().getNotes().entrySet()) {
                notes.computeIfAbsent(noteEntry.getKey(), k -> new TreeMap()).put(entry.getKey(), noteEntry.getValue());
            }
        }
        int lastTick = -1;
        for (Map.Entry entry : notes.entrySet()) {
            dos.writeShort((Integer)entry.getKey() - lastTick);
            lastTick = (Integer)entry.getKey();
            int lastLayer = -1;
            for (Map.Entry layerEntry : ((Map)entry.getValue()).entrySet()) {
                dos.writeShort((Integer)layerEntry.getKey() - lastLayer);
                lastLayer = (Integer)layerEntry.getKey();
                NbsNote note = (NbsNote)layerEntry.getValue();
                dos.writeByte((int)note.getInstrument());
                dos.writeByte((int)note.getKey());
                if (song.getVersion() < 4) continue;
                dos.writeByte((int)note.getVelocity());
                dos.writeByte((int)note.getPanning());
                dos.writeShort((int)note.getPitch());
            }
            dos.writeShort(0);
        }
        dos.writeShort(0);
        boolean bl = false;
        while (var5_9 < song.getLayerCount()) {
            NbsLayer nbsLayer = song.getLayers().get((int)var5_9);
            NbsIo.writeString(dos, nbsLayer.getNameOr(""));
            if (song.getVersion() >= 4) {
                switch (nbsLayer.getStatus()) {
                    case NONE: {
                        dos.writeByte(0);
                        break;
                    }
                    case LOCKED: {
                        dos.writeByte(1);
                        break;
                    }
                    case SOLO: {
                        dos.writeByte(2);
                    }
                }
            }
            dos.writeByte((int)nbsLayer.getVolume());
            if (song.getVersion() >= 2) {
                dos.writeByte((int)nbsLayer.getPanning());
            }
            ++var5_9;
        }
        dos.writeByte(song.getCustomInstruments().size());
        for (NbsCustomInstrument nbsCustomInstrument : song.getCustomInstruments()) {
            NbsIo.writeString(dos, nbsCustomInstrument.getNameOr(""));
            NbsIo.writeString(dos, nbsCustomInstrument.getSoundFilePathOr(""));
            dos.writeByte((int)nbsCustomInstrument.getPitch());
            dos.writeBoolean(nbsCustomInstrument.isPressKey());
        }
        dos.flush();
    }

    private static String readString(LittleEndianDataInputStream dis) throws IOException {
        int length;
        StringBuilder builder = new StringBuilder(length);
        for (length = dis.readInt(); length > 0; --length) {
            builder.append((char)dis.readByte());
        }
        return builder.toString();
    }

    private static void writeString(LittleEndianDataOutputStream dos, String string) throws IOException {
        dos.writeInt(string.length());
        for (char c : string.toCharArray()) {
            dos.writeByte((int)c);
        }
    }
}

