/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.UnsupportedCharsetException;
import nu.validator.htmlparser.common.CharacterHandler;
import nu.validator.htmlparser.common.EncodingDeclarationHandler;
import nu.validator.htmlparser.common.Heuristics;
import nu.validator.htmlparser.common.TokenHandler;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.extra.NormalizationChecker;
import nu.validator.htmlparser.impl.Tokenizer;
import nu.validator.htmlparser.impl.UTF16Buffer;
import nu.validator.htmlparser.io.Confidence;
import nu.validator.htmlparser.io.Encoding;
import nu.validator.htmlparser.io.HtmlInputStreamReader;
import nu.validator.htmlparser.rewindable.RewindableInputStream;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Driver
implements EncodingDeclarationHandler {
    private Reader reader;
    private RewindableInputStream rewindableInputStream;
    private boolean swallowBom;
    private Encoding characterEncoding;
    private boolean allowRewinding = true;
    private Heuristics heuristics = Heuristics.NONE;
    private final Tokenizer tokenizer;
    private Confidence confidence;
    private CharacterHandler[] characterHandlers = new CharacterHandler[0];

    public Driver(TokenHandler tokenHandler) {
        this.tokenizer = new Tokenizer(tokenHandler, this);
    }

    public Driver(TokenHandler tokenHandler, boolean newAttributesEachTime) {
        this.tokenizer = new Tokenizer(tokenHandler, this, newAttributesEachTime);
    }

    public boolean isAllowRewinding() {
        return this.allowRewinding;
    }

    public void setAllowRewinding(boolean allowRewinding) {
        this.allowRewinding = allowRewinding;
    }

    public void setCheckingNormalization(boolean enable) {
        if (enable) {
            if (this.isCheckingNormalization()) {
                return;
            }
            NormalizationChecker normalizationChecker = new NormalizationChecker(this.tokenizer);
            normalizationChecker.setErrorHandler(this.tokenizer.getErrorHandler());
        } else if (this.isCheckingNormalization()) {
            CharacterHandler[] newHandlers = new CharacterHandler[this.characterHandlers.length - 1];
            boolean skipped = false;
            int j = 0;
            for (int i = 0; i < this.characterHandlers.length; ++i) {
                CharacterHandler ch = this.characterHandlers[i];
                if (!skipped && ch instanceof NormalizationChecker) continue;
                newHandlers[j] = ch;
                ++j;
            }
            this.characterHandlers = newHandlers;
        } else {
            return;
        }
    }

    public void addCharacterHandler(CharacterHandler characterHandler) {
        if (characterHandler == null) {
            throw new IllegalArgumentException("Null argument.");
        }
        CharacterHandler[] newHandlers = new CharacterHandler[this.characterHandlers.length + 1];
        System.arraycopy(this.characterHandlers, 0, newHandlers, 0, this.characterHandlers.length);
        newHandlers[this.characterHandlers.length] = characterHandler;
        this.characterHandlers = newHandlers;
    }

    public boolean isCheckingNormalization() {
        for (int i = 0; i < this.characterHandlers.length; ++i) {
            CharacterHandler ch = this.characterHandlers[i];
            if (!(ch instanceof NormalizationChecker)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void tokenize(InputSource is) throws SAXException, IOException {
        block41: {
            Throwable t;
            block38: {
                if (is == null) {
                    throw new IllegalArgumentException("InputSource was null.");
                }
                this.tokenizer.start();
                this.confidence = Confidence.TENTATIVE;
                this.swallowBom = true;
                this.rewindableInputStream = null;
                this.tokenizer.initLocation(is.getPublicId(), is.getSystemId());
                this.reader = is.getCharacterStream();
                this.characterEncoding = this.encodingFromExternalDeclaration(is.getEncoding());
                if (this.reader == null) {
                    InputStream inputStream = is.getByteStream();
                    if (inputStream == null) {
                        throw new SAXException("Both streams in InputSource were null.");
                    }
                    if (this.characterEncoding == null) {
                        if (this.allowRewinding) {
                            this.rewindableInputStream = new RewindableInputStream(inputStream);
                            inputStream = this.rewindableInputStream;
                        }
                        this.reader = new HtmlInputStreamReader(inputStream, this.tokenizer.getErrorHandler(), this.tokenizer, this, this.heuristics);
                    } else {
                        this.becomeConfident();
                        this.reader = new HtmlInputStreamReader(inputStream, this.tokenizer.getErrorHandler(), this.tokenizer, this, this.characterEncoding);
                    }
                } else {
                    this.becomeConfident();
                }
                t = null;
                while (true) {
                    try {
                        for (int i = 0; i < this.characterHandlers.length; ++i) {
                            CharacterHandler ch = this.characterHandlers[i];
                            ch.start();
                        }
                        this.runStates();
                        if (this.confidence != Confidence.TENTATIVE || this.tokenizer.isAlreadyComplainedAboutNonAscii()) break;
                        this.warnWithoutLocation("The character encoding of the document was not declared.");
                    }
                    catch (ReparseException e) {
                        if (this.rewindableInputStream == null) {
                            this.tokenizer.fatal("Changing encoding at this point would need non-streamable behavior.");
                            continue;
                        }
                        this.rewindableInputStream.rewind();
                        this.becomeConfident();
                        this.reader = new HtmlInputStreamReader((InputStream)this.rewindableInputStream, this.tokenizer.getErrorHandler(), this.tokenizer, this, this.characterEncoding);
                        continue;
                    }
                    break;
                }
                Object var6_7 = null;
                try {
                    this.tokenizer.end();
                    this.characterEncoding = null;
                    for (int i = 0; i < this.characterHandlers.length; ++i) {
                        CharacterHandler ch = this.characterHandlers[i];
                        ch.end();
                    }
                    this.reader.close();
                    this.reader = null;
                    this.rewindableInputStream = null;
                }
                catch (Throwable tr2) {
                    if (t != null) break block38;
                    t = tr2;
                }
            }
            if (t != null) {
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                if (t instanceof SAXException) {
                    throw (SAXException)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new RuntimeException(t);
            }
            break block41;
            {
                catch (Throwable tr) {
                    block39: {
                        t = tr;
                        Object var6_8 = null;
                        try {
                            this.tokenizer.end();
                            this.characterEncoding = null;
                            for (int i = 0; i < this.characterHandlers.length; ++i) {
                                CharacterHandler ch = this.characterHandlers[i];
                                ch.end();
                            }
                            this.reader.close();
                            this.reader = null;
                            this.rewindableInputStream = null;
                        }
                        catch (Throwable tr2) {
                            if (t != null) break block39;
                            t = tr2;
                        }
                    }
                    if (t != null) {
                        if (t instanceof IOException) {
                            throw (IOException)t;
                        }
                        if (t instanceof SAXException) {
                            throw (SAXException)t;
                        }
                        if (t instanceof RuntimeException) {
                            throw (RuntimeException)t;
                        }
                        if (t instanceof Error) {
                            throw (Error)t;
                        }
                        throw new RuntimeException(t);
                    }
                }
            }
            catch (Throwable throwable) {
                block40: {
                    Object var6_9 = null;
                    try {
                        this.tokenizer.end();
                        this.characterEncoding = null;
                        for (int i = 0; i < this.characterHandlers.length; ++i) {
                            CharacterHandler ch = this.characterHandlers[i];
                            ch.end();
                        }
                        this.reader.close();
                        this.reader = null;
                        this.rewindableInputStream = null;
                    }
                    catch (Throwable tr2) {
                        if (t != null) break block40;
                        t = tr2;
                    }
                }
                if (t != null) {
                    if (t instanceof IOException) {
                        throw (IOException)t;
                    }
                    if (t instanceof SAXException) {
                        throw (SAXException)t;
                    }
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    if (t instanceof Error) {
                        throw (Error)t;
                    }
                    throw new RuntimeException(t);
                }
                throw throwable;
            }
        }
    }

    void dontSwallowBom() {
        this.swallowBom = false;
    }

    private void runStates() throws SAXException, IOException {
        char[] buffer = new char[2048];
        UTF16Buffer bufr = new UTF16Buffer(buffer, 0, 0);
        boolean lastWasCR = false;
        int len = -1;
        len = this.reader.read(buffer);
        if (len != -1) {
            CharacterHandler ch;
            int i;
            assert (len > 0);
            int offset = 0;
            int length = len;
            if (this.swallowBom && buffer[0] == '\ufeff') {
                offset = 1;
                --length;
            }
            if (length > 0) {
                for (i = 0; i < this.characterHandlers.length; ++i) {
                    ch = this.characterHandlers[i];
                    ch.characters(buffer, offset, length);
                }
                bufr.setStart(offset);
                bufr.setEnd(offset + length);
                while (bufr.hasMore()) {
                    bufr.adjust(lastWasCR);
                    lastWasCR = false;
                    if (!bufr.hasMore()) continue;
                    lastWasCR = this.tokenizer.tokenizeBuffer(bufr);
                }
            }
            while ((len = this.reader.read(buffer)) != -1) {
                assert (len > 0);
                for (i = 0; i < this.characterHandlers.length; ++i) {
                    ch = this.characterHandlers[i];
                    ch.characters(buffer, 0, len);
                }
                bufr.setStart(0);
                bufr.setEnd(len);
                while (bufr.hasMore()) {
                    bufr.adjust(lastWasCR);
                    lastWasCR = false;
                    if (!bufr.hasMore()) continue;
                    lastWasCR = this.tokenizer.tokenizeBuffer(bufr);
                }
            }
        }
        this.tokenizer.eof();
    }

    public void setEncoding(Encoding encoding, Confidence confidence) {
        this.characterEncoding = encoding;
        if (confidence == Confidence.CERTAIN) {
            this.becomeConfident();
        }
    }

    public void internalEncodingDeclaration(String internalCharset) throws SAXException {
        try {
            Encoding cs;
            internalCharset = Encoding.toAsciiLowerCase(internalCharset);
            if ("utf-16".equals(internalCharset) || "utf-16be".equals(internalCharset) || "utf-16le".equals(internalCharset)) {
                this.tokenizer.errTreeBuilder("Internal encoding declaration specified \u201c" + internalCharset + "\u201d which is not an ASCII superset. Continuing as if the encoding had been \u201cutf-8\u201d.");
                cs = Encoding.UTF8;
                internalCharset = "utf-8";
            } else {
                cs = Encoding.forName(internalCharset);
            }
            Encoding actual = cs.getActualHtmlEncoding();
            if (actual == null) {
                actual = cs;
            }
            if (!actual.isAsciiSuperset()) {
                this.tokenizer.errTreeBuilder("Internal encoding declaration specified \u201c" + internalCharset + "\u201d which is not an ASCII superset. Not changing the encoding.");
                return;
            }
            if (this.characterEncoding == null) {
                return;
            }
            if (this.characterEncoding == actual) {
                this.becomeConfident();
                return;
            }
            if (this.confidence != Confidence.CERTAIN || actual == this.characterEncoding) {
                Encoding newEnc = this.whineAboutEncodingAndReturnActual(internalCharset, cs);
                this.tokenizer.errTreeBuilder("Changing character encoding \u201c" + internalCharset + "\u201d and reparsing.");
                this.characterEncoding = newEnc;
                throw new ReparseException();
            }
            this.tokenizer.errTreeBuilder("Internal encoding declaration \u201c" + internalCharset + "\u201d disagrees with the actual encoding of the document (\u201c" + this.characterEncoding.getCanonName() + "\u201d).");
        }
        catch (UnsupportedCharsetException e) {
            this.tokenizer.errTreeBuilder("Internal encoding declaration named an unsupported chararacter encoding \u201c" + internalCharset + "\u201d.");
        }
    }

    private void becomeConfident() {
        if (this.rewindableInputStream != null) {
            this.rewindableInputStream.willNotRewind();
        }
        this.confidence = Confidence.CERTAIN;
        this.tokenizer.becomeConfident();
    }

    public void setHeuristics(Heuristics heuristics) {
        this.heuristics = heuristics;
    }

    protected void warnWithoutLocation(String message) throws SAXException {
        ErrorHandler errorHandler = this.tokenizer.getErrorHandler();
        if (errorHandler == null) {
            return;
        }
        SAXParseException spe = new SAXParseException(message, null, this.tokenizer.getSystemId(), -1, -1);
        errorHandler.warning(spe);
    }

    protected Encoding encodingFromExternalDeclaration(String encoding) throws SAXException {
        if (encoding == null) {
            return null;
        }
        encoding = Encoding.toAsciiLowerCase(encoding);
        try {
            Encoding cs = Encoding.forName(encoding);
            if ("utf-16".equals(cs.getCanonName()) || "utf-32".equals(cs.getCanonName())) {
                this.swallowBom = false;
            }
            return this.whineAboutEncodingAndReturnActual(encoding, cs);
        }
        catch (UnsupportedCharsetException e) {
            this.tokenizer.err("Unsupported character encoding name: \u201c" + encoding + "\u201d. Will sniff.");
            this.swallowBom = true;
            return null;
        }
    }

    protected Encoding whineAboutEncodingAndReturnActual(String encoding, Encoding cs) throws SAXException {
        String canonName = cs.getCanonName();
        if (!cs.isRegistered()) {
            if (encoding.startsWith("x-")) {
                this.tokenizer.err("The encoding \u201c" + encoding + "\u201d is not an IANA-registered encoding. (Charmod C022)");
            } else {
                this.tokenizer.err("The encoding \u201c" + encoding + "\u201d is not an IANA-registered encoding and did not use the \u201cx-\u201d prefix. (Charmod C023)");
            }
        } else if (!canonName.equals(encoding)) {
            this.tokenizer.err("The encoding \u201c" + encoding + "\u201d is not the preferred name of the character encoding in use. The preferred name is \u201c" + canonName + "\u201d. (Charmod C024)");
        }
        if (cs.isShouldNot()) {
            this.tokenizer.warn("Authors should not use the character encoding \u201c" + encoding + "\u201d. It is recommended to use \u201cUTF-8\u201d.");
        } else if (cs.isLikelyEbcdic()) {
            this.tokenizer.warn("Authors should not use EBCDIC-based encodings. It is recommended to use \u201cUTF-8\u201d.");
        } else if (cs.isObscure()) {
            this.tokenizer.warn("The character encoding \u201c" + encoding + "\u201d is not widely supported. Better interoperability may be achieved by using \u201cUTF-8\u201d.");
        }
        Encoding actual = cs.getActualHtmlEncoding();
        if (actual == null) {
            return cs;
        }
        this.tokenizer.warn("Using \u201c" + actual.getCanonName() + "\u201d instead of the declared encoding \u201c" + encoding + "\u201d.");
        return actual;
    }

    void notifyAboutMetaBoundary() {
        this.tokenizer.notifyAboutMetaBoundary();
    }

    public void setCommentPolicy(XmlViolationPolicy commentPolicy) {
        this.tokenizer.setCommentPolicy(commentPolicy);
    }

    public void setContentNonXmlCharPolicy(XmlViolationPolicy contentNonXmlCharPolicy) {
        this.tokenizer.setContentNonXmlCharPolicy(contentNonXmlCharPolicy);
    }

    public void setContentSpacePolicy(XmlViolationPolicy contentSpacePolicy) {
        this.tokenizer.setContentSpacePolicy(contentSpacePolicy);
    }

    public void setErrorHandler(ErrorHandler eh) {
        this.tokenizer.setErrorHandler(eh);
        for (int i = 0; i < this.characterHandlers.length; ++i) {
            CharacterHandler ch = this.characterHandlers[i];
            if (!(ch instanceof NormalizationChecker)) continue;
            NormalizationChecker nc = (NormalizationChecker)ch;
            nc.setErrorHandler(eh);
        }
    }

    public void setHtml4ModeCompatibleWithXhtml1Schemata(boolean html4ModeCompatibleWithXhtml1Schemata) {
        this.tokenizer.setHtml4ModeCompatibleWithXhtml1Schemata(html4ModeCompatibleWithXhtml1Schemata);
    }

    public void setMappingLangToXmlLang(boolean mappingLangToXmlLang) {
        this.tokenizer.setMappingLangToXmlLang(mappingLangToXmlLang);
    }

    public void setNamePolicy(XmlViolationPolicy namePolicy) {
        this.tokenizer.setNamePolicy(namePolicy);
    }

    public void setXmlnsPolicy(XmlViolationPolicy xmlnsPolicy) {
        this.tokenizer.setXmlnsPolicy(xmlnsPolicy);
    }

    public String getCharacterEncoding() throws SAXException {
        return this.characterEncoding.getCanonName();
    }

    public Locator getDocumentLocator() {
        return this.tokenizer;
    }

    private class ReparseException
    extends SAXException {
        private ReparseException() {
        }
    }
}

