/*
 * Decompiled with CFR 0.152.
 */
package net.rootdev.javardfa;

import com.hp.hpl.jena.iri.IRI;
import com.hp.hpl.jena.iri.IRIFactory;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.rootdev.javardfa.StatementSink;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser
implements ContentHandler {
    static final List<String> _allowed = Arrays.asList("alternate", "appendix", "bookmark", "cite", "chapter", "contents", "copyright", "first", "glossary", "help", "icon", "index", "last", "license", "meta", "next", "p3pv1", "prev", "collection", "role", "section", "stylesheet", "subsection", "start", "top", "up");
    static final Set<String> SpecialRels = new HashSet<String>(_allowed);
    static final IRIFactory IRIFact = IRIFactory.semanticWebImplementation();
    static final XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
    static final XMLEventFactory EventFactory = XMLEventFactory.newInstance();
    private final XMLEventReader reader = null;
    private final StatementSink sink;
    final QName about = new QName("about");
    final QName resource = new QName("resource");
    final QName href = new QName("href");
    final QName src = new QName("src");
    final QName property = new QName("property");
    final QName datatype = new QName("datatype");
    final QName typeof = new QName("typeof");
    final QName rel = new QName("rel");
    final QName rev = new QName("rev");
    final QName content = new QName("content");
    final QName xmllang = new QName("http://www.w3.org/XML/1998/namespace", "lang", "xml");
    final QName lang = new QName("lang");
    final QName fakeXmlLang = new QName("xml:lang");
    final QName base = new QName("http://www.w3.org/1999/xhtml", "base");
    final QName head = new QName("http://www.w3.org/1999/xhtml", "head");
    final QName body = new QName("http://www.w3.org/1999/xhtml", "body");
    final QName input = new QName("input");
    final QName name = new QName("name");
    final QName form = new QName("form");
    final Collection<String> rdfType = Collections.singleton("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
    final String xmlLiteral = "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral";
    final Set<Setting> settings = EnumSet.noneOf(Setting.class);
    int bnodeId = 0;
    private Locator locator;
    private EvalContext context = new EvalContext("http://www.example.com/");
    private List<XMLEvent> queuedEvents;
    private int level = -1;
    private XMLEventWriter xmlWriter;
    private StringWriter literalWriter;
    private String theDatatype;
    private List<String> litProps;

    public Parser(StatementSink sink) {
        this.sink = sink;
        outputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", true);
    }

    public void enable(Setting setting) {
        this.settings.add(setting);
    }

    public void disable(Setting setting) {
        this.settings.remove((Object)setting);
    }

    public void setBase(String base) {
        this.context = new EvalContext(base);
    }

    EvalContext parse(EvalContext context, StartElement element) throws XMLStreamException {
        Attribute nSubj;
        boolean recurse = true;
        boolean skipElement = false;
        String newSubject = null;
        String currentObject = null;
        LinkedList<String> forwardProperties = new LinkedList<String>(context.forwardProperties);
        LinkedList<String> backwardProperties = new LinkedList<String>(context.backwardProperties);
        String currentLanguage = context.language;
        boolean langIsLang = context.langIsLang;
        if (element.getAttributeByName(this.xmllang) != null) {
            currentLanguage = element.getAttributeByName(this.xmllang).getValue();
        }
        if (this.settings.contains((Object)Setting.ManualNamespaces) && element.getAttributeByName(this.fakeXmlLang) != null && !langIsLang) {
            currentLanguage = element.getAttributeByName(this.fakeXmlLang).getValue();
        }
        if (this.settings.contains((Object)Setting.ManualNamespaces) && element.getAttributeByName(this.lang) != null) {
            langIsLang = true;
            currentLanguage = element.getAttributeByName(this.lang).getValue();
        }
        if (this.base.equals(element.getName()) && element.getAttributeByName(this.href) != null) {
            context.setBase(element.getAttributeByName(this.href).getValue());
        }
        if (element.getAttributeByName(this.rev) == null && element.getAttributeByName(this.rel) == null) {
            nSubj = this.findAttribute(element, this.about, this.src, this.resource, this.href);
            if (nSubj != null) {
                newSubject = this.getURI(context.base, element, nSubj);
            } else if (element.getAttributeByName(this.typeof) != null) {
                newSubject = this.body.equals(element.getName()) || this.head.equals(element.getName()) ? context.base : this.createBNode();
            } else {
                if (context.parentObject != null) {
                    newSubject = context.parentObject;
                }
                if (element.getAttributeByName(this.property) == null) {
                    skipElement = true;
                }
            }
        } else {
            nSubj = this.findAttribute(element, this.about, this.src);
            if (nSubj != null) {
                newSubject = this.getURI(context.base, element, nSubj);
            } else if (element.getAttributeByName(this.typeof) != null) {
                newSubject = this.createBNode();
            } else if (context.parentObject != null) {
                newSubject = context.parentObject;
            }
            Attribute cObj = this.findAttribute(element, this.resource, this.href);
            if (cObj != null) {
                currentObject = this.getURI(context.base, element, cObj);
            }
        }
        if (newSubject != null && element.getAttributeByName(this.typeof) != null) {
            List<String> types = this.getURIs(context.base, element, element.getAttributeByName(this.typeof));
            for (String type : types) {
                this.emitTriples(newSubject, this.rdfType, type);
            }
        }
        if (newSubject == null) {
            newSubject = context.parentSubject;
        }
        if (this.settings.contains((Object)Setting.FormMode)) {
            if (this.form.equals(element.getName())) {
                this.emitTriples(newSubject, this.rdfType, "http://www.w3.org/1999/xhtml/vocab/#form");
            }
            if (this.input.equals(element.getName()) && element.getAttributeByName(this.name) != null) {
                currentObject = "?" + element.getAttributeByName(this.name).getValue();
            }
        }
        if (currentObject != null) {
            if (element.getAttributeByName(this.rel) != null) {
                this.emitTriples(newSubject, this.getURIs(context.base, element, element.getAttributeByName(this.rel)), currentObject);
            }
            if (element.getAttributeByName(this.rev) != null) {
                this.emitTriples(currentObject, this.getURIs(context.base, element, element.getAttributeByName(this.rev)), newSubject);
            }
        } else {
            if (element.getAttributeByName(this.rel) != null) {
                forwardProperties.addAll(this.getURIs(context.base, element, element.getAttributeByName(this.rel)));
            }
            if (element.getAttributeByName(this.rev) != null) {
                backwardProperties.addAll(this.getURIs(context.base, element, element.getAttributeByName(this.rev)));
            }
            if (element.getAttributeByName(this.rel) != null || element.getAttributeByName(this.rev) != null) {
                currentObject = this.createBNode();
            }
        }
        if (element.getAttributeByName(this.property) != null) {
            List<String> props = this.getURIs(context.base, element, element.getAttributeByName(this.property));
            String dt = this.getDatatype(element);
            if (element.getAttributeByName(this.content) != null) {
                String lex = element.getAttributeByName(this.content).getValue();
                if (dt == null || dt.length() == 0) {
                    this.emitTriplesPlainLiteral(newSubject, props, lex, currentLanguage);
                } else {
                    this.emitTriplesDatatypeLiteral(newSubject, props, lex, dt);
                }
            } else {
                this.level = 1;
                this.theDatatype = dt;
                this.literalWriter = new StringWriter();
                this.litProps = props;
                if (dt == null) {
                    this.queuedEvents = new LinkedList<XMLEvent>();
                } else if ("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral".equals(dt)) {
                    this.xmlWriter = outputFactory.createXMLEventWriter(this.literalWriter);
                }
            }
        }
        if (!skipElement && newSubject != null) {
            this.emitTriples(context.parentSubject, context.forwardProperties, newSubject);
            this.emitTriples(newSubject, context.backwardProperties, context.parentSubject);
        }
        if (recurse) {
            EvalContext ec = new EvalContext(context);
            if (skipElement) {
                ec.language = currentLanguage;
                ec.langIsLang = langIsLang;
                ec.original = context.original;
            } else {
                ec.parentSubject = newSubject != null ? newSubject : context.parentSubject;
                ec.parentObject = currentObject != null ? currentObject : (newSubject != null ? newSubject : context.parentSubject);
                ec.language = currentLanguage;
                ec.langIsLang = langIsLang;
                ec.forwardProperties = forwardProperties;
                ec.backwardProperties = backwardProperties;
            }
            return ec;
        }
        return null;
    }

    private Attribute findAttribute(StartElement element, QName ... names) {
        for (QName aName : names) {
            Attribute a = element.getAttributeByName(aName);
            if (a == null) continue;
            return a;
        }
        return null;
    }

    private void emitTriples(String subj, Collection<String> props, String obj) {
        for (String prop : props) {
            this.sink.addObject(subj, prop, obj);
        }
    }

    private void emitTriplesPlainLiteral(String subj, Collection<String> props, String lex, String language) {
        for (String prop : props) {
            this.sink.addLiteral(subj, prop, lex, language, null);
        }
    }

    private void emitTriplesDatatypeLiteral(String subj, Collection<String> props, String lex, String datatype) {
        for (String prop : props) {
            this.sink.addLiteral(subj, prop, lex, null, datatype);
        }
    }

    private String getURI(String base, StartElement element, Attribute attr) {
        QName attrName = attr.getName();
        if (attrName.equals(this.href) || attrName.equals(this.src)) {
            if (attr.getValue().length() == 0) {
                return base;
            }
            IRI uri = IRIFact.construct(base);
            IRI resolved = uri.resolve(attr.getValue());
            return resolved.toString();
        }
        if (attrName.equals(this.about) || attrName.equals(this.resource)) {
            return this.expandSafeCURIE(base, element, attr.getValue());
        }
        if (attrName.equals(this.datatype)) {
            return this.expandCURIE(element, attr.getValue());
        }
        throw new RuntimeException("Unexpected attribute: " + attr);
    }

    private List<String> getURIs(String base, StartElement element, Attribute attr) {
        LinkedList<String> uris = new LinkedList<String>();
        String[] curies = attr.getValue().split("\\s+");
        boolean permitReserved = this.rel.equals(attr.getName()) || this.rev.equals(attr.getName());
        for (String curie : curies) {
            String uri;
            boolean isSpecial;
            boolean bl = isSpecial = this.settings.contains((Object)Setting.ManualNamespaces) ? SpecialRels.contains(curie.toLowerCase()) : SpecialRels.contains(curie);
            if (isSpecial && this.settings.contains((Object)Setting.ManualNamespaces)) {
                curie = curie.toLowerCase();
            }
            if (permitReserved && isSpecial) {
                uris.add("http://www.w3.org/1999/xhtml/vocab#" + curie);
                continue;
            }
            if (isSpecial || (uri = this.expandCURIE(element, curie)) == null) continue;
            uris.add(uri);
        }
        return uris;
    }

    private String createBNode() {
        return "_:node" + this.bnodeId++;
    }

    private String expandCURIE(StartElement element, String value) {
        String namespaceURI;
        if (value.startsWith("_:") && element.getNamespaceURI("_") == null) {
            return value;
        }
        if (this.settings.contains((Object)Setting.FormMode) && value.startsWith("?")) {
            return value;
        }
        int offset = value.indexOf(":") + 1;
        if (offset == 0) {
            return null;
        }
        String prefix = value.substring(0, offset - 1);
        String string = namespaceURI = prefix.length() == 0 ? "http://www.w3.org/1999/xhtml/vocab#" : element.getNamespaceURI(prefix);
        if (namespaceURI == null) {
            return null;
        }
        if (offset != value.length() && value.charAt(offset) == '#') {
            ++offset;
        }
        if (namespaceURI.endsWith("/") || namespaceURI.endsWith("#")) {
            return namespaceURI + value.substring(offset);
        }
        return namespaceURI + "#" + value.substring(offset);
    }

    private String expandSafeCURIE(String base, StartElement element, String value) {
        if (value.startsWith("[") && value.endsWith("]")) {
            return this.expandCURIE(element, value.substring(1, value.length() - 1));
        }
        if (value.length() == 0) {
            return base;
        }
        if (this.settings.contains((Object)Setting.FormMode) && value.startsWith("?")) {
            return value;
        }
        IRI uri = IRIFact.construct(base);
        IRI resolved = uri.resolve(value);
        return resolved.toString();
    }

    private String getDatatype(StartElement element) {
        Attribute de = element.getAttributeByName(this.datatype);
        if (de == null) {
            return null;
        }
        String dt = de.getValue();
        if (dt.length() == 0) {
            return dt;
        }
        return this.expandCURIE(element, dt);
    }

    private void getNamespaces(Attributes attrs) {
        for (int i = 0; i < attrs.getLength(); ++i) {
            String qname = attrs.getQName(i);
            String prefix = this.getPrefix(qname);
            if (!"xmlns".equals(prefix)) continue;
            this.context.setNamespaceURI(this.getLocal(prefix, qname), attrs.getValue(i));
        }
    }

    private String getPrefix(String qname) {
        if (!qname.contains(":")) {
            return "";
        }
        return qname.substring(0, qname.indexOf(":"));
    }

    private String getLocal(String prefix, String qname) {
        if (prefix.length() == 0) {
            return qname;
        }
        return qname.substring(prefix.length() + 1);
    }

    @Override
    public void setDocumentLocator(Locator arg0) {
        this.locator = arg0;
    }

    @Override
    public void startDocument() throws SAXException {
        this.sink.start();
    }

    @Override
    public void endDocument() throws SAXException {
        this.sink.end();
    }

    @Override
    public void startPrefixMapping(String arg0, String arg1) throws SAXException {
        this.context.setNamespaceURI(arg0, arg1);
    }

    @Override
    public void endPrefixMapping(String arg0) throws SAXException {
    }

    @Override
    public void startElement(String arg0, String localname, String qname, Attributes arg3) throws SAXException {
        try {
            String prefix;
            String string = prefix = localname.equals(qname) ? "" : qname.substring(0, qname.indexOf(58));
            if (this.settings.contains((Object)Setting.ManualNamespaces)) {
                this.getNamespaces(arg3);
            }
            StartElement e = EventFactory.createStartElement(prefix, arg0, localname, this.fromAttributes(arg3), null, this.context);
            if (this.level != -1) {
                this.handleForLiteral(e);
                return;
            }
            this.context = this.parse(this.context, e);
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException("Streaming issue", ex);
        }
    }

    @Override
    public void endElement(String arg0, String localname, String qname) throws SAXException {
        if (this.level != -1) {
            String prefix = localname.equals(qname) ? "" : qname.substring(0, qname.indexOf(58));
            EndElement e = EventFactory.createEndElement(prefix, arg0, localname);
            this.handleForLiteral(e);
            if (this.level != -1) {
                return;
            }
        }
        this.context = this.context.parent;
    }

    @Override
    public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
        if (this.level != -1) {
            Characters e = EventFactory.createCharacters(String.valueOf(arg0, arg1, arg2));
            this.handleForLiteral(e);
            return;
        }
    }

    @Override
    public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        if (this.level != -1) {
            Characters e = EventFactory.createIgnorableSpace(String.valueOf(arg0, arg1, arg2));
            this.handleForLiteral(e);
        }
    }

    @Override
    public void processingInstruction(String arg0, String arg1) throws SAXException {
    }

    @Override
    public void skippedEntity(String arg0) throws SAXException {
    }

    private Iterator fromAttributes(Attributes attributes) {
        LinkedList<Attribute> toReturn = new LinkedList<Attribute>();
        boolean haveLang = false;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String qname = attributes.getQName(i);
            String prefix = qname.contains(":") ? qname.substring(0, qname.indexOf(":")) : "";
            Attribute attr = EventFactory.createAttribute(prefix, attributes.getURI(i), attributes.getLocalName(i), attributes.getValue(i));
            if (this.xmllang.getLocalPart().equals(attributes.getLocalName(i)) && this.xmllang.getNamespaceURI().equals(attributes.getURI(i))) {
                haveLang = true;
            }
            toReturn.add(attr);
        }
        if (this.level == 1 && this.context.language != null && !haveLang) {
            toReturn.add(EventFactory.createAttribute(this.xmllang, this.context.language));
        }
        return toReturn.iterator();
    }

    private void handleForLiteral(XMLEvent e) {
        try {
            this.handleForLiteralEx(e);
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException("Literal handling error", ex);
        }
        catch (IOException ex) {
            throw new RuntimeException("Literal handling error", ex);
        }
    }

    private void handleForLiteralEx(XMLEvent e) throws XMLStreamException, IOException {
        if (e.isStartElement()) {
            ++this.level;
            if (this.queuedEvents != null) {
                this.xmlWriter = outputFactory.createXMLEventWriter(this.literalWriter);
                for (XMLEvent ev : this.queuedEvents) {
                    this.xmlWriter.add(ev);
                }
                this.queuedEvents = null;
                this.theDatatype = "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral";
            }
        }
        if (e.isEndElement()) {
            --this.level;
            if (this.level == 0) {
                if (this.xmlWriter != null) {
                    this.xmlWriter.close();
                } else if (this.queuedEvents != null) {
                    for (XMLEvent ev : this.queuedEvents) {
                        this.literalWriter.append(ev.asCharacters().getData());
                    }
                }
                String lex = this.literalWriter.toString();
                if (this.theDatatype == null || this.theDatatype.length() == 0) {
                    this.emitTriplesPlainLiteral(this.context.parentSubject, this.litProps, lex, this.context.language);
                } else {
                    this.emitTriplesDatatypeLiteral(this.context.parentSubject, this.litProps, lex, this.theDatatype);
                }
                this.queuedEvents = null;
                this.xmlWriter = null;
                this.literalWriter = null;
                this.theDatatype = null;
                this.litProps = null;
                this.level = -1;
                return;
            }
        }
        if (this.xmlWriter != null) {
            this.xmlWriter.add(e);
        } else if (e.isCharacters() && this.queuedEvents != null) {
            this.queuedEvents.add(e);
        } else if (e.isCharacters()) {
            this.literalWriter.append(e.asCharacters().getData());
        }
    }

    static class EvalContext
    implements NamespaceContext {
        EvalContext parent;
        String base;
        String parentSubject;
        String parentObject;
        String language;
        List<String> forwardProperties;
        List<String> backwardProperties;
        Map<String, String> prefixToUri = new HashMap<String, String>();
        boolean original;
        boolean langIsLang = false;

        private EvalContext(String base) {
            this.base = base;
            this.parentSubject = base;
            this.forwardProperties = new LinkedList<String>();
            this.backwardProperties = new LinkedList<String>();
            this.original = true;
        }

        public EvalContext(EvalContext toCopy) {
            this.base = toCopy.base;
            this.parentSubject = toCopy.parentSubject;
            this.parentObject = toCopy.parentObject;
            this.language = toCopy.language;
            this.forwardProperties = new LinkedList<String>(toCopy.forwardProperties);
            this.backwardProperties = new LinkedList<String>(toCopy.backwardProperties);
            this.langIsLang = toCopy.langIsLang;
            this.original = false;
            this.parent = toCopy;
        }

        public void setBase(String abase) {
            this.base = abase.contains("#") ? abase.substring(0, abase.indexOf("#")) : abase;
            if (this.original) {
                this.parentSubject = this.base;
            }
            if (this.parent != null) {
                this.parent.setBase(this.base);
            }
        }

        public void setNamespaceURI(String prefix, String uri) {
            if (uri.length() == 0) {
                uri = this.base;
            }
            this.prefixToUri.put(prefix, uri);
        }

        public String getNamespaceURI(String prefix) {
            if (this.prefixToUri.containsKey(prefix)) {
                return this.prefixToUri.get(prefix);
            }
            if (this.parent != null) {
                return this.parent.getNamespaceURI(prefix);
            }
            return null;
        }

        public String getPrefix(String uri) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Iterator getPrefixes(String uri) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Setting {
        FormMode,
        ManualNamespaces;

    }
}

