/*
 * Decompiled with CFR 0.152.
 */
package net.roseboy.jeee.code.utils;

import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.roseboy.jeee.code.entity.ColumnInfo;
import net.roseboy.jeee.code.entity.TableInfo;
import net.roseboy.jeee.core.common.SqlHelper;
import net.roseboy.jeee.core.util.DateUtils;
import net.roseboy.jeee.core.util.Db;
import net.roseboy.jeee.core.util.IoUtils;
import net.roseboy.jeee.core.util.Record;

public class CodeGenUtils {
    public static final String user = "root";
    public static final String pass = "yiyonglianyou000000";
    public static final String server = "211.157.179.73:9506";
    public static final String DbName = "yiyon_tianjintaida";
    public static final String codePath = "/Users/roseboy/Desktop/src";
    public static final Map<String, String> TYPEMAP = new HashMap<String, String>(){
        {
            this.put("varchar", "String");
            this.put("longtext", "String");
            this.put("mediumtext", "String");
            this.put("char", "String");
            this.put("text", "String");
            this.put("int", "Integer");
            this.put("bigint", "BigInteger");
            this.put("bool", "Boolean");
            this.put("float", "Float");
            this.put("double", "Double");
            this.put("decimal", "BigDecimal");
            this.put("datetime", "Date");
            this.put("date", "Date");
            this.put("time", "Date");
            this.put("timestamp", "Date");
            this.put("tinyblob", "byte[]");
            this.put("longblob", "byte[]");
            this.put("blob", "byte[]");
            this.put("smallint", "Integer");
            this.put("tinyint", "Integer");
            this.put("bit", "Byte");
            this.put("service", "Service");
            this.put("dao", "Dao");
            this.put("entity", "");
            this.put("web", "Controller");
        }
    };

    public static void main(String[] args) {
        ArrayList<TableInfo> tables = new ArrayList<TableInfo>();
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("projectName", "\u5929\u6d25\u6cf0\u8fbe\u5fae\u7535\u5b50\u8d44\u4ea7\u7ba1\u7406\u7cfb\u7edf");
        model.put("date", DateUtils.parseDate((Date)new Date()));
        model.put("author", "CodeGenUtils");
        tables.add(new TableInfo("assets_report", "com.yiyon.assets", "AssetsReport", "\u8d44\u4ea7\u62a5\u5907"));
        tables.add(new TableInfo("assets_report_detail", "com.yiyon.assets", "AssetsReportDetail", "\u8d44\u4ea7\u62a5\u5907\u5355\u660e\u7ec6"));
        tables.add(new TableInfo("assets_card", "com.yiyon.assets", "AssetsCard", "\u8d44\u4ea7\u5361\u7247"));
        tables.add(new TableInfo("assets_inspection", "com.yiyon.assets", "AssetsInspection", "\u8d44\u4ea7\u5de1\u68c0\u8ba1\u5212"));
        tables.add(new TableInfo("assets_inspection_detail", "com.yiyon.assets", "AssetsInspectionDetail", "\u5de1\u68c0\u8ba1\u5212\u6240\u542b\u8d44\u4ea7"));
        tables.add(new TableInfo("assets_raise_repair", "com.yiyon.assets", "AssetsRaiseRepair", "\u8d44\u4ea7\u62a5\u4fee\u5355"));
        tables.add(new TableInfo("assets_raise_repair_detail", "com.yiyon.assets", "AssetsRaiseRepairDetail", "\u62a5\u4fee\u5355\u6240\u542b\u8d44\u4ea7"));
        tables.add(new TableInfo("assets_repair", "com.yiyon.assets", "AssetsRepair", "\u8d44\u4ea7\u7ef4\u4fee\u5355"));
        tables.add(new TableInfo("assets_repair_detail", "com.yiyon.assets", "AssetsRepairDetail", "\u8d44\u4ea7\u7ef4\u4fee\u8be6\u7ec6\u4fe1\u606f"));
        tables.add(new TableInfo("assets_repair_result", "com.yiyon.assets", "AssetsRepairResult", "\u7ef4\u4fee\u5b9e\u9645\u627f\u529e\u7ed3\u679c"));
        tables.add(new TableInfo("assets_internal_transfer", "com.yiyon.assets", "AssetsInternalTransfer", "\u8d44\u4ea7\u5185\u90e8\u8c03\u62e8\u5355"));
        tables.add(new TableInfo("assets_internal_transfer_detail", "com.yiyon.assets", "AssetsInternalTransferDetail", "\u5185\u90e8\u8c03\u62e8\u5355\u6240\u542b\u8d44\u4ea7\u53ca\u627f\u529e\u7ed3\u679c"));
        tables.add(new TableInfo("assets_external_transfer", "com.yiyon.assets", "AssetsExternalTransfer", "\u8d44\u4ea7\u5916\u90e8\u8f6c\u79fb\u5355"));
        tables.add(new TableInfo("assets_external_transfer_detail", "com.yiyon.assets", "AssetsExternalTransferDetail", "\u5916\u90e8\u8c03\u62e8\u5355\u6240\u542b\u8d44\u4ea7"));
        tables.add(new TableInfo("assets_handle", "com.yiyon.assets", "AssetsHandle", "\u8d44\u4ea7\u5904\u7f6e\u5355"));
        tables.add(new TableInfo("assets_handle_detail", "com.yiyon.assets", "AssetsHandleDetail", "\u8d44\u4ea7\u5904\u7f6e\u6240\u542b\u8d44\u4ea7"));
        tables.add(new TableInfo("assets_apply", "com.yiyon.assets", "AssetsApply", "\u8d44\u4ea7\u9886\u7528\u7533\u8bf7"));
        tables.add(new TableInfo("assets_apple_detail", "com.yiyon.assets", "AssetsApplyDetail", "\u9886\u7528\u7533\u8bf7\u6240\u542b\u8d44\u4ea7"));
        tables.add(new TableInfo("assets_return", "com.yiyon.assets", "AssetsReturn", "\u8d44\u4ea7\u5f52\u8fd8"));
        tables.add(new TableInfo("assets_return_detail", "com.yiyon.assets", "AssetsReturnDetail", "\u8d44\u4ea7\u5f52\u8fd8\u6240\u542b\u8d44\u4ea7"));
        CodeGenUtils.genCode("/codetpl/entity.ftl", "entity", model, tables, true);
        CodeGenUtils.genCode("/codetpl/dao.ftl", "dao", model, tables, false);
        CodeGenUtils.genCode("/codetpl/service.ftl", "service", model, tables, false);
        CodeGenUtils.genCode("/codetpl/controller.ftl", "web", model, tables, false);
    }

    public static void genCode(String tplPath, String lay, Map<String, Object> model, List<TableInfo> tables, boolean field) {
        String rootpath = CodeGenUtils.class.getResource("/").getPath();
        try {
            rootpath = URLDecoder.decode(rootpath, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        File tpl = new File(rootpath + tplPath);
        String tplStr = IoUtils.readTxtFile((File)tpl);
        for (TableInfo table : tables) {
            String[] packages = table.getPackageName().split("\\.");
            model.put("package", table.getPackageName());
            model.put("module", packages[packages.length - 1]);
            model.put("table", table.getTable());
            model.put("className", table.getClassName());
            model.put("classDesc", table.getMemo());
            if (field) {
                model.put("fieldList", CodeGenUtils.getColumnsInfo(table.getTable()));
            }
            String txt = CodeGenUtils.renderString(tplStr, model);
            CodeGenUtils.createCodeFile(table.getPackageName() + "." + lay, table.getClassName() + TYPEMAP.get(lay) + ".java", txt);
        }
    }

    public static void createCodeFile(String packages, String name, String txt) {
        File target = new File(codePath);
        File dir = new File(target, packages.replace(".", File.separator));
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File file = new File(dir, name);
        IoUtils.writeTxtFile((File)file, (String)txt);
        System.out.println(file.getAbsolutePath());
    }

    private static String renderString(String templateString, Map<String, ?> model) {
        try {
            StringWriter result = new StringWriter();
            Template t = new Template("name", (Reader)new StringReader(templateString), new Configuration());
            t.process(model, (Writer)result);
            return result.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Connection getConnection() {
        String url = "jdbc:mysql://211.157.179.73:9506/yiyon_tianjintaida?user=root&password=yiyonglianyou000000&useUnicode=true&characterEncoding=utf-8";
        Connection conn = null;
        try {
            Class.forName("com.mysql.jdbc.Driver").newInstance();
            conn = DriverManager.getConnection(url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return conn;
    }

    private static List<ColumnInfo> getColumnsInfo(String table) {
        ArrayList<ColumnInfo> fieldList = new ArrayList<ColumnInfo>();
        List records = Db.find((Connection)CodeGenUtils.getConnection(), (String)"SELECT TABLE_NAME,COLUMN_NAME, COLUMN_COMMENT,DATA_TYPE FROM `information_schema`.`COLUMNS` where TABLE_SCHEMA=? AND TABLE_NAME=?", (Object[])new Object[]{DbName, table});
        for (Record record : records) {
            String name = record.getString("COLUMN_NAME");
            if ("id".equals(name) || "create_by".equals(name) || "create_date".equals(name) || "update_by".equals(name) || "update_date".equals(name)) continue;
            String type = record.getString("DATA_TYPE");
            String javaType = TYPEMAP.get(type);
            javaType = javaType == null ? "String" : javaType;
            String javaName = SqlHelper.toJavaName((String)name, null);
            String memo = record.getString("COLUMN_COMMENT");
            String where = "";
            if ("Date".equals(javaType) || "BigDecimal".equals(javaType)) {
                where = "where = \"[]\"";
            }
            fieldList.add(new ColumnInfo(name, type, javaType, javaName, memo, where));
        }
        return fieldList;
    }
}

