/**
* project: ${projectName!}
* file: ${className}.java
* package: ${package}.controller
* date: ${date}
* copyright(c) 2013-2019 yiyon.com.cn
*/
package ${package}.web;

import net.roseboy.apimgr.annotation.JeeeApi;
import net.roseboy.jeee.core.common.ApiJson;
import net.roseboy.jeee.core.common.Page;
import net.roseboy.jeee.core.common.BaseJeeeController;
import net.roseboy.jeee.core.util.ExceptionUtils;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import ${package}.entity.${className};
import ${package}.service.${className}Service;

/**
* ${classDesc} Controller
*
* @author ${author}
*/
@JeeeApi("${classDesc}")
@Controller
@ResponseBody
@RequestMapping("${module!}/${className?uncap_first}")
@RequiresAuthentication
public class ${className}Controller extends BaseJeeeController {
    @Autowired
    ${className}Service ${className?uncap_first}Service;

    @JeeeApi(value = "根据id查询", note = "", author = "${author}")
    @GetMapping("get")
    public ApiJson get(String id) {
        ${className} bill = ${className?uncap_first}Service.get(id);
        return apiJson(bill);
    }

    @JeeeApi(value = "分页查询", note = "", author = "${author}")
    @GetMapping("page")
    public ApiJson page(${className} bill) {
        Page<${className}> page = ${className?uncap_first}Service.findPage(page(), bill);
        return apiJson(page);
    }

    @JeeeApi(value = "保存", note = "", author = "${author}")
    @PostMapping("save")
    public ApiJson save(@RequestBody ${className} bill) {
        ${className?uncap_first}Service.save(bill);
        return apiJson(bill);
    }

    @JeeeApi(value = "删除", note = "", author = "${author}")
    @GetMapping("delete")
    public ApiJson delete(String id, String ids) {
        id = ifnull(id, "");
        ids = ifnull(ids, "");
        if (isEmpty(ids) && isEmpty(id)) {
            ExceptionUtils.throwProjectException("id不能为空");
        }
        ${className?uncap_first}Service.delete((id + "," + ids).split(","));
        return apiJson("删除成功");
    }

    @JeeeApi(value = "审批列表", note = "", author = "${author}")
    @GetMapping("auditList")
    public ApiJson auditList(${className} bill) {
        return apiJson(${className?uncap_first}Service.auditList(page(), bill));
    }

    @JeeeApi(value = "审核", note = "agree: yes通过 no驳回", author = "${author}")
    @GetMapping("audit")
    public ApiJson audit(String id, String ids, String agree, String comment) {
        id = ifnull(id, "");
        ids = ifnull(ids, "");
        if (isEmpty(ids) && isEmpty(id)) {
            ExceptionUtils.throwProjectException("id不能为空");
        }

        if (isEmpty(agree)) {
            ExceptionUtils.throwProjectException("agree不能为空");
        }

        ${className?uncap_first}Service.audit("yes".equals(agree), comment, (id + "," + ids).split(","));
        return apiJson("操作成功");
    }

    @JeeeApi(value = "提交", note = "", author = "${author}")
    @GetMapping("commit")
    public ApiJson commit(String id, String ids) {
        id = ifnull(id, "");
        ids = ifnull(ids, "");
        if (isEmpty(ids) && isEmpty(id)) {
            ExceptionUtils.throwProjectException("id不能为空");
        }
        ${className?uncap_first}Service.commit((id + "," + ids).split(","));
        return apiJson("提交成功");
    }

    @JeeeApi(value = "撤销提交", note = "", author = "${author}")
    @GetMapping("cancel")
    public ApiJson cancelSubmit(String id, String ids) {
        id = ifnull(id, "");
        ids = ifnull(ids, "");
        if (isEmpty(ids) && isEmpty(id)) {
            ExceptionUtils.throwProjectException("id不能为空");
        }
        ${className?uncap_first}Service.cancel((id + "," + ids).split(","));
        return apiJson("撤销成功");
    }
}