/**
* project: ${projectName!}
* file: ${className}.java
* package: ${package}.service
* date: ${date}
* copyright(c) 2013-2019 yiyon.com.cn
*/
package ${package}.service;

import net.roseboy.jeee.admin.service.BillNoService;
import net.roseboy.jeee.admin.util.AssertUtils;
import net.roseboy.jeee.core.util.ExceptionUtils;
import net.roseboy.jeee.workflow.service.AuditBussService;
import net.roseboy.jeee.workflow.service.BussContrastService;
import org.springframework.stereotype.Service;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import net.roseboy.jeee.core.common.BaseJeeeService;
import net.roseboy.jeee.core.common.Page;
import ${package}.entity.${className};
import ${package}.dao.${className}Dao;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

/**
* ${classDesc} Service
*
* @author ${author}
*/
@Service
@Transactional
public class ${className}Service extends BaseJeeeService<${className}Dao, ${className}> {
    @Autowired
    private AuditBussService auditBussService;
    @Autowired
    private BussContrastService bussContrastService;
    @Autowired
    private BillNoService billNoService;

    @Override
    public ${className} get(String id) {
        return get(new ${className}(id));
    }

    @Override
    public ${className} get(${className} entity) {
        entity = dao.autoGet(entity);
        return entity;
    }

    @Override
    public Page<${className}> findPage(Page<${className}> page, ${className} entity) {
        entity.setPage(page);
        page.setList(dao.autoQuery(entity));
        return page;
    }

    @Override
    public List<${className}> findList(${className} entity) {
        return dao.autoQuery(entity);
    }

    @Override
    public void save(${className} bill) {
        if (isEmpty(bill.getId())) {
            bill.setCode(billNoService.makeBillNo("{xxx}"));
        }
        super.autoSave(bill);
    }

    @Override
    public void delete(String... ids) {
        for (String id : ids) {
            super.autoDeleteById(new ${className}(id));
        }
    }

    @Override
    public void saveList(List<${className}> list) {
        super.batchSave(list);
    }

    /**
     * 查询本人带审批或已审批
     *
     * @param page
     * @param bill
     * @return
     */
    public Page<${className}> auditList(Page<${className}> page, ${className} bill) {
        String isAudit = bill.getIsAudit();
        bill.setPage(page);
        Map<String, String> id2stateMap = auditBussService.findAuditBillIds(${className}.class, isAudit);
        List<String> ids = new ArrayList<>(id2stateMap.size());
        id2stateMap.forEach((key, value) -> ids.add(key));
        bill.where("IN", "id", ids);
        page = findPage(page, bill);

        //IsAudit给前端判断这个单据是不是本人审过
        for (${className} data : page.getList()) {
            data.setIsAudit(id2stateMap.get(data.getId()).substring(0, 1));
        }
        return page;
    }


    /**
     * 提交单据
     *
     * @param ids 单据id
     */
    public void commit(String... ids) {
        ${className} entity = new ${className}();
        entity.where("IN", "id", ids);
        List<${className}> bills = this.findList(entity);
        for (${className} bill : bills) {
            commit(bill);
        }
    }

    /**
     * 提交单据实体
     *
     * @param bill 单据
     */
    public void commit(${className} bill) {
        //单据校验
        String msg = this.checkValue(bill);
        if (isNotEmpty(msg)) {
            ExceptionUtils.throwProjectException(msg);
        }
        if (0 != bill.getAudit() && -1 != bill.getAudit() && -2 != bill.getAudit()) {
            ExceptionUtils.throwProjectException("单据状态错误，提交失败");
        }
        //获取当前单据类型对饮的流程key
        String workflowKey = bussContrastService.getProcessKeyByBillInfo("{XXX}");
        if (isEmpty(workflowKey)) {
            ExceptionUtils.throwProjectException("未配置单据与审批流程对照，提交错误");
        }
        //对应流程参数传递
        Map<String, Object> vars = new HashMap<>();
        vars.put("id", bill.getId());
        vars.put("billCode", bill.getCode());
        //TODO:把流程中用到的单据字段放到流程变量汇总

        //流程提交
        auditBussService.commit(workflowKey, bill, vars);
    }


    /**
     * 撤销
     *
     * @param ids 单据id
     */
    public void cancel(String... ids) {
        ${className} entity = new ${className}();
        entity.where("IN", "id", ids);
        List<${className}> bills = this.findList(entity);

        for (${className} bill : bills) {
            auditBussService.auditCancel(bill.getProcInsId());

            //TODO:修改单据需要撤回的信息
            dao.updateByTable("labor_push_money", "proc_ins_id", "", "id", bill.getId());
            dao.updateByTable("labor_push_money", "audit", 0, "id", bill.getId());
        }

    }

    /**
     * 审核
     *
     * @param ids     单据id数组
     * @param pass    是否通过
     * @param comment 意见
     */
    public void audit(boolean pass, String comment, String... ids) {
        ${className} entity = new ${className}();
        entity.where("IN", "id", ids);
        List<${className}> bills = this.findList(entity);
        for (${className} bill : bills) {
            if (pass) {
                auditBussService.auditAgree(bill, bill.getProcInsId(), comment, null);
            } else {
                auditBussService.auditReject(bill, bill.getProcInsId(), comment, null);
            }
        }
    }

    /**
     * 校验单据信息
     *
     * @param bill 单据
     * @return 错误信息，校验通过返回null
     */
    public String checkValue(${className} bill) {
        try {
            // 验证单据表头
            //AssertUtils.notNull(bill.getBillDate(), "请填写单据日期");
            //TODO:必填项验证等
        } catch (Exception e) {
            bill.setCheck(false);// 不通过
            e.printStackTrace();
            return e.getMessage();
        }
        bill.setCheck(true);// 通过
        return null;
    }
}