/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.ocrPlugins.aspectRatio;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Stack;
import java.util.logging.Logger;
import net.sourceforge.javaocr.ocrPlugins.aspectRatio.CharacterRatio;
import net.sourceforge.javaocr.ocrPlugins.mseOCR.TrainingImage;
import net.sourceforge.javaocr.scanner.DocumentScanner;
import net.sourceforge.javaocr.scanner.DocumentScannerListener;
import net.sourceforge.javaocr.scanner.DocumentScannerListenerAdaptor;
import net.sourceforge.javaocr.scanner.PixelImage;
import net.sourceforge.javaocr.scanner.accuracy.AccuracyListenerInterface;
import net.sourceforge.javaocr.scanner.accuracy.AccuracyProviderInterface;
import net.sourceforge.javaocr.scanner.accuracy.OCRComp;
import net.sourceforge.javaocr.scanner.accuracy.OCRIdentification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AspectRatioOCR
extends DocumentScannerListenerAdaptor
implements AccuracyProviderInterface {
    private AccuracyListenerInterface listener;
    private final HashMap<Character, ArrayList<TrainingImage>> trainingImages;
    private final ArrayList<CharacterRatio> charRatioList = new ArrayList();
    private DocumentScanner documentScanner = new DocumentScanner();
    private static final Logger LOG = Logger.getLogger(AspectRatioOCR.class.getName());

    public AspectRatioOCR(HashMap<Character, ArrayList<TrainingImage>> trainingImages) {
        this.trainingImages = trainingImages;
        this.processTrainingImages();
    }

    public void scan(BufferedImage targetBfImage) {
        PixelImage pixelImage = new PixelImage((Image)targetBfImage);
        pixelImage.toGrayScale(true);
        pixelImage.filter();
        this.documentScanner.scan(pixelImage, (DocumentScannerListener)this, 0, 0, pixelImage.width, pixelImage.height);
    }

    public void acceptAccuracyListener(AccuracyListenerInterface listener) {
        this.listener = listener;
    }

    public void endRow(PixelImage pixelImage, int y1, int y2) {
        if (this.listener != null) {
            OCRIdentification identAccuracy = new OCRIdentification(OCRComp.ASPECT_RATIO);
            identAccuracy.addChar('\n', 0.0);
            this.listener.processCharOrSpace(identAccuracy);
        }
    }

    public void processChar(PixelImage pixelImage, int x1, int y1, int x2, int y2, int rowY1, int rowY2) {
        int width = x2 - x1;
        int height = y2 - y1;
        double currRatio = this.getRatio(width, height);
        if (this.listener != null) {
            this.listener.processCharOrSpace(this.determineCharacterPossibilities(currRatio));
        }
    }

    public void processSpace(PixelImage pixelImage, int x1, int y1, int x2, int y2) {
        if (this.listener != null) {
            OCRIdentification identAccuracy = new OCRIdentification(OCRComp.ASPECT_RATIO);
            identAccuracy.addChar(' ', 0.0);
            this.listener.processCharOrSpace(identAccuracy);
        }
    }

    private void processTrainingImages() {
        for (Character key : this.trainingImages.keySet()) {
            ArrayList<TrainingImage> charTrainingImages = this.trainingImages.get(key);
            if (charTrainingImages == null) continue;
            for (int i = 0; i < charTrainingImages.size(); ++i) {
                int width = charTrainingImages.get((int)i).width;
                int height = charTrainingImages.get((int)i).height;
                this.charRatioList.add(new CharacterRatio(key.charValue(), this.getRatio(width, height)));
            }
        }
        Collections.sort(this.charRatioList);
    }

    private double getRatio(int width, int height) {
        return (double)width / (double)height;
    }

    private OCRIdentification determineCharacterPossibilities(double targetRatio) {
        double smallestError = Double.MAX_VALUE;
        Stack<CharacterRatio> bestResults = new Stack<CharacterRatio>();
        for (CharacterRatio currChar : this.charRatioList) {
            if (!(Math.abs(currChar.getRatio() - targetRatio) < smallestError)) continue;
            smallestError = Math.abs(currChar.getRatio() - targetRatio);
            bestResults.push(currChar);
        }
        OCRIdentification newIdent = new OCRIdentification(OCRComp.ASPECT_RATIO);
        for (int count = 0; !bestResults.isEmpty() && count < 5; ++count) {
            CharacterRatio currChar = (CharacterRatio)bestResults.pop();
            double errorAmount = Math.abs(targetRatio - currChar.getRatio());
            newIdent.addChar(currChar.getCharacter(), errorAmount);
        }
        return newIdent;
    }
}

