/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.debugging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.semanticweb.owlapi.debugging.AbstractOWLDebugger;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.util.SimpleIRIMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlackBoxOWLDebugger
extends AbstractOWLDebugger {
    private static final Logger logger = Logger.getLogger(BlackBoxOWLDebugger.class.getName());
    private final OWLOntologyManager owlOntologyManager;
    private OWLClass currentClass;
    private OWLOntology debuggingOntology;
    private final Set<OWLAxiom> debuggingAxioms;
    private final Set<OWLEntity> objectsExpandedWithDefiningAxioms;
    private final Set<OWLEntity> objectsExpandedWithReferencingAxioms;
    private final Set<OWLAxiom> expandedWithDefiningAxioms;
    private final Set<OWLAxiom> expandedWithReferencingAxioms;
    private final OWLReasonerFactory reasonerFactory;
    private final Set<OWLAxiom> temporaryAxioms;
    private final Map<OWLAxiom, OWLAxiom> expandedAxiomMap;
    public static final int DEFAULT_INITIAL_EXPANSION_LIMIT = 50;
    private int initialExpansionLimit;
    private int expansionLimit;
    private double expansionFactor;
    private static final int DEFAULT_FAST_PRUNING_WINDOW_SIZE = 10;
    private int fastPruningWindowSize;
    private boolean performRepeatedFastPruning;
    private int satTestCount;
    private int ontologyCounter;

    public BlackBoxOWLDebugger(OWLOntologyManager owlOntologyManager, OWLOntology ontology, OWLReasonerFactory reasonerFactory) {
        super(owlOntologyManager, ontology);
        this.expansionLimit = this.initialExpansionLimit = 50;
        this.expansionFactor = 1.25;
        this.fastPruningWindowSize = 0;
        this.performRepeatedFastPruning = false;
        this.satTestCount = 0;
        this.ontologyCounter = 0;
        this.reasonerFactory = reasonerFactory;
        this.owlOntologyManager = owlOntologyManager;
        this.debuggingAxioms = new LinkedHashSet<OWLAxiom>();
        this.objectsExpandedWithDefiningAxioms = new HashSet<OWLEntity>();
        this.objectsExpandedWithReferencingAxioms = new HashSet<OWLEntity>();
        this.expandedWithDefiningAxioms = new HashSet<OWLAxiom>();
        this.expandedWithReferencingAxioms = new HashSet<OWLAxiom>();
        this.temporaryAxioms = new HashSet<OWLAxiom>();
        this.expandedAxiomMap = new HashMap<OWLAxiom, OWLAxiom>();
        logger.setLevel(Level.INFO);
    }

    @Override
    public void dispose() {
        this.reset();
    }

    private void reset() {
        this.currentClass = null;
        this.debuggingOntology = null;
        this.debuggingAxioms.clear();
        this.objectsExpandedWithDefiningAxioms.clear();
        this.objectsExpandedWithReferencingAxioms.clear();
        this.expandedWithDefiningAxioms.clear();
        this.expandedWithReferencingAxioms.clear();
        this.temporaryAxioms.clear();
        this.expandedAxiomMap.clear();
        this.expansionLimit = this.initialExpansionLimit;
    }

    @Override
    protected OWLClassExpression getCurrentClass() throws OWLException {
        return this.currentClass;
    }

    private OWLClass setupDebuggingClass(OWLClassExpression cls) throws OWLException {
        if (!cls.isAnonymous()) {
            return (OWLClass)cls;
        }
        OWLClass curCls = this.owlOntologyManager.getOWLDataFactory().getOWLClass(BlackBoxOWLDebugger.createIRI());
        HashSet<Object> operands = new HashSet<Object>();
        operands.add(curCls);
        operands.add(cls);
        this.temporaryAxioms.add((OWLAxiom)this.owlOntologyManager.getOWLDataFactory().getOWLEquivalentClassesAxiom(operands));
        for (OWLAxiom ax : this.temporaryAxioms) {
            this.owlOntologyManager.applyChanges(Arrays.asList(new AddAxiom(this.getOWLOntology(), ax)));
        }
        return curCls;
    }

    @Override
    public Set<OWLAxiom> getSOSForIncosistentClass(OWLClassExpression cls) throws OWLException {
        this.reset();
        this.currentClass = this.setupDebuggingClass(cls);
        this.generateSOSAxioms();
        for (OWLAxiom ax : this.temporaryAxioms) {
            this.owlOntologyManager.applyChanges(Arrays.asList(new RemoveAxiom(this.getOWLOntology(), ax)));
        }
        this.debuggingAxioms.removeAll(this.temporaryAxioms);
        this.ontologyCounter = 0;
        return new HashSet<OWLAxiom>(this.debuggingAxioms);
    }

    private int expandAxioms() throws OWLException {
        int added;
        int axiomsAdded = 0;
        int remainingSpace = this.expansionLimit;
        for (OWLAxiom ax : new ArrayList<OWLAxiom>(this.debuggingAxioms)) {
            if (this.expandedWithDefiningAxioms.contains(ax)) continue;
            for (OWLEntity curObj : ax.getSignature()) {
                if (this.objectsExpandedWithDefiningAxioms.contains(curObj)) continue;
                added = this.expandWithDefiningAxioms(curObj, remainingSpace);
                axiomsAdded += added;
                if ((remainingSpace -= added) == 0) {
                    this.expansionLimit = (int)((double)this.expansionLimit * this.expansionFactor);
                    return axiomsAdded;
                }
                this.objectsExpandedWithDefiningAxioms.add(curObj);
            }
            this.expandedWithDefiningAxioms.add(ax);
        }
        if (axiomsAdded > 0) {
            return axiomsAdded;
        }
        for (OWLAxiom ax : new ArrayList<OWLAxiom>(this.debuggingAxioms)) {
            if (this.expandedWithReferencingAxioms.contains(ax)) continue;
            for (OWLEntity curObj : ax.getSignature()) {
                if (this.objectsExpandedWithReferencingAxioms.contains(curObj)) continue;
                added = this.expandWithReferencingAxioms(curObj, this.expansionLimit);
                axiomsAdded += added;
                if ((remainingSpace -= added) == 0) {
                    this.expansionLimit = (int)((double)this.expansionLimit * this.expansionFactor);
                    return axiomsAdded;
                }
                this.objectsExpandedWithReferencingAxioms.add(curObj);
            }
            this.expandedWithReferencingAxioms.add(ax);
        }
        return axiomsAdded;
    }

    private int expandWithDefiningAxioms(OWLEntity obj, int limit) throws OWLException {
        HashSet expansionAxioms = new HashSet();
        for (OWLOntology ont : this.owlOntologyManager.getImportsClosure(this.getOWLOntology())) {
            if (obj instanceof OWLClass) {
                expansionAxioms.addAll(ont.getAxioms((OWLClass)obj));
                continue;
            }
            if (obj instanceof OWLObjectProperty) {
                expansionAxioms.addAll(ont.getAxioms((OWLObjectPropertyExpression)((OWLObjectProperty)obj)));
                continue;
            }
            if (obj instanceof OWLDataProperty) {
                expansionAxioms.addAll(ont.getAxioms((OWLDataProperty)obj));
                continue;
            }
            if (!(obj instanceof OWLIndividual)) continue;
            expansionAxioms.addAll(ont.getAxioms((OWLIndividual)obj));
        }
        expansionAxioms.removeAll(this.debuggingAxioms);
        return BlackBoxOWLDebugger.addMax(expansionAxioms, this.debuggingAxioms, limit);
    }

    private int expandWithReferencingAxioms(OWLEntity obj, int limit) throws OWLException {
        HashSet expansionAxioms = new HashSet();
        for (OWLOntology ont : this.owlOntologyManager.getImportsClosure(this.getOWLOntology())) {
            expansionAxioms.addAll(ont.getReferencingAxioms(obj));
        }
        expansionAxioms.removeAll(this.debuggingAxioms);
        return BlackBoxOWLDebugger.addMax(expansionAxioms, this.debuggingAxioms, limit);
    }

    private static <N extends OWLAxiom> int addMax(Set<N> source, Set<N> dest, int limit) {
        int count = 0;
        for (OWLAxiom obj : source) {
            if (count == limit) break;
            if (obj instanceof OWLAnnotationAxiom || !dest.add(obj)) continue;
            ++count;
        }
        return count;
    }

    private void performFastPruning() throws OWLException {
        logger.setLevel(Level.INFO);
        HashSet<OWLAxiom> axiomWindow = new HashSet<OWLAxiom>();
        Object[] axioms = this.debuggingAxioms.toArray();
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Fast pruning: ");
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("     - Window size: " + this.fastPruningWindowSize);
        }
        int windowCount = this.debuggingAxioms.size() / this.fastPruningWindowSize;
        for (int currentWindow = 0; currentWindow < windowCount; ++currentWindow) {
            axiomWindow.clear();
            int startIndex = currentWindow * this.fastPruningWindowSize;
            int endIndex = startIndex + this.fastPruningWindowSize;
            for (int axiomIndex = startIndex; axiomIndex < endIndex; ++axiomIndex) {
                OWLAxiom currentAxiom = (OWLAxiom)axioms[axiomIndex];
                axiomWindow.add(currentAxiom);
                this.debuggingAxioms.remove(currentAxiom);
            }
            if (!this.isSatisfiable()) continue;
            this.debuggingAxioms.addAll(axiomWindow);
        }
        axiomWindow.clear();
        int remainingAxiomsCount = this.debuggingAxioms.size() % this.fastPruningWindowSize;
        if (remainingAxiomsCount > 0) {
            for (int fragmentIndex = windowCount * this.fastPruningWindowSize; fragmentIndex < axioms.length; ++fragmentIndex) {
                OWLAxiom curAxiom = (OWLAxiom)axioms[fragmentIndex];
                axiomWindow.add(curAxiom);
                this.debuggingAxioms.remove(curAxiom);
            }
            if (this.isSatisfiable()) {
                this.debuggingAxioms.addAll(axiomWindow);
            }
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("    - End of fast pruning");
        }
    }

    private void performSlowPruning() throws OWLException {
        ArrayList<OWLAxiom> axiomsCopy = new ArrayList<OWLAxiom>(this.debuggingAxioms);
        for (OWLAxiom ax : axiomsCopy) {
            this.debuggingAxioms.remove(ax);
            if (!this.isSatisfiable()) continue;
            this.debuggingAxioms.add(ax);
        }
    }

    private boolean isSatisfiable() throws OWLException {
        this.createDebuggingOntology();
        ++this.ontologyCounter;
        OWLReasoner reasoner = this.reasonerFactory.createNonBufferingReasoner(this.debuggingOntology);
        ++this.satTestCount;
        boolean sat = reasoner.isSatisfiable((OWLClassExpression)this.currentClass);
        reasoner.dispose();
        return sat;
    }

    private void createDebuggingOntology() throws OWLException {
        OWLAxiom ax2;
        if (this.debuggingOntology != null) {
            this.owlOntologyManager.removeOntology(this.debuggingOntology);
        }
        IRI iri = BlackBoxOWLDebugger.createIRI();
        SimpleIRIMapper mapper = new SimpleIRIMapper(iri, iri);
        this.owlOntologyManager.addIRIMapper((OWLOntologyIRIMapper)mapper);
        this.debuggingOntology = this.owlOntologyManager.createOntology(iri);
        this.owlOntologyManager.removeIRIMapper((OWLOntologyIRIMapper)mapper);
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        for (OWLAxiom ax2 : this.debuggingAxioms) {
            changes.add(new AddAxiom(this.debuggingOntology, ax2));
        }
        for (OWLAxiom ax2 : this.temporaryAxioms) {
            changes.add(new AddAxiom(this.debuggingOntology, ax2));
        }
        OWLDataFactory factory = this.owlOntologyManager.getOWLDataFactory();
        ax2 = factory.getOWLSubClassOfAxiom((OWLClassExpression)this.currentClass, (OWLClassExpression)factory.getOWLThing());
        changes.add(new AddAxiom(this.debuggingOntology, ax2));
        this.owlOntologyManager.applyChanges(changes);
    }

    private void resetSatisfiabilityTestCounter() {
        this.satTestCount = 0;
    }

    private void generateSOSAxioms() throws OWLException {
        this.resetSatisfiabilityTestCounter();
        this.expandWithDefiningAxioms((OWLEntity)this.currentClass, this.expansionLimit);
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Initial axiom count: " + this.debuggingAxioms.size());
        }
        int totalAdded = 0;
        int expansionCount = 0;
        while (this.isSatisfiable()) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Expanding axioms (expansion " + expansionCount + ")");
            }
            ++expansionCount;
            int numberAdded = this.expandAxioms();
            totalAdded += numberAdded;
            if (logger.isLoggable(Level.INFO)) {
                logger.info("    ... expanded by " + numberAdded);
            }
            if (numberAdded != 0) continue;
            if (logger.isLoggable(Level.INFO)) {
                logger.info("ERROR! Cannot find SOS axioms!");
            }
            this.debuggingAxioms.clear();
            return;
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Total number of axioms added: " + totalAdded);
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("FOUND CLASH! Prunning " + this.debuggingAxioms.size() + " axioms...");
        }
        this.resetSatisfiabilityTestCounter();
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Fast pruning...");
        }
        if (this.performRepeatedFastPruning) {
            this.fastPruningWindowSize = this.debuggingAxioms.size() / 10;
            if (this.fastPruningWindowSize < 10) {
                this.fastPruningWindowSize = 10;
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.info("    Initial fast prunung window size: " + this.fastPruningWindowSize);
            }
            int fastPruningCounter = 0;
            while (this.fastPruningWindowSize != 1) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("    Round: " + fastPruningCounter + " (axioms to prune: " + this.debuggingAxioms.size() + ")");
                }
                ++fastPruningCounter;
                this.performFastPruning();
                this.fastPruningWindowSize /= 3;
                if (this.fastPruningWindowSize >= 1) continue;
                this.fastPruningWindowSize = 1;
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.info("... end of fast pruning. Axioms remaining: " + this.debuggingAxioms.size());
                logger.info("Performed " + this.satTestCount + " satisfiability tests during fast pruning");
            }
        } else {
            this.fastPruningWindowSize = 10;
            this.performFastPruning();
            if (logger.isLoggable(Level.INFO)) {
                logger.info("... end of fast pruning. Axioms remaining: " + this.debuggingAxioms.size());
                logger.info("Performed " + this.satTestCount + " satisfiability tests during fast pruning");
            }
        }
        int totalSatTests = this.satTestCount;
        this.resetSatisfiabilityTestCounter();
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Slow pruning...");
        }
        this.performSlowPruning();
        if (logger.isLoggable(Level.INFO)) {
            logger.info("... end of slow pruning");
            logger.info("Performed " + this.satTestCount + " satisfiability tests during slow pruning");
        }
        totalSatTests += this.satTestCount;
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Total number of satisfiability tests performed: " + totalSatTests);
        }
    }

    private static IRI createIRI() {
        return IRI.create((String)("http://debugging.blackbox#" + System.nanoTime()));
    }
}

