/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.explanation.ordering;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.semanticweb.owlapi.io.OWLObjectRenderer;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import uk.ac.manchester.cs.owl.explanation.ordering.EntailedAxiomTree;
import uk.ac.manchester.cs.owl.explanation.ordering.ExplanationOrderer;
import uk.ac.manchester.cs.owl.explanation.ordering.ExplanationTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AlphaExplanationOrderer
implements ExplanationOrderer {
    protected final OWLObjectRenderer renderer;

    public AlphaExplanationOrderer(OWLObjectRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public ExplanationTree getOrderedExplanation(OWLAxiom entailment, Set<OWLAxiom> axioms) {
        EntailedAxiomTree root = new EntailedAxiomTree(entailment);
        ArrayList<OWLAxiom> sortedAxioms = new ArrayList<OWLAxiom>(axioms);
        Collections.sort(sortedAxioms, new Comparator<OWLAxiom>(){

            @Override
            public int compare(OWLAxiom o1, OWLAxiom o2) {
                return AlphaExplanationOrderer.this.renderer.render((OWLObject)o1).compareTo(AlphaExplanationOrderer.this.renderer.render((OWLObject)o2));
            }
        });
        for (OWLAxiom ax : sortedAxioms) {
            root.addChild(new ExplanationTree(ax));
        }
        return root;
    }
}

