/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.optimizations;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.java.ast.ASTForInit;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTThrowStatement;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;

public class PrematureDeclarationRule
extends AbstractJavaRule {
    @Override
    public Object visit(ASTLocalVariableDeclaration node, Object data) {
        if (node.jjtGetParent() instanceof ASTForInit) {
            return this.visit((JavaNode)node, data);
        }
        String varName = PrematureDeclarationRule.varNameIn(node);
        AbstractJavaNode grandparent = (AbstractJavaNode)node.jjtGetParent().jjtGetParent();
        List<ASTBlockStatement> nextBlocks = PrematureDeclarationRule.blocksAfter(grandparent, node);
        for (ASTBlockStatement block : nextBlocks) {
            if (PrematureDeclarationRule.hasReferencesIn(block, varName)) break;
            if (!this.hasExit(block)) continue;
            this.addViolation(data, node, varName);
            break;
        }
        return this.visit((JavaNode)node, data);
    }

    public static boolean hasAsParentBetween(Node node, Class<?> intermediateParentClass, Node topParent) {
        Node currentParent = node.jjtGetParent();
        while (!currentParent.equals(topParent)) {
            if (!(currentParent = currentParent.jjtGetParent()).getClass().equals(intermediateParentClass)) continue;
            return true;
        }
        return false;
    }

    private boolean hasExit(ASTBlockStatement block) {
        List exitBlocks = block.findDescendantsOfType(ASTReturnStatement.class);
        exitBlocks.addAll(block.findDescendantsOfType(ASTThrowStatement.class));
        if (exitBlocks.isEmpty()) {
            return false;
        }
        boolean result = false;
        for (int i = 0; i < exitBlocks.size(); ++i) {
            Node exitNode = (Node)exitBlocks.get(i);
            if (PrematureDeclarationRule.hasAsParentBetween(exitNode, ASTMethodDeclaration.class, (Node)block)) continue;
            result = true;
            break;
        }
        return result;
    }

    private static boolean hasReferencesIn(ASTBlockStatement block, String varName) {
        List names = block.findDescendantsOfType(ASTName.class);
        for (ASTName name : names) {
            if (!PrematureDeclarationRule.isReference(varName, name.getImage())) continue;
            return true;
        }
        return false;
    }

    private static boolean isReference(String shortName, String compoundName) {
        int dotPos = compoundName.indexOf(46);
        return dotPos < 0 ? shortName.equals(compoundName) : shortName.endsWith(compoundName.substring(0, dotPos));
    }

    private static String varNameIn(ASTLocalVariableDeclaration node) {
        ASTVariableDeclarator declarator = (ASTVariableDeclarator)node.getFirstChildOfType(ASTVariableDeclarator.class);
        return ((ASTVariableDeclaratorId)declarator.jjtGetChild(0)).getImage();
    }

    private static int indexOf(AbstractJavaNode block, Node node) {
        int count = block.jjtGetNumChildren();
        for (int i = 0; i < count; ++i) {
            if (node != block.jjtGetChild(i)) continue;
            return i;
        }
        return -1;
    }

    private static List<ASTBlockStatement> blocksAfter(AbstractJavaNode block, AbstractJavaNode node) {
        int count = block.jjtGetNumChildren();
        int start = PrematureDeclarationRule.indexOf(block, node.jjtGetParent()) + 1;
        ArrayList<ASTBlockStatement> nextBlocks = new ArrayList<ASTBlockStatement>(count);
        for (int i = start; i < count; ++i) {
            Node maybeBlock = block.jjtGetChild(i);
            if (!(maybeBlock instanceof ASTBlockStatement)) continue;
            nextBlocks.add((ASTBlockStatement)maybeBlock);
        }
        return nextBlocks;
    }
}

