/*
 * Decompiled with CFR 0.152.
 */
package tst;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.sqlind.SQLQueryMapper;
import tst.Bean;
import tst.DBTestManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SQLindTester
extends TestCase {
    protected static final String TST_QUERIES_XML = "tst/tstQueries.xml";
    boolean running;
    boolean profiling;
    Random rnd;
    DBTestManager db;
    List<Bean> testDeepList;

    protected void setUp() throws Exception {
        super.setUp();
        this.testDeepList = new ArrayList<Bean>();
        this.running = true;
        this.profiling = false;
        this.db = DBTestManager.getInstance();
        this.rnd = new Random();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testProfiling() {
        final Object cnxObj = this.getCnxObj();
        try {
            Timer timerReflectWiringPolicy = new Timer(){

                public void profile() throws SQLQueryMapper.SQLMapperException {
                    SQLindTester.this.performDeepReflect(cnxObj, new ArrayList<Bean>(), "testLoad1", "Test");
                }
            };
            Timer timerTransfoWiringPolicy = new Timer(){

                public void profile() throws SQLQueryMapper.SQLMapperException {
                    SQLindTester.this.performDeepTransfo(cnxObj, new ArrayList<Bean>(), "testLoad2", "Test");
                }
            };
            timerReflectWiringPolicy.go();
            timerTransfoWiringPolicy.go();
            System.out.println("Start to profile wiring policies ...");
            this.profiling = true;
            for (int i = 0; i < 10000; ++i) {
                timerReflectWiringPolicy.go();
                timerTransfoWiringPolicy.go();
            }
            System.out.println(" reflect wiring policy :" + timerReflectWiringPolicy.getAverage() + " ms");
            System.out.println(" transfo wiring policy :" + timerTransfoWiringPolicy.getAverage() + " ms");
            SQLindTester.assertTrue((timerReflectWiringPolicy.getAverage() > timerTransfoWiringPolicy.getAverage() ? 1 : 0) != 0);
            System.out.println(" transfo gain  :" + Math.round((timerReflectWiringPolicy.getAverage() - timerTransfoWiringPolicy.getAverage()) / timerReflectWiringPolicy.getAverage() * 100.0) + "%");
            System.out.println("terminated.");
        }
        catch (Exception e) {
            e.printStackTrace();
            SQLindTester.fail((String)"ERROR");
        }
        finally {
            try {
                this.closeCnxObj(cnxObj);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testThreadSafe() throws SQLQueryMapper.SQLMapperException {
        try {
            System.out.println("Start testing thread safe behavior ...");
            int threadNum = 15;
            ArrayList<TestThreadSafe> lt = new ArrayList<TestThreadSafe>();
            for (int i = 0; i < threadNum; ++i) {
                TestThreadSafe t = new TestThreadSafe();
                lt.add(t);
                t.start();
            }
            Thread.sleep(50000L);
            this.running = false;
            while (lt.size() > 0) {
                if (((TestThreadSafe)lt.get((int)0)).ended) {
                    lt.remove(0);
                }
                Thread.sleep(200L);
            }
            System.out.println("terminated");
        }
        catch (Exception e) {
            SQLindTester.fail((String)"ERROR");
            e.printStackTrace();
        }
        finally {
            try {
                this.db.getCnx().close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    protected Counter performDeepTransfo(Object cnxObj, final List<Bean> results, String queryId, String injectID) throws SQLQueryMapper.SQLMapperException {
        final Counter subRuptureCount = new Counter();
        SQLQueryMapper.GenericQueryHandler q = this.getSQLQueryHandlerImpl(null, queryId, new String[0]);
        q.setInjection("table", injectID);
        SQLQueryMapper.GenericQueryHandler genericQueryHandler = q;
        genericQueryHandler.getClass();
        this.performQuery(cnxObj, q, (SQLQueryMapper.QueryBehavior)new SQLQueryMapper.GenericQueryHandler.BeanWiringBehavior<Bean>(genericQueryHandler, Bean.class){
            {
                SQLQueryMapper.GenericQueryHandler genericQueryHandler = x0;
                genericQueryHandler.getClass();
                super(genericQueryHandler, x1);
            }

            public void doForEachRupture(Bean bean) {
                results.add(bean);
            }

            public void doForEachSubRupture(Object bean) {
                Assert.assertNotNull((String)"SubRupture is abnormal", (Object)bean);
                ++subRuptureCount.i;
            }

            public void doForEachRecord(Bean bean) {
            }
        });
        return subRuptureCount;
    }

    protected Counter performDeepReflect(Object cnxObj, final List<Bean> results, String queryId, String injectID) throws SQLQueryMapper.SQLMapperException {
        final Counter subRuptureCount = new Counter();
        SQLQueryMapper.GenericQueryHandler q = this.getSQLQueryHandlerImpl(null, queryId, new String[0]);
        q.setInjection("table", injectID);
        SQLQueryMapper.GenericQueryHandler genericQueryHandler = q;
        genericQueryHandler.getClass();
        this.performQuery(cnxObj, q, (SQLQueryMapper.QueryBehavior)new SQLQueryMapper.GenericQueryHandler.BeanWiringBehavior<Bean>(genericQueryHandler, Bean.class){
            {
                SQLQueryMapper.GenericQueryHandler genericQueryHandler = x0;
                genericQueryHandler.getClass();
                super(genericQueryHandler, x1);
            }

            public void doForEachRupture(Bean bean) {
                results.add(bean);
            }

            public void doForEachSubRupture(Object bean) {
                Assert.assertNotNull((String)"SubRupture is abnormal", (Object)bean);
                ++subRuptureCount.i;
            }

            public void doForEachRecord(Bean bean) {
            }
        });
        return subRuptureCount;
    }

    public void testDeepTransfoWiringPolicy() throws Exception {
        block3: {
            Object cnxObject = null;
            try {
                cnxObject = this.getCnxObj();
                ArrayList<Bean> results = new ArrayList<Bean>();
                Counter subRuptureCount = this.performDeepTransfo(cnxObject, results, "test2", this.getTestInject());
                SQLindTester.assertEquals((String)"Number of subruptures is false", (int)10, (int)subRuptureCount.i);
                SQLindTester.assertEquals((String)"Number of beans doesn't match", (int)5, (int)results.size());
                SQLindTester.assertEquals((String)"Value of sub ruptures doesn't match", (String)"v3", (String)((Bean)results.get(3)).getBean().get(2).getLabel());
                for (int i = 0; i < this.testDeepList.size(); ++i) {
                    SQLindTester.assertEquals((String)"Differences between reflect and transfo policy", (String)this.testDeepList.get(i).toString(), (String)((Bean)results.get(i)).toString());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                SQLindTester.fail((String)"ERROR");
                if (cnxObject == null) break block3;
                this.closeCnxObj(cnxObject);
            }
        }
    }

    public void testDeepReflectWiringPolicy() throws Exception {
        block2: {
            Object cnxObject = null;
            try {
                cnxObject = this.getCnxObj();
                ArrayList<Bean> results = new ArrayList<Bean>();
                Counter subRuptureCount = this.performDeepReflect(cnxObject, results, "test1", this.getTestInject());
                SQLindTester.assertEquals((String)"Number of subruptures is false", (int)10, (int)subRuptureCount.i);
                SQLindTester.assertEquals((String)"Number of main ruptures doesn't match", (int)5, (int)results.size());
                SQLindTester.assertEquals((String)"Number of sub ruptures doesn't match", (int)3, (int)((Bean)results.get(3)).getBean().size());
                this.testDeepList.addAll(results);
            }
            catch (Exception e) {
                e.printStackTrace();
                SQLindTester.fail((String)"ERROR");
                if (cnxObject == null) break block2;
                this.closeCnxObj(cnxObject);
            }
        }
    }

    protected abstract String getTestInject();

    protected abstract Object getCnxObj();

    protected abstract void closeCnxObj(Object var1) throws SQLException;

    protected abstract SQLQueryMapper.GenericQueryHandler getSQLQueryHandlerImpl(String var1, String var2, String ... var3) throws SQLQueryMapper.SQLMapperException;

    protected abstract void performQuery(Object var1, SQLQueryMapper.GenericQueryHandler var2, SQLQueryMapper.QueryBehavior var3) throws SQLQueryMapper.SQLMapperException;

    protected class TestThreadSafe
    extends TestThread {
        protected TestThreadSafe() {
        }

        protected void doEnd() {
        }

        protected void doInit(Object cnxObj) throws SQLQueryMapper.SQLMapperException {
        }

        protected int doRunning(Object cnxObj) throws SQLQueryMapper.SQLMapperException {
            SQLQueryMapper.GenericQueryHandler q = SQLindTester.this.getSQLQueryHandlerImpl(null, "testThread", new String[0]);
            final String[] expected = new String[]{null, null, "C", "R", "Z"};
            for (int i = 1; i < 6; ++i) {
                final int index = i - 1;
                q.setParameter("key", (Object)i);
                try {
                    TestThreadSafe.sleep(15L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                SQLQueryMapper.GenericQueryHandler genericQueryHandler = q;
                genericQueryHandler.getClass();
                SQLQueryMapper.GenericQueryHandler.BeanWiringBehavior<Bean> wirer = new SQLQueryMapper.GenericQueryHandler.BeanWiringBehavior<Bean>(genericQueryHandler, Bean.class){
                    int recordNum;
                    {
                        SQLQueryMapper.GenericQueryHandler genericQueryHandler = x0;
                        genericQueryHandler.getClass();
                        super(genericQueryHandler, x1);
                        this.recordNum = 0;
                    }

                    public void doForEachRupture(Bean bean) {
                        Assert.assertEquals((String)"Bad value", (String)expected[index], (String)bean.getAggrbean().getLabel());
                    }

                    public void doForEachSubRupture(Object bean) {
                    }

                    public void doForEachRecord(Bean bean) {
                        ++this.recordNum;
                        Assert.assertTrue((String)"Only one record should have been retrieved.", (this.recordNum == 1 ? 1 : 0) != 0);
                    }
                };
                SQLindTester.this.performQuery(cnxObj, q, (SQLQueryMapper.QueryBehavior)wirer);
            }
            return SQLindTester.this.rnd.nextInt(15);
        }
    }

    protected abstract class TestThread
    extends Thread
    implements Runnable {
        boolean ended;

        protected TestThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object cnxObj = SQLindTester.this.getCnxObj();
            try {
                this.doInit(cnxObj);
                while (SQLindTester.this.running) {
                    TestThread.sleep(this.doRunning(cnxObj));
                }
                this.doEnd();
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"ERROR");
            }
            finally {
                this.ended = true;
            }
        }

        protected abstract void doInit(Object var1) throws SQLQueryMapper.SQLMapperException;

        protected abstract int doRunning(Object var1) throws SQLQueryMapper.SQLMapperException;

        protected abstract void doEnd();
    }

    protected abstract class Timer {
        double sum = 0.0;
        int hit = 0;

        protected Timer() {
        }

        protected double getAverage() {
            return this.sum / (double)this.hit;
        }

        protected void go() throws SQLQueryMapper.SQLMapperException {
            Date now = new Date();
            double start = now.getTime();
            this.profile();
            now = new Date();
            double time = (double)now.getTime() - start;
            if (SQLindTester.this.profiling) {
                this.sum += time;
                ++this.hit;
            }
        }

        protected abstract void profile() throws SQLQueryMapper.SQLMapperException;
    }

    protected class Counter {
        int i = 0;

        protected Counter() {
        }
    }
}

