/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.codeowners;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import nl.basjes.codeowners.parser.CodeOwnersBaseVisitor;
import nl.basjes.codeowners.parser.CodeOwnersLexer;
import nl.basjes.codeowners.parser.CodeOwnersParser;
import nl.basjes.codeowners.shaded.org.antlr.v4.runtime.CharStreams;
import nl.basjes.codeowners.shaded.org.antlr.v4.runtime.CodePointCharStream;
import nl.basjes.codeowners.shaded.org.antlr.v4.runtime.CommonTokenStream;
import nl.basjes.codeowners.shaded.org.antlr.v4.runtime.tree.ParseTree;
import nl.basjes.codeowners.shaded.org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeOwners
extends CodeOwnersBaseVisitor<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(CodeOwners.class);
    private boolean verbose = false;
    private final Map<String, Section> sections = new TreeMap<String, Section>();
    private static final String IMPLICIT_SECTION_NAME = "Implicit Default Section";
    private boolean hasStructuralProblems = false;
    private Section currentSection = new Section("Implicit Default Section");

    public CodeOwners(File file) throws IOException {
        this(FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8));
    }

    public CodeOwners(String codeownersContent) {
        CodePointCharStream input = CharStreams.fromString(codeownersContent);
        CodeOwnersLexer lexer = new CodeOwnersLexer(input);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        CodeOwnersParser parser = new CodeOwnersParser(tokens);
        CodeOwnersParser.CodeownersContext codeowners = parser.codeowners();
        this.visit(codeowners);
        this.storeCurrentSection();
        this.checkForAnyStructuralProblems();
    }

    private void storeCurrentSection() {
        if (!this.currentSection.approvalRules.isEmpty()) {
            List existingSectionsWithSameName = this.sections.values().stream().map(Section::getName).filter(name -> name.equalsIgnoreCase(this.currentSection.name)).collect(Collectors.toList());
            if (existingSectionsWithSameName.isEmpty()) {
                this.sections.put(this.currentSection.name, this.currentSection);
            } else {
                Section existingSection = this.sections.get(existingSectionsWithSameName.get(0));
                this.currentSection.getDefaultApprovers().forEach(existingSection::addDefaultApprover);
                this.currentSection.getApprovalRules().forEach(existingSection::addApprovalRule);
                if (this.currentSection.isOptional() != existingSection.isOptional()) {
                    LOG.error("Merging two sections with a different Optional flag is BAD. Section [{}] has optional={} and Section [{}] has optional={}.", new Object[]{existingSection.getName(), existingSection.isOptional(), this.currentSection.getName(), this.currentSection.isOptional()});
                    this.hasStructuralProblems = true;
                }
            }
        }
    }

    public boolean hasStructuralProblems() {
        return this.hasStructuralProblems;
    }

    public void checkForAnyStructuralProblems() {
        for (Section section : this.sections.values()) {
            List duplicates;
            int minimalNumberOfApprovers = section.getMinimalNumberOfApprovers();
            if (section.isOptional() && minimalNumberOfApprovers != 0) {
                LOG.warn("CODEOWNERS Section \"{}\" is Optional so the specified MinimalNumberOfApprovers {} is IGNORED!", (Object)section.getName(), (Object)minimalNumberOfApprovers);
                this.hasStructuralProblems = true;
            }
            if ((duplicates = section.getApprovalRules().stream().collect(Collectors.groupingBy(ApprovalRule::getFileExpression, Collectors.counting())).entrySet().stream().filter(m -> (Long)m.getValue() > 1L).map(Map.Entry::getKey).sorted().collect(Collectors.toList())).isEmpty()) continue;
            LOG.warn("In section [{}] these file patterns occur multiple times: {}", (Object)section.getName(), duplicates);
            this.hasStructuralProblems = true;
        }
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
        this.sections.values().forEach(section -> section.setVerbose(verbose));
    }

    public List<String> getMandatoryApprovers(String filename) {
        String matchFileName = filename;
        if (!filename.startsWith("/")) {
            matchFileName = "/" + filename;
        }
        ArrayList<String> approvers = new ArrayList<String>();
        for (Section section : this.sections.values()) {
            if (section.isOptional()) continue;
            approvers.addAll(section.getApprovers(matchFileName));
        }
        return approvers.stream().sorted().distinct().collect(Collectors.toList());
    }

    public List<String> getAllApprovers(String filename) {
        if (this.verbose) {
            LOG.info("# vvvvvvvvvvvvvvvvvvvvvvvvvvv");
            LOG.info("Checking: {}", (Object)filename);
        }
        String matchFileName = filename;
        if (!filename.startsWith("/")) {
            matchFileName = "/" + filename;
        }
        if (this.verbose) {
            LOG.info("Matching: {}", (Object)matchFileName);
        }
        ArrayList<String> approvers = new ArrayList<String>();
        for (Section section : this.sections.values()) {
            if (this.verbose) {
                LOG.info("# ---------------------------");
                LOG.info("# Section: {}", (Object)section.getName());
            }
            approvers.addAll(section.getApprovers(matchFileName));
        }
        List<String> endResultApprovers = approvers.stream().sorted().distinct().collect(Collectors.toList());
        if (this.verbose) {
            LOG.info("# ---------------------------");
            LOG.info("# Approvers: {}", endResultApprovers);
            LOG.info("# ^^^^^^^^^^^^^^^^^^^^^^^^^^^");
            LOG.info("");
        }
        return endResultApprovers;
    }

    @Override
    public Void visitSection(CodeOwnersParser.SectionContext ctx) {
        Section section = new Section(ctx.section.getText());
        section.optional = ctx.OPTIONAL() != null;
        if (ctx.approvers != null) {
            section.setMinimalNumberOfApprovers(Integer.parseInt(ctx.approvers.getText().trim()));
        }
        for (TerminalNode user : ctx.USERID()) {
            section.addDefaultApprover(user.getText());
        }
        this.storeCurrentSection();
        this.currentSection = section;
        return null;
    }

    @Override
    public Void visitApprovalRule(CodeOwnersParser.ApprovalRuleContext ctx) {
        String filePattern = ctx.fileExpression.getText();
        List<String> approvers = ctx.USERID().stream().map(ParseTree::getText).map(String::trim).sorted().distinct().collect(Collectors.toList());
        this.currentSection.addApprovalRule(new ApprovalRule(filePattern, approvers));
        return null;
    }

    public String toString() {
        Section firstSection;
        StringBuilder result = new StringBuilder();
        result.append("# CODEOWNERS file:\n");
        if (this.sections.isEmpty()) {
            return result.append("# No CODEOWNER rules were defined.\n").toString();
        }
        if (this.sections.size() == 1 && (firstSection = this.sections.values().iterator().next()).isDefaultSection()) {
            for (ApprovalRule approvalRule : firstSection.getApprovalRules()) {
                result.append(approvalRule).append('\n');
            }
            return result.toString();
        }
        for (Section section : this.sections.values()) {
            result.append(section).append('\n');
        }
        return result.toString();
    }

    public static class Section {
        private boolean optional = false;
        private final String name;
        private int minimalNumberOfApprovers = 0;
        private final List<String> defaultApprovers = new ArrayList<String>();
        private final List<ApprovalRule> approvalRules = new ArrayList<ApprovalRule>();

        public Section(String name) {
            this.name = name;
        }

        void addDefaultApprover(String name) {
            String cleanedName = name.trim();
            if (!this.defaultApprovers.contains(cleanedName)) {
                this.defaultApprovers.add(cleanedName);
            }
        }

        void addApprovalRule(ApprovalRule rule) {
            this.approvalRules.add(rule);
        }

        public void setVerbose(boolean verbose) {
            this.approvalRules.forEach(rule -> rule.setVerbose(verbose));
        }

        public String getName() {
            return this.name;
        }

        public List<String> getDefaultApprovers() {
            return this.defaultApprovers;
        }

        public List<ApprovalRule> getApprovalRules() {
            return this.approvalRules;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public boolean isDefaultSection() {
            return CodeOwners.IMPLICIT_SECTION_NAME.equals(this.name);
        }

        void setMinimalNumberOfApprovers(int minimalNumberOfApprovers) {
            this.minimalNumberOfApprovers = minimalNumberOfApprovers;
        }

        public int getMinimalNumberOfApprovers() {
            return this.minimalNumberOfApprovers;
        }

        public List<String> getApprovers(String filename) {
            ArrayList<String> approvers = new ArrayList<String>();
            for (ApprovalRule approvalRule : this.approvalRules) {
                List<String> ruleApprovers = approvalRule.getApprovers(filename);
                if (ruleApprovers == null) continue;
                approvers.clear();
                if (ruleApprovers.isEmpty()) {
                    approvers.addAll(this.defaultApprovers);
                    continue;
                }
                approvers.addAll(ruleApprovers);
            }
            return approvers;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            if (this.optional) {
                result.append('^');
            }
            result.append('[').append(this.name).append(']');
            if (this.minimalNumberOfApprovers > 0) {
                result.append('[').append(this.minimalNumberOfApprovers).append(']');
            }
            if (!this.defaultApprovers.isEmpty()) {
                result.append(' ').append(String.join((CharSequence)" ", this.defaultApprovers));
            }
            result.append('\n');
            for (ApprovalRule approvalRule : this.approvalRules) {
                result.append(approvalRule).append('\n');
            }
            return result.toString();
        }
    }

    public static class ApprovalRule {
        private final String fileExpression;
        private final List<String> approvers;
        private final Pattern filePattern;
        private boolean verbose = false;

        public ApprovalRule(String fileExpression, List<String> approvers) {
            this.fileExpression = fileExpression;
            this.approvers = approvers;
            String fileRegex = fileExpression.trim().replace("\\ ", " ").replaceAll("^([^/*.])", "/**/$1").replaceAll("([^/*])$", "$1(/|\\$)").replace(".", "\\.").replace("\\.*", "\\..*").replace("/**", "(/.*)?").replace("**", ".*").replaceAll("^\\*", ".*").replaceAll("^/", "^/").replaceAll("/\\*([^/]*)$", "/[^/]*$1\\$").replace("/*", "/.*").replaceAll("([^.\\]])\\*", "$1.*");
            this.filePattern = Pattern.compile(fileRegex);
        }

        public String getFileExpression() {
            return this.fileExpression;
        }

        public List<String> getApprovers(String filename) {
            if (!this.filePattern.matcher(filename).find()) {
                if (this.verbose) {
                    LOG.info("NO MATCH  |{}| ~ |{}| --> {}", new Object[]{this.fileExpression, this.filePattern, filename});
                }
                return null;
            }
            if (this.verbose) {
                LOG.info("MATCH     |{}| ~ |{}| --> {}    approvers:{}", new Object[]{this.fileExpression, this.filePattern, filename, this.approvers});
            }
            return new ArrayList<String>(this.approvers);
        }

        public void setVerbose(boolean verbose) {
            this.verbose = verbose;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            if (this.verbose) {
                result.append("# Regex used for the next rule:   ").append(this.filePattern).append('\n');
            }
            return result.append(this.fileExpression).append(" ").append(String.join((CharSequence)" ", this.approvers)).toString();
        }
    }
}

