/*
 * Decompiled with CFR 0.152.
 */
package nl.crashdata.chartjs.data.simple.builder;

import java.io.Serializable;
import nl.crashdata.chartjs.data.ChartJsScalesConfig;
import nl.crashdata.chartjs.data.simple.SimpleChartJsOptions;
import nl.crashdata.chartjs.data.simple.builder.SimpleChartJsBuilder;
import nl.crashdata.chartjs.data.simple.builder.SimpleChartJsHoverConfigBuilder;
import nl.crashdata.chartjs.data.simple.builder.SimpleChartJsScalesConfigBuilder;
import nl.crashdata.chartjs.data.simple.builder.SimpleChartJsTooltipConfigBuilder;

public class SimpleChartJsOptionsBuilder<X extends Serializable, Y extends Serializable>
implements SimpleChartJsBuilder<SimpleChartJsOptions> {
    private Boolean responsive;
    private SimpleChartJsTooltipConfigBuilder tooltipConfigBuilder = new SimpleChartJsTooltipConfigBuilder();
    private SimpleChartJsHoverConfigBuilder hoverConfigBuilder = new SimpleChartJsHoverConfigBuilder();
    private SimpleChartJsScalesConfigBuilder<X, Y> scalesConfigBuilder = new SimpleChartJsScalesConfigBuilder();

    public SimpleChartJsOptionsBuilder<X, Y> withResponsive(Boolean responsive) {
        this.responsive = responsive;
        return this;
    }

    public SimpleChartJsTooltipConfigBuilder tooltipConfig() {
        return this.tooltipConfigBuilder;
    }

    public SimpleChartJsHoverConfigBuilder hoverConfig() {
        return this.hoverConfigBuilder;
    }

    public SimpleChartJsScalesConfigBuilder<X, Y> scalesConfig() {
        return this.scalesConfigBuilder;
    }

    @Override
    public boolean isValid() {
        return this.tooltipConfigBuilder.isValid() && this.hoverConfigBuilder.isValid() && this.scalesConfigBuilder.isValid();
    }

    @Override
    public SimpleChartJsOptions build() {
        if (!this.isValid()) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " is not ready to build!");
        }
        SimpleChartJsOptions ret = new SimpleChartJsOptions();
        ret.setResponsive(this.responsive);
        ret.setHoverConfig(this.hoverConfigBuilder.build());
        ret.setScalesConfig((ChartJsScalesConfig)this.scalesConfigBuilder.build());
        ret.setTooltipConfig(this.tooltipConfigBuilder.build());
        return ret;
    }
}

