/*
 * Decompiled with CFR 0.152.
 */
package nl.crashdata.chartjs.data.simple.builder;

import java.io.Serializable;
import nl.crashdata.chartjs.data.ChartJsCartesianAxisType;
import nl.crashdata.chartjs.data.ChartJsPosition;
import nl.crashdata.chartjs.data.simple.AbstractSimpleChartJsTickConfig;
import nl.crashdata.chartjs.data.simple.SimpleChartJsAxisConfig;
import nl.crashdata.chartjs.data.simple.builder.AbstractSimpleChartJsTickConfigBuilder;
import nl.crashdata.chartjs.data.simple.builder.SimpleChartJsBuilder;
import nl.crashdata.chartjs.data.simple.builder.SimpleChartJsScaleLabelConfigBuilder;
import nl.crashdata.chartjs.data.simple.builder.SimpleChartJsTimeConfigBuilder;

public abstract class AbstractSimpleChartJsAxisConfigBuilder<T extends Serializable>
implements SimpleChartJsBuilder<SimpleChartJsAxisConfig<T>> {
    private ChartJsCartesianAxisType type;
    private Boolean display;
    private ChartJsPosition position;
    private SimpleChartJsScaleLabelConfigBuilder labelConfigBuilder = new SimpleChartJsScaleLabelConfigBuilder();
    private SimpleChartJsTimeConfigBuilder timeConfigBuilder;
    private Boolean stacked;

    protected AbstractSimpleChartJsAxisConfigBuilder(ChartJsCartesianAxisType type) {
        this.type = type;
    }

    public AbstractSimpleChartJsAxisConfigBuilder<T> withDisplay(Boolean display) {
        this.display = display;
        return this;
    }

    public AbstractSimpleChartJsAxisConfigBuilder<T> withPosition(ChartJsPosition position) {
        this.position = position;
        return this;
    }

    public SimpleChartJsScaleLabelConfigBuilder labelConfig() {
        return this.labelConfigBuilder;
    }

    public abstract AbstractSimpleChartJsTickConfigBuilder<T, ? extends AbstractSimpleChartJsTickConfig<T>> tickConfig();

    protected SimpleChartJsTimeConfigBuilder timeConfig() {
        return this.timeConfigBuilder;
    }

    protected void setTimeConfigBuilder(SimpleChartJsTimeConfigBuilder timeConfigBuilder) {
        this.timeConfigBuilder = timeConfigBuilder;
    }

    public AbstractSimpleChartJsAxisConfigBuilder<T> withStacked(Boolean stacked) {
        this.stacked = stacked;
        return this;
    }

    @Override
    public boolean isValid() {
        return this.position != null && this.type != null && this.labelConfigBuilder.isValid() && this.tickConfig().isValid() && (this.timeConfigBuilder == null || this.timeConfigBuilder.isValid());
    }

    @Override
    public SimpleChartJsAxisConfig<T> build() throws IllegalStateException {
        if (!this.isValid()) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " is not ready to build!");
        }
        SimpleChartJsAxisConfig ret = new SimpleChartJsAxisConfig();
        ret.setDisplay(this.display);
        ret.setPosition(this.position);
        ret.setType(this.type);
        ret.setLabelConfig(this.labelConfigBuilder.build());
        ret.setTickConfig(this.tickConfig().build());
        if (this.timeConfigBuilder != null) {
            ret.setTimeConfig(this.timeConfigBuilder.build());
        }
        ret.setStacked(this.stacked);
        return ret;
    }
}

