/*
 * Decompiled with CFR 0.152.
 */
package nl.crashdata.chartjs.data.simple.builder;

import java.util.List;
import java.util.function.Supplier;
import nl.crashdata.chartjs.data.colors.ChartJsEventHandler;
import nl.crashdata.chartjs.data.simple.builder.SimpleChartJsBuilder;

public class SimpleChartJsEventHandlerBuilder
implements SimpleChartJsBuilder<ChartJsEventHandler> {
    private List<String> params;
    private String body;
    private Supplier<String> defaultHandlerBodySupplier = () -> "";
    private boolean defaultExecute = true;

    public SimpleChartJsEventHandlerBuilder withParameters(String ... params) {
        this.params = List.of(params);
        return this;
    }

    public SimpleChartJsEventHandlerBuilder withBody(String body) {
        this.body = body;
        return this;
    }

    public SimpleChartJsEventHandlerBuilder withDefaultHandlerBodySupplier(Supplier<String> defaultHandlerBodySupplier) {
        this.defaultHandlerBodySupplier = defaultHandlerBodySupplier;
        return this;
    }

    public SimpleChartJsEventHandlerBuilder withDefaultExecute(boolean defaultExecute) {
        this.defaultExecute = defaultExecute;
        return this;
    }

    @Override
    public boolean isValid() {
        return this.body != null;
    }

    @Override
    public ChartJsEventHandler build() throws IllegalStateException {
        StringBuilder bodyBuilder = new StringBuilder();
        if (this.defaultExecute) {
            bodyBuilder.append(this.defaultHandlerBodySupplier.get());
        }
        bodyBuilder.append(this.body);
        return new ChartJsEventHandler(this.params, bodyBuilder.toString());
    }
}

