/*
 * Decompiled with CFR 0.152.
 */
package pl.javahello.processor;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import pl.javahello.processor.SourceFileDescription;

abstract class AbstractFileGenerator {
    private static final Set<String> DEFAULT_TYPES = Set.of(Integer.TYPE.getCanonicalName(), int[].class.getCanonicalName(), Integer.class.getCanonicalName(), Integer[].class.getCanonicalName(), Long.TYPE.getCanonicalName(), long[].class.getCanonicalName(), Long.class.getCanonicalName(), Long[].class.getCanonicalName(), Float.TYPE.getCanonicalName(), float[].class.getCanonicalName(), Float.class.getCanonicalName(), Float[].class.getCanonicalName(), Double.TYPE.getCanonicalName(), double[].class.getCanonicalName(), Double.class.getCanonicalName(), Double[].class.getCanonicalName(), Boolean.TYPE.getCanonicalName(), boolean[].class.getCanonicalName(), Boolean.class.getCanonicalName(), Boolean[].class.getCanonicalName(), Byte.TYPE.getCanonicalName(), byte[].class.getCanonicalName(), Byte.class.getCanonicalName(), Byte[].class.getCanonicalName(), String.class.getCanonicalName(), String[].class.getCanonicalName(), java.util.Date.class.getCanonicalName(), Date.class.getCanonicalName(), Timestamp.class.getCanonicalName(), Time.class.getCanonicalName());
    SourceFileDescription sourceFileDescription;
    ProcessingEnvironment processingEnvironment;
    private RoundEnvironment roundEnv;

    AbstractFileGenerator(RoundEnvironment roundEnv, SourceFileDescription sourceFileDescription, ProcessingEnvironment processingEnvironment) {
        this.roundEnv = roundEnv;
        this.sourceFileDescription = sourceFileDescription;
        this.processingEnvironment = processingEnvironment;
    }

    static boolean isEntity(Element field) {
        DeclaredType type;
        if (field.asType().getKind().equals((Object)TypeKind.DECLARED) && (type = (DeclaredType)field.asType()).asElement().getKind().equals((Object)ElementKind.ENUM)) {
            return false;
        }
        String fieldType = field.asType().toString();
        return DEFAULT_TYPES.stream().noneMatch(fieldType::endsWith);
    }

    void writeFile() {
        try (PrintWriter writer = new PrintWriter(this.processingEnvironment.getFiler().createSourceFile(this.getGeneratedClassName(), new Element[0]).openWriter());){
            this.generateContent(writer);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    abstract String getGeneratedClassName();

    abstract void generateContent(PrintWriter var1);

    void printPackage(PrintWriter printWriter, String packageName) {
        printWriter.println(String.format("package %s;", packageName));
        printWriter.println();
    }

    void printImports(PrintWriter printWriter, String ... imports) {
        for (String importPackage : imports) {
            printWriter.println(String.format("import %s;", importPackage));
        }
        printWriter.println();
    }
}

