/*
 * Decompiled with CFR 0.152.
 */
package pl.javahello.processor;

import java.io.PrintWriter;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import pl.javahello.processor.AbstractAdapterGenerator;
import pl.javahello.processor.SourceFileDescription;

class AdapterToDtoGenerator
extends AbstractAdapterGenerator {
    AdapterToDtoGenerator(RoundEnvironment roundEnv, SourceFileDescription sourceFileDescription, ProcessingEnvironment processingEnvironment) {
        super(roundEnv, sourceFileDescription, processingEnvironment);
    }

    @Override
    String getGeneratedClassName() {
        return this.sourceFileDescription.getPackageElement().getQualifiedName() + "." + this.sourceFileDescription.getElement().getSimpleName() + "DTOAdapter";
    }

    @Override
    void generateContent(PrintWriter writer) {
        this.printPackage(writer, this.sourceFileDescription.getPackageElement().getQualifiedName().toString());
        this.printImports(writer, "org.mapstruct.Mapper", "org.mapstruct.ReportingPolicy", "pl.khuzzuk.remote.Adapter");
        String sourceSimpleName = this.sourceFileDescription.getElement().getSimpleName().toString();
        writer.println(this.getMapperDeclaration("DTOAdapter"));
        writer.println(String.format("public interface %sDTOAdapter extends Adapter<%s, %sDTO> {}", sourceSimpleName, sourceSimpleName, sourceSimpleName));
    }
}

