/*
 * Decompiled with CFR 0.152.
 */
package pl.javahello.processor;

import java.io.PrintWriter;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import pl.javahello.processor.AbstractAdapterGenerator;
import pl.javahello.processor.SourceFileDescription;

class AdapterToEntityGenerator
extends AbstractAdapterGenerator {
    AdapterToEntityGenerator(RoundEnvironment roundEnv, SourceFileDescription sourceFileDescription, ProcessingEnvironment processingEnvironment) {
        super(roundEnv, sourceFileDescription, processingEnvironment);
    }

    @Override
    String getGeneratedClassName() {
        return this.sourceFileDescription.getPackageElement().getQualifiedName() + "." + this.sourceFileDescription.getElement().getSimpleName() + "Adapter";
    }

    @Override
    void generateContent(PrintWriter writer) {
        this.printPackage(writer, this.sourceFileDescription.getPackageElement().getQualifiedName().toString());
        this.printImports(writer, "org.mapstruct.Mapper", "org.mapstruct.ReportingPolicy", "org.mapstruct.Mapping", "org.mapstruct.NullValueCheckStrategy", "pl.khuzzuk.remote.Adapter");
        String sourceSimpleName = this.sourceFileDescription.getElement().getSimpleName().toString();
        writer.println(this.getMapperDeclaration("Adapter"));
        writer.println(String.format("public interface %sAdapter extends Adapter<%sDTO, %s> {", sourceSimpleName, sourceSimpleName, sourceSimpleName));
        List<String> mappings = this.sourceFileDescription.getNullCheckRequiringFields().stream().map(Element::getSimpleName).map(Objects::toString).map(fieldName -> String.format("@Mapping(target = \"%s\", nullValueCheckStrategy = NullValueCheckStrategy.ALWAYS)", fieldName)).collect(Collectors.toList());
        if (!mappings.isEmpty()) {
            writer.println("@Override");
            mappings.forEach(writer::println);
            writer.println(String.format("%s map(%sDTO source);", sourceSimpleName, sourceSimpleName));
        }
        writer.println("}");
    }
}

