/*
 * Decompiled with CFR 0.152.
 */
package pl.javahello.processor;

import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import pl.javahello.DTO;
import pl.javahello.common.CollectionTypeUtils;
import pl.javahello.processor.AbstractFileGenerator;
import pl.javahello.processor.SourceFileDescription;

class DtoGenerator
extends AbstractFileGenerator {
    private final Set<String> excludedFields = new HashSet<String>();

    DtoGenerator(RoundEnvironment roundEnv, SourceFileDescription sourceFileDescription, ProcessingEnvironment processingEnvironment) {
        super(roundEnv, sourceFileDescription, processingEnvironment);
    }

    @Override
    String getGeneratedClassName() {
        return this.sourceFileDescription.getPackageElement().getQualifiedName() + "." + this.sourceFileDescription.getElement().getSimpleName() + "DTO";
    }

    @Override
    void generateContent(PrintWriter writer) {
        this.printPackage(writer, this.sourceFileDescription.getPackageElement().getQualifiedName().toString());
        this.writeClassDeclaration(writer);
        for (Element element : this.sourceFileDescription.getFields()) {
            if (element.getAnnotation(DTO.Exclude.class) != null || this.excludedFields.contains(element.getSimpleName().toString())) continue;
            this.writeField(writer, element);
        }
        writer.println();
        writer.println("}");
    }

    void writeClassDeclaration(PrintWriter writer) {
        StringBuilder classDeclaration = new StringBuilder().append("public class ").append(this.sourceFileDescription.getElement().getSimpleName()).append("DTO");
        if (this.sourceFileDescription.hasField("uuid")) {
            classDeclaration.append(" extends pl.khuzzuk.remote.ListableDTO");
            this.excludedFields.add("uuid");
            this.excludedFields.add("id");
        } else if (this.sourceFileDescription.hasField("id")) {
            classDeclaration.append(" extends pl.khuzzuk.remote.BaseDTO");
            this.excludedFields.add("id");
        }
        classDeclaration.append("{");
        writer.println(classDeclaration);
        writer.println();
    }

    /*
     * WARNING - void declaration
     */
    private void writeField(PrintWriter writer, Element field) {
        String fieldName = field.getSimpleName().toString();
        Object type = field.asType().toString();
        String methodSuffix = StringUtils.capitalize((String)fieldName);
        if (CollectionTypeUtils.isMap(field)) {
            void var7_9;
            Pair<TypeMirror, TypeMirror> mapTypes = CollectionTypeUtils.extractTypesFromMap(field, this.processingEnvironment);
            String string = ((TypeMirror)mapTypes.getKey()).toString();
            Object valueType = ((TypeMirror)mapTypes.getValue()).toString();
            if (DtoGenerator.isEntity(this.processingEnvironment.getTypeUtils().asElement((TypeMirror)mapTypes.getKey()))) {
                String string2 = string + "DTO";
            }
            if (DtoGenerator.isEntity(this.processingEnvironment.getTypeUtils().asElement((TypeMirror)mapTypes.getValue()))) {
                valueType = (String)valueType + "DTO";
            }
            type = "java.util.Map<" + (String)var7_9 + ", " + (String)valueType + ">";
        } else if (CollectionTypeUtils.isFieldCollection(field)) {
            Element collectionType = CollectionTypeUtils.getTypeFromCollectionField(field, this.processingEnvironment);
            if (DtoGenerator.isEntity(collectionType)) {
                type = StringUtils.substringBeforeLast((String)type, (String)">") + "DTO>";
            }
        } else if (DtoGenerator.isEntity(field)) {
            type = ((String)type).endsWith(">") ? StringUtils.substringBeforeLast((String)type, (String)">") + "DTO>" : (String)type + "DTO";
        }
        if (((String)type).startsWith("@")) {
            for (AnnotationMirror annotationMirror : field.asType().getAnnotationMirrors()) {
                if (((String)(type = ((String)type).replaceFirst(Pattern.quote(annotationMirror.toString()), ""))).startsWith(",")) {
                    type = ((String)type).substring(1);
                }
                type = annotationMirror + " " + (String)type;
            }
        }
        writer.println(String.format("private %s %s;", type, fieldName));
        writer.println();
        writer.println(String.format("public %s get%s() { return this.%s; }", type, methodSuffix, fieldName));
        writer.println();
        writer.println(String.format("public void set%s(%s field) { this.%s = field; }", methodSuffix, type, fieldName));
        writer.println();
    }
}

