/*
 * Decompiled with CFR 0.152.
 */
package pl.javahello.processor;

import com.google.auto.service.AutoService;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import pl.javahello.processor.AdapterToDtoGenerator;
import pl.javahello.processor.AdapterToEntityGenerator;
import pl.javahello.processor.DtoGenerator;
import pl.javahello.processor.SourceFileDescription;

@SupportedAnnotationTypes(value={"pl.javahello.DTO"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_11)
@AutoService(value={Processor.class})
public class DtoProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Iterator<? extends TypeElement> iterator = annotations.iterator();
        if (iterator.hasNext()) {
            TypeElement annotation = iterator.next();
            Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(annotation);
            for (Element element : elements) {
                SourceFileDescription sourceFileDescription = SourceFileDescription.create(element, this.processingEnv);
                DtoGenerator dtoGenerator = new DtoGenerator(roundEnv, sourceFileDescription, this.processingEnv);
                dtoGenerator.writeFile();
                AdapterToDtoGenerator adapterToDtoGenerator = new AdapterToDtoGenerator(roundEnv, sourceFileDescription, this.processingEnv);
                adapterToDtoGenerator.writeFile();
                AdapterToEntityGenerator adapterToEntityGenerator = new AdapterToEntityGenerator(roundEnv, sourceFileDescription, this.processingEnv);
                adapterToEntityGenerator.writeFile();
            }
            return !elements.isEmpty();
        }
        return false;
    }
}

