/*
 * Decompiled with CFR 0.152.
 */
package pl.javahello.processor;

import java.io.PrintWriter;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import pl.javahello.processor.AbstractFileGenerator;
import pl.javahello.processor.SourceFileDescription;

class JpaRepoGenerator
extends AbstractFileGenerator {
    JpaRepoGenerator(RoundEnvironment roundEnv, SourceFileDescription sourceFileDescription, ProcessingEnvironment processingEnvironment) {
        super(roundEnv, sourceFileDescription, processingEnvironment);
    }

    @Override
    String getGeneratedClassName() {
        return this.sourceFileDescription.getPackageElement().getQualifiedName() + "." + this.sourceFileDescription.getElement().getSimpleName() + "Repo";
    }

    @Override
    void generateContent(PrintWriter writer) {
        String repoClassName = this.sourceFileDescription.getElement().getSimpleName() + "Repo";
        String packageName = this.sourceFileDescription.getPackageElement().getQualifiedName().toString();
        this.printPackage(writer, packageName);
        this.printImports(writer, "org.springframework.data.jpa.repository.JpaRepository", "org.springframework.stereotype.Repository");
        writer.println("@Repository");
        writer.println(String.format("public interface %s extends JpaRepository<%s, Long> {", repoClassName, this.sourceFileDescription.getElement()));
        writer.println("}");
    }
}

