/*
 * Decompiled with CFR 0.152.
 */
package pl.javahello.processor;

import com.google.auto.service.AutoService;
import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import pl.javahello.processor.AdapterToDtoGenerator;
import pl.javahello.processor.AdapterToEntityGenerator;
import pl.javahello.processor.DtoGenerator;
import pl.javahello.processor.JpaRepoGenerator;
import pl.javahello.processor.RemoteServiceGenerator;
import pl.javahello.processor.SourceFileDescription;

@SupportedAnnotationTypes(value={"pl.javahello.RemoteEntity"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_11)
@AutoService(value={Processor.class})
public class RemoteEntityProcessor
extends AbstractProcessor {
    private long recordTime;
    private long totalRecordTime;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Iterator<? extends TypeElement> iterator = annotations.iterator();
        if (iterator.hasNext()) {
            TypeElement annotation = iterator.next();
            Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(annotation);
            for (Element element : elements) {
                System.out.println("Processing RemoteEntity: " + element.getSimpleName());
                this.startRecord();
                SourceFileDescription sourceFileDescription = SourceFileDescription.create(element, this.processingEnv);
                new JpaRepoGenerator(roundEnv, sourceFileDescription, this.processingEnv).writeFile();
                this.reportRecord("JpaRepoGenerator");
                new DtoGenerator(roundEnv, sourceFileDescription, this.processingEnv).writeFile();
                this.reportRecord("DtoGenerator");
                new AdapterToDtoGenerator(roundEnv, sourceFileDescription, this.processingEnv).writeFile();
                new AdapterToEntityGenerator(roundEnv, sourceFileDescription, this.processingEnv).writeFile();
                this.reportRecord("AdapterGenerators");
                new RemoteServiceGenerator(roundEnv, sourceFileDescription, this.processingEnv).writeFile();
                this.reportRecord("RemoteServiceGenerator");
                this.finishRecord();
            }
            return !elements.isEmpty();
        }
        return false;
    }

    private void startRecord() {
        this.totalRecordTime = this.recordTime = System.currentTimeMillis();
    }

    private void reportRecord(String name) {
        System.out.println(String.format("%s\tfinished RemoteEntity, %s time: %s ms", LocalDateTime.now(), name, System.currentTimeMillis() - this.recordTime));
        this.recordTime = System.currentTimeMillis();
    }

    private void finishRecord() {
        System.out.println(String.format("%s\tfinished RemoteEntity, overall time: %s ms", LocalDateTime.now(), System.currentTimeMillis() - this.totalRecordTime));
    }
}

