/*
 * Decompiled with CFR 0.152.
 */
package pl.javahello.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import pl.javahello.DTO;
import pl.javahello.common.CollectionTypeUtils;
import pl.javahello.common.TypeUtils;

class SourceFileDescription {
    private Element element;
    private PackageElement packageElement;
    private List<? extends Element> members = List.of();
    private List<Element> fields = List.of();

    SourceFileDescription() {
    }

    static SourceFileDescription create(Element element, ProcessingEnvironment processingEnvironment) {
        SourceFileDescription sourceFileDescription = new SourceFileDescription();
        sourceFileDescription.element = element;
        sourceFileDescription.packageElement = processingEnvironment.getElementUtils().getPackageOf(element);
        sourceFileDescription.members = processingEnvironment.getElementUtils().getAllMembers((TypeElement)element);
        sourceFileDescription.fields = new ArrayList<Element>();
        sourceFileDescription.getFields(sourceFileDescription.members).forEach(sourceFileDescription.fields::add);
        TypeElement objectType = processingEnvironment.getElementUtils().getTypeElement("java.lang.Object");
        List<? extends TypeMirror> supertypes = processingEnvironment.getTypeUtils().directSupertypes(element.asType());
        supertypes.forEach(type -> sourceFileDescription.fillSuperTypeFields((TypeMirror)type, processingEnvironment, objectType));
        return sourceFileDescription;
    }

    private void fillSuperTypeFields(TypeMirror typeMirror, ProcessingEnvironment processingEnvironment, TypeElement objectType) {
        if (!typeMirror.equals(objectType.asType())) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            Element superElement = processingEnvironment.getTypeUtils().asElement(typeMirror);
            List<Element> superMemebers = processingEnvironment.getElementUtils().getAllMembers((TypeElement)superElement);
            this.getFields(superMemebers).forEach(this.fields::add);
            List<? extends TypeMirror> supertypes = processingEnvironment.getTypeUtils().directSupertypes(declaredType.asElement().asType());
            supertypes.forEach(type -> this.fillSuperTypeFields((TypeMirror)type, processingEnvironment, objectType));
        }
    }

    private Stream<Element> getFields(Collection<Element> elements) {
        return elements.stream().filter(el -> ElementKind.FIELD == el.getKind());
    }

    boolean hasField(String name) {
        return this.getFields().stream().map(Element::getSimpleName).map(Objects::toString).anyMatch(name::equals);
    }

    List<Element> getFields() {
        return this.fields;
    }

    public boolean isEntity() {
        return this.hasAnnotation(this.element, "javax.persistence.Entity");
    }

    private boolean hasAnnotation(Element element, String annotationName) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            String annotationValue = annotationMirror.toString();
            if (!annotationValue.contains(annotationName)) continue;
            return true;
        }
        return false;
    }

    List<Element> getEntityWithOwnMappers(ProcessingEnvironment processingEnvironment) {
        ArrayList<Element> entities = new ArrayList<Element>();
        for (Element field : this.fields) {
            Element fieldType;
            if (field.asType().getKind().isPrimitive() || TypeUtils.isJavaLangType(field) || field.getAnnotation(DTO.Exclude.class) != null) continue;
            Element element = fieldType = CollectionTypeUtils.isFieldCollection(field) ? CollectionTypeUtils.getTypeFromCollectionField(field, processingEnvironment) : processingEnvironment.getTypeUtils().asElement(field.asType());
            if (!this.hasAnnotation(fieldType, "pl.khuzzuk.remote.RemoteEntity") && !this.hasAnnotation(fieldType, "pl.khuzzuk.remote.DTO")) continue;
            entities.add(fieldType);
        }
        return entities;
    }

    List<Element> getNullCheckRequiringFields() {
        ArrayList<Element> nullCheckFields = new ArrayList<Element>();
        this.fields.stream().filter(field -> !field.asType().getKind().isPrimitive()).filter(CollectionTypeUtils::isFieldCollection).forEach(nullCheckFields::add);
        this.fields.stream().filter(field -> "uuid".equals(field.getSimpleName().toString())).findAny().ifPresent(nullCheckFields::add);
        return nullCheckFields;
    }

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public PackageElement getPackageElement() {
        return this.packageElement;
    }

    public void setPackageElement(PackageElement packageElement) {
        this.packageElement = packageElement;
    }

    public List<? extends Element> getMembers() {
        return this.members;
    }

    public void setMembers(List<? extends Element> members) {
        this.members = members;
    }
}

