/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler.eclipse;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import org.codehaus.plexus.compiler.AbstractCompiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerError;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.eclipse.SourceCodeLocator;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;

public class EclipseJavaCompiler
extends AbstractCompiler {
    public List compile(CompilerConfiguration config) throws CompilerException {
        String targetVersion;
        String sourceVersion;
        LinkedList errors = new LinkedList();
        List classpathEntries = config.getClasspathEntries();
        URL[] urls = new URL[1 + classpathEntries.size()];
        int i = 0;
        try {
            urls[i++] = new File(config.getOutputLocation()).toURL();
            Iterator it = classpathEntries.iterator();
            while (it.hasNext()) {
                urls[i++] = new File((String)it.next()).toURL();
            }
        }
        catch (MalformedURLException e) {
            throw new CompilerException("Error while converting the classpath entries to URLs.", (Throwable)e);
        }
        URLClassLoader classLoader = new URLClassLoader(urls);
        SourceCodeLocator sourceCodeLocator = new SourceCodeLocator(config.getSourceLocations());
        EclipseCompilerINameEnvironment env = new EclipseCompilerINameEnvironment(sourceCodeLocator, classLoader, errors);
        IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.proceedWithAllProblems();
        HashMap<String, String> settings = new HashMap<String, String>();
        if (config.isDebug()) {
            settings.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
        }
        if (config.isShowWarnings()) {
            // empty if block
        }
        if ((sourceVersion = this.decodeVersion(config.getSourceVersion())) != null) {
            settings.put("org.eclipse.jdt.core.compiler.source", sourceVersion);
        }
        if ((targetVersion = this.decodeVersion(config.getTargetVersion())) != null) {
            settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", targetVersion);
        }
        if (!StringUtils.isEmpty((String)config.getSourceEncoding())) {
            settings.put("org.eclipse.jdt.core.encoding", config.getSourceEncoding());
        }
        if (config.isShowDeprecation()) {
            settings.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
        } else {
            settings.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        }
        settings.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
        settings.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
        DefaultProblemFactory problemFactory = new DefaultProblemFactory(Locale.getDefault());
        EclipseCompilerICompilerRequestor requestor = new EclipseCompilerICompilerRequestor(config.getOutputLocation(), errors);
        ArrayList<CompilationUnit> compilationUnits = new ArrayList<CompilationUnit>();
        Iterator it = config.getSourceLocations().iterator();
        while (it.hasNext()) {
            String sourceRoot = (String)it.next();
            Set sources = AbstractCompiler.getSourceFilesForSourceRoot((CompilerConfiguration)config, (String)sourceRoot);
            Iterator it2 = sources.iterator();
            while (it2.hasNext()) {
                String source = (String)it2.next();
                CompilationUnit unit = new CompilationUnit(source, AbstractCompiler.makeClassName((String)source, (String)sourceRoot), errors);
                compilationUnits.add(unit);
            }
        }
        Compiler compiler = new Compiler((INameEnvironment)env, policy, settings, (ICompilerRequestor)requestor, (IProblemFactory)problemFactory);
        ICompilationUnit[] units = compilationUnits.toArray(new ICompilationUnit[compilationUnits.size()]);
        compiler.compile(units);
        return errors;
    }

    private CompilerError handleError(String className, int line, int column, Object errorMessage) {
        String fileName = className.replace('.', File.separatorChar) + ".java";
        if (column < 0) {
            column = 0;
        }
        String message = errorMessage != null ? errorMessage.toString() : "No message";
        return new CompilerError(fileName, true, line, column, line, column, message);
    }

    private CompilerError handleWarning(IProblem warning) {
        return new CompilerError(new String(warning.getOriginatingFileName()), false, warning.getSourceLineNumber(), warning.getSourceStart(), warning.getSourceLineNumber(), warning.getSourceEnd(), warning.getMessage());
    }

    private String decodeVersion(String versionSpec) {
        if (StringUtils.isEmpty((String)versionSpec)) {
            return null;
        }
        if (versionSpec.equals("1.1")) {
            return "1.1";
        }
        if (versionSpec.equals("1.2")) {
            return "1.2";
        }
        if (versionSpec.equals("1.3")) {
            return "1.3";
        }
        if (versionSpec.equals("1.4")) {
            return "1.4";
        }
        if (versionSpec.equals("1.5")) {
            return "1.5";
        }
        this.getLogger().warn("Unknown version '" + versionSpec + "', no version setting will be given to the compiler.");
        return null;
    }

    private class EclipseCompilerICompilerRequestor
    implements ICompilerRequestor {
        private String destinationDirectory;
        private List errors;

        public EclipseCompilerICompilerRequestor(String destinationDirectory, List errors) {
            this.destinationDirectory = destinationDirectory;
            this.errors = errors;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void acceptResult(CompilationResult result) {
            if (result.hasProblems()) {
                IProblem[] problems = result.getProblems();
                for (int i = 0; i < problems.length; ++i) {
                    IProblem problem = problems[i];
                    String name = new String(problems[i].getOriginatingFileName());
                    if (problem.isWarning()) {
                        this.errors.add(EclipseJavaCompiler.this.handleWarning(problem));
                        continue;
                    }
                    this.errors.add(EclipseJavaCompiler.this.handleError(name, problem.getSourceLineNumber(), -1, problem.getMessage()));
                }
            } else {
                ClassFile[] classFiles = result.getClassFiles();
                for (int i = 0; i < classFiles.length; ++i) {
                    ClassFile classFile = classFiles[i];
                    char[][] compoundName = classFile.getCompoundName();
                    String className = "";
                    String sep = "";
                    for (int j = 0; j < compoundName.length; ++j) {
                        className = className + sep;
                        className = className + new String(compoundName[j]);
                        sep = ".";
                    }
                    byte[] bytes = classFile.getBytes();
                    File outFile = new File(this.destinationDirectory, className.replace('.', '/') + ".class");
                    if (!outFile.getParentFile().exists()) {
                        outFile.getParentFile().mkdirs();
                    }
                    FileOutputStream fout = null;
                    try {
                        fout = new FileOutputStream(outFile);
                        fout.write(bytes);
                    }
                    catch (FileNotFoundException e) {
                        this.errors.add(EclipseJavaCompiler.this.handleError(className, -1, -1, e.getMessage()));
                        IOUtil.close((OutputStream)fout);
                        continue;
                    }
                    catch (IOException e2) {
                        this.errors.add(EclipseJavaCompiler.this.handleError(className, -1, -1, e2.getMessage()));
                        {
                            catch (Throwable throwable) {
                                IOUtil.close(fout);
                                throw throwable;
                            }
                        }
                        IOUtil.close((OutputStream)fout);
                        continue;
                    }
                    IOUtil.close((OutputStream)fout);
                    continue;
                }
            }
        }
    }

    private class EclipseCompilerINameEnvironment
    implements INameEnvironment {
        private SourceCodeLocator sourceCodeLocator;
        private ClassLoader classLoader;
        private List errors;

        public EclipseCompilerINameEnvironment(SourceCodeLocator sourceCodeLocator, ClassLoader classLoader, List errors) {
            this.sourceCodeLocator = sourceCodeLocator;
            this.classLoader = classLoader;
            this.errors = errors;
        }

        public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
            String result = "";
            String sep = "";
            for (int i = 0; i < compoundTypeName.length; ++i) {
                result = result + sep;
                result = result + new String(compoundTypeName[i]);
                sep = ".";
            }
            return this.findType(result);
        }

        public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
            String result = "";
            String sep = "";
            for (int i = 0; i < packageName.length; ++i) {
                result = result + sep;
                result = result + new String(packageName[i]);
                sep = ".";
            }
            result = result + sep;
            result = result + new String(typeName);
            return this.findType(result);
        }

        private NameEnvironmentAnswer findType(String className) {
            try {
                File f = this.sourceCodeLocator.findSourceCodeForClass(className);
                if (f != null) {
                    CompilationUnit compilationUnit = new CompilationUnit(f.getAbsolutePath(), className, this.errors);
                    return new NameEnvironmentAnswer((ICompilationUnit)compilationUnit, null);
                }
                String resourceName = className.replace('.', '/') + ".class";
                InputStream is = this.classLoader.getResourceAsStream(resourceName);
                if (is == null) {
                    return null;
                }
                byte[] classBytes = IOUtil.toByteArray((InputStream)is);
                char[] fileName = className.toCharArray();
                ClassFileReader classFileReader = new ClassFileReader(classBytes, fileName, true);
                return new NameEnvironmentAnswer((IBinaryType)classFileReader, null);
            }
            catch (IOException e) {
                this.errors.add(EclipseJavaCompiler.this.handleError(className, -1, -1, e.getMessage()));
                return null;
            }
            catch (ClassFormatException e) {
                this.errors.add(EclipseJavaCompiler.this.handleError(className, -1, -1, e.getMessage()));
                return null;
            }
        }

        private boolean isPackage(String result) {
            if (this.sourceCodeLocator.findSourceCodeForClass(result) != null) {
                return false;
            }
            String resourceName = "/" + result.replace('.', '/') + ".class";
            InputStream is = this.classLoader.getResourceAsStream(resourceName);
            return is == null;
        }

        public boolean isPackage(char[][] parentPackageName, char[] packageName) {
            String result = "";
            String sep = "";
            if (parentPackageName != null) {
                for (int i = 0; i < parentPackageName.length; ++i) {
                    result = result + sep;
                    result = result + new String(parentPackageName[i]);
                    sep = ".";
                }
            }
            if (Character.isUpperCase(packageName[0])) {
                return false;
            }
            String str = new String(packageName);
            result = result + sep;
            result = result + str;
            return this.isPackage(result);
        }

        public void cleanup() {
        }
    }

    private class CompilationUnit
    implements ICompilationUnit {
        private String className;
        private String sourceFile;
        private List errors;

        CompilationUnit(String sourceFile, String className, List errors) {
            this.className = className;
            this.sourceFile = sourceFile;
            this.errors = errors;
        }

        public char[] getFileName() {
            return this.className.toCharArray();
        }

        public char[] getContents() {
            try {
                return FileUtils.fileRead((String)this.sourceFile).toCharArray();
            }
            catch (FileNotFoundException e) {
                this.errors.add(EclipseJavaCompiler.this.handleError(this.className, -1, -1, e.getMessage()));
                return null;
            }
            catch (IOException e) {
                this.errors.add(EclipseJavaCompiler.this.handleError(this.className, -1, -1, e.getMessage()));
                return null;
            }
        }

        public char[] getMainTypeName() {
            int dot = this.className.lastIndexOf(46);
            if (dot > 0) {
                return this.className.substring(dot + 1).toCharArray();
            }
            return this.className.toCharArray();
        }

        public char[][] getPackageName() {
            StringTokenizer izer = new StringTokenizer(this.className, ".");
            char[][] result = new char[izer.countTokens() - 1][];
            for (int i = 0; i < result.length; ++i) {
                String tok = izer.nextToken();
                result[i] = tok.toCharArray();
            }
            return result;
        }
    }
}

