/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.chatglm.executor.aigc;

import cn.bugstack.chatglm.IOpenAiApi;
import cn.bugstack.chatglm.executor.Executor;
import cn.bugstack.chatglm.executor.result.ResultHandler;
import cn.bugstack.chatglm.model.ChatCompletionRequest;
import cn.bugstack.chatglm.model.ChatCompletionResponse;
import cn.bugstack.chatglm.model.ChatCompletionSyncResponse;
import cn.bugstack.chatglm.model.EventType;
import cn.bugstack.chatglm.model.ImageCompletionRequest;
import cn.bugstack.chatglm.model.ImageCompletionResponse;
import cn.bugstack.chatglm.session.Configuration;
import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GLMExecutor
implements Executor,
ResultHandler {
    private static final Logger log = LoggerFactory.getLogger(GLMExecutor.class);
    private final Configuration configuration;
    private final EventSource.Factory factory;
    private IOpenAiApi openAiApi;
    private OkHttpClient okHttpClient;

    public GLMExecutor(Configuration configuration) {
        this.configuration = configuration;
        this.factory = configuration.createRequestFactory();
        this.openAiApi = configuration.getOpenAiApi();
        this.okHttpClient = configuration.getOkHttpClient();
    }

    @Override
    public EventSource completions(ChatCompletionRequest chatCompletionRequest, EventSourceListener eventSourceListener) throws Exception {
        Request request = new Request.Builder().url(this.configuration.getApiHost().concat("api/paas/v4/chat/completions")).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)chatCompletionRequest.toString())).build();
        return this.factory.newEventSource(request, chatCompletionRequest.getIsCompatible() != false ? this.eventSourceListener(eventSourceListener) : eventSourceListener);
    }

    @Override
    public CompletableFuture<String> completions(ChatCompletionRequest chatCompletionRequest) throws InterruptedException {
        final CompletableFuture<String> future = new CompletableFuture<String>();
        final StringBuffer dataBuffer = new StringBuffer();
        Request request = new Request.Builder().url(this.configuration.getApiHost().concat("api/paas/v4/chat/completions")).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json;charset=utf-8"), (String)chatCompletionRequest.toString())).build();
        this.factory.newEventSource(request, new EventSourceListener(){

            public void onEvent(EventSource eventSource, @Nullable String id, @Nullable String type, String data) {
                if ("[DONE]".equals(data)) {
                    log.info("[\u8f93\u51fa\u7ed3\u675f] Tokens {}", (Object)JSON.toJSONString((Object)data));
                    return;
                }
                ChatCompletionResponse response = (ChatCompletionResponse)JSON.parseObject((String)data, ChatCompletionResponse.class);
                log.info("\u6d4b\u8bd5\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)response));
                List<ChatCompletionResponse.Choice> choices = response.getChoices();
                for (ChatCompletionResponse.Choice choice : choices) {
                    if ("stop".equals(choice.getFinishReason())) continue;
                    dataBuffer.append(choice.getDelta().getContent());
                }
            }

            public void onClosed(EventSource eventSource) {
                future.complete(dataBuffer.toString());
            }

            public void onFailure(EventSource eventSource, @Nullable Throwable t, @Nullable Response response) {
                future.completeExceptionally(new RuntimeException("Request closed before completion"));
            }
        });
        return future;
    }

    @Override
    public ChatCompletionSyncResponse completionsSync(ChatCompletionRequest chatCompletionRequest) throws Exception {
        chatCompletionRequest.setStream(false);
        Request request = new Request.Builder().url(this.configuration.getApiHost().concat("api/paas/v4/chat/completions")).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)chatCompletionRequest.toString())).build();
        OkHttpClient okHttpClient = this.configuration.getOkHttpClient();
        Response response = okHttpClient.newCall(request).execute();
        if (!response.isSuccessful()) {
            throw new RuntimeException("Request failed");
        }
        return (ChatCompletionSyncResponse)JSON.parseObject((String)response.body().string(), ChatCompletionSyncResponse.class);
    }

    @Override
    public ImageCompletionResponse genImages(ImageCompletionRequest imageCompletionRequest) throws Exception {
        return (ImageCompletionResponse)this.openAiApi.genImages(imageCompletionRequest).blockingGet();
    }

    @Override
    public EventSourceListener eventSourceListener(final EventSourceListener eventSourceListener) {
        return new EventSourceListener(){

            public void onEvent(EventSource eventSource, @Nullable String id, @Nullable String type, String data) {
                if ("[DONE]".equals(data)) {
                    return;
                }
                ChatCompletionResponse response = (ChatCompletionResponse)JSON.parseObject((String)data, ChatCompletionResponse.class);
                if (response.getChoices() != null && 1 == response.getChoices().size() && "stop".equals(response.getChoices().get(0).getFinishReason())) {
                    eventSourceListener.onEvent(eventSource, id, EventType.finish.getCode(), data);
                    return;
                }
                eventSourceListener.onEvent(eventSource, id, EventType.add.getCode(), data);
            }

            public void onClosed(EventSource eventSource) {
                eventSourceListener.onClosed(eventSource);
            }

            public void onFailure(EventSource eventSource, @Nullable Throwable t, @Nullable Response response) {
                eventSourceListener.onFailure(eventSource, t, response);
            }
        };
    }
}

