/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.chatglm.session;

import cn.bugstack.chatglm.IOpenAiApi;
import cn.bugstack.chatglm.executor.Executor;
import cn.bugstack.chatglm.executor.aigc.GLMExecutor;
import cn.bugstack.chatglm.executor.aigc.GLMOldExecutor;
import cn.bugstack.chatglm.model.Model;
import java.util.HashMap;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private static final Logger log = LoggerFactory.getLogger(Configuration.class);
    private String apiHost = "https://open.bigmodel.cn/";
    private String apiSecretKey;
    private String apiKey;
    private String apiSecret;
    private IOpenAiApi openAiApi;
    private OkHttpClient okHttpClient;
    private HttpLoggingInterceptor.Level level = HttpLoggingInterceptor.Level.HEADERS;
    private long connectTimeout = 450L;
    private long writeTimeout = 450L;
    private long readTimeout = 450L;
    private HashMap<Model, Executor> executorGroup;
    public static final String SSE_CONTENT_TYPE = "text/event-stream";
    public static final String DEFAULT_USER_AGENT = "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)";
    public static final String APPLICATION_JSON = "application/json";
    public static final String JSON_CONTENT_TYPE = "application/json; charset=utf-8";

    public void setApiSecretKey(String apiSecretKey) {
        this.apiSecretKey = apiSecretKey;
        String[] arrStr = apiSecretKey.split("\\.");
        if (arrStr.length != 2) {
            throw new RuntimeException("invalid apiSecretKey");
        }
        this.apiKey = arrStr[0];
        this.apiSecret = arrStr[1];
    }

    public EventSource.Factory createRequestFactory() {
        return EventSources.createFactory((OkHttpClient)this.okHttpClient);
    }

    public HashMap<Model, Executor> newExecutorGroup() {
        this.executorGroup = new HashMap();
        GLMOldExecutor glmOldExecutor = new GLMOldExecutor(this);
        this.executorGroup.put(Model.CHATGLM_6B_SSE, glmOldExecutor);
        this.executorGroup.put(Model.CHATGLM_LITE, glmOldExecutor);
        this.executorGroup.put(Model.CHATGLM_LITE_32K, glmOldExecutor);
        this.executorGroup.put(Model.CHATGLM_STD, glmOldExecutor);
        this.executorGroup.put(Model.CHATGLM_PRO, glmOldExecutor);
        this.executorGroup.put(Model.CHATGLM_TURBO, glmOldExecutor);
        GLMExecutor glmExecutor = new GLMExecutor(this);
        this.executorGroup.put(Model.GLM_3_5_TURBO, glmExecutor);
        this.executorGroup.put(Model.GLM_4, glmExecutor);
        this.executorGroup.put(Model.GLM_4V, glmExecutor);
        this.executorGroup.put(Model.GLM_4_Plus, glmExecutor);
        this.executorGroup.put(Model.GLM_4_0520, glmExecutor);
        this.executorGroup.put(Model.GLM_4_Lng, glmExecutor);
        this.executorGroup.put(Model.GLM_4_AirX, glmExecutor);
        this.executorGroup.put(Model.GLM_4_Air, glmExecutor);
        this.executorGroup.put(Model.GLM_4_FlashX, glmExecutor);
        this.executorGroup.put(Model.GLM_4_Flash, glmExecutor);
        this.executorGroup.put(Model.GLM_4_AllTools, glmExecutor);
        this.executorGroup.put(Model.COGVIEW_3, glmExecutor);
        return this.executorGroup;
    }

    public Configuration() {
    }

    public Configuration(String apiHost, String apiSecretKey, String apiKey, String apiSecret, IOpenAiApi openAiApi, OkHttpClient okHttpClient, HttpLoggingInterceptor.Level level, long connectTimeout, long writeTimeout, long readTimeout, HashMap<Model, Executor> executorGroup) {
        this.apiHost = apiHost;
        this.apiSecretKey = apiSecretKey;
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
        this.openAiApi = openAiApi;
        this.okHttpClient = okHttpClient;
        this.level = level;
        this.connectTimeout = connectTimeout;
        this.writeTimeout = writeTimeout;
        this.readTimeout = readTimeout;
        this.executorGroup = executorGroup;
    }

    public String getApiHost() {
        return this.apiHost;
    }

    public void setApiHost(String apiHost) {
        this.apiHost = apiHost;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getApiSecret() {
        return this.apiSecret;
    }

    public void setOpenAiApi(IOpenAiApi openAiApi) {
        this.openAiApi = openAiApi;
    }

    public IOpenAiApi getOpenAiApi() {
        return this.openAiApi;
    }

    public OkHttpClient getOkHttpClient() {
        return this.okHttpClient;
    }

    public void setOkHttpClient(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
    }

    public void setLevel(HttpLoggingInterceptor.Level level) {
        this.level = level;
    }

    public HttpLoggingInterceptor.Level getLevel() {
        return this.level;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setWriteTimeout(long writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public long getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setReadTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }
}

