/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.chatglm.session.defaults;

import cn.bugstack.chatglm.executor.Executor;
import cn.bugstack.chatglm.model.ChatCompletionRequest;
import cn.bugstack.chatglm.model.ChatCompletionSyncResponse;
import cn.bugstack.chatglm.model.ImageCompletionRequest;
import cn.bugstack.chatglm.model.ImageCompletionResponse;
import cn.bugstack.chatglm.model.Model;
import cn.bugstack.chatglm.session.Configuration;
import cn.bugstack.chatglm.session.OpenAiSession;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOpenAiSession
implements OpenAiSession {
    private static final Logger log = LoggerFactory.getLogger(DefaultOpenAiSession.class);
    private final Configuration configuration;
    private final Map<Model, Executor> executorGroup;

    public DefaultOpenAiSession(Configuration configuration, Map<Model, Executor> executorGroup) {
        this.configuration = configuration;
        this.executorGroup = executorGroup;
    }

    @Override
    public EventSource completions(ChatCompletionRequest chatCompletionRequest, EventSourceListener eventSourceListener) throws Exception {
        Executor executor = this.executorGroup.get((Object)chatCompletionRequest.getModel());
        if (null == executor) {
            throw new RuntimeException((Object)((Object)chatCompletionRequest.getModel()) + " \u6a21\u578b\u6267\u884c\u5668\u5c1a\u672a\u5b9e\u73b0\uff01");
        }
        return executor.completions(chatCompletionRequest, eventSourceListener);
    }

    @Override
    public CompletableFuture<String> completions(ChatCompletionRequest chatCompletionRequest) throws Exception {
        Executor executor = this.executorGroup.get((Object)chatCompletionRequest.getModel());
        if (null == executor) {
            throw new RuntimeException((Object)((Object)chatCompletionRequest.getModel()) + " \u6a21\u578b\u6267\u884c\u5668\u5c1a\u672a\u5b9e\u73b0\uff01");
        }
        return executor.completions(chatCompletionRequest);
    }

    @Override
    public ChatCompletionSyncResponse completionsSync(ChatCompletionRequest chatCompletionRequest) throws Exception {
        Executor executor = this.executorGroup.get((Object)chatCompletionRequest.getModel());
        if (null == executor) {
            throw new RuntimeException((Object)((Object)chatCompletionRequest.getModel()) + " \u6a21\u578b\u6267\u884c\u5668\u5c1a\u672a\u5b9e\u73b0\uff01");
        }
        return executor.completionsSync(chatCompletionRequest);
    }

    @Override
    public ImageCompletionResponse genImages(ImageCompletionRequest imageCompletionRequest) throws Exception {
        Executor executor = this.executorGroup.get((Object)imageCompletionRequest.getModelEnum());
        if (null == executor) {
            throw new RuntimeException(imageCompletionRequest.getModel() + " \u6a21\u578b\u6267\u884c\u5668\u5c1a\u672a\u5b9e\u73b0\uff01");
        }
        return executor.genImages(imageCompletionRequest);
    }

    @Override
    public Configuration configuration() {
        return this.configuration;
    }
}

