/*
 * Decompiled with CFR 0.152.
 */
package ru.greatbit.utils.serialize.json;

import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.xc.JaxbAnnotationIntrospector;
import org.springframework.stereotype.Service;

@Service
public class JsonUnmarshaller {
    public <T> T unmarshal(String data, Class<T> objectClass) throws Exception {
        return this.unmarshal(data, "", objectClass);
    }

    public <T> T unmarshal(String data, String rootName, Class<T> objectClass) throws Exception {
        if (rootName != null && !"".equals(rootName)) {
            data = "{\"" + rootName + "\": " + data + "}";
        }
        ObjectMapper mapper = new ObjectMapper();
        JaxbAnnotationIntrospector introspector = new JaxbAnnotationIntrospector();
        mapper.getDeserializationConfig().setAnnotationIntrospector((AnnotationIntrospector)introspector);
        return (T)mapper.readValue(data, objectClass);
    }
}

