/*
 * Decompiled with CFR 0.152.
 */
package ru.greatbit.utils.serialize.xml;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.springframework.stereotype.Service;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;
import ru.greatbit.utils.serialize.utils.NamespaceFilter;

@Service
public class XMLUnmarshaller {
    public <T> T unmarshal(String data, Class<T> clazz) throws JAXBException, IOException, SAXException {
        try {
            return this.unmarshal(new ByteArrayInputStream(data.getBytes("UTF-8")), clazz);
        }
        catch (UnmarshalException e) {
            return this.unmarshalNamespaceAware(new ByteArrayInputStream(data.getBytes("UTF-8")), clazz);
        }
    }

    public <T> T unmarshal(InputStream data, Class<T> clazz) throws JAXBException, IOException, SAXException {
        JAXBContext contextObj = JAXBContext.newInstance((Class[])new Class[]{clazz});
        Unmarshaller unmarshallerObj = contextObj.createUnmarshaller();
        InputStreamReader ir = new InputStreamReader(data);
        return (T)unmarshallerObj.unmarshal((Reader)ir);
    }

    public <T> T unmarshalNamespaceAware(InputStream data, Class<T> clazz) throws JAXBException, IOException, SAXException {
        JAXBContext contextObj = JAXBContext.newInstance((Class[])new Class[]{clazz});
        Unmarshaller unmarshallerObj = contextObj.createUnmarshaller();
        BufferedReader rd = new BufferedReader(new InputStreamReader(data));
        XMLReader reader = XMLReaderFactory.createXMLReader();
        NamespaceFilter inFilter = new NamespaceFilter(this.getXMLRootNamespace(clazz), true);
        inFilter.setParent(reader);
        InputSource is = new InputSource(rd);
        SAXSource source = new SAXSource(inFilter, is);
        Object result = unmarshallerObj.unmarshal((Source)source);
        rd.close();
        return (T)result;
    }

    public String getXMLRootNamespace(Class clazz) {
        String result = "";
        XmlRootElement annotation = clazz.getAnnotation(XmlRootElement.class);
        if (annotation != null) {
            try {
                result = annotation.annotationType().getMethod("namespace", new Class[0]).invoke((Object)annotation, new Object[0]).toString();
            }
            catch (Exception e) {
                result = "";
            }
        }
        if ("##default".equals(result)) {
            result = "";
        }
        if ("".equals(result) || "##default".equals(result)) {
            String[] packageNames = clazz.getPackage().getName().split("\\.");
            for (int i = packageNames.length - 1; i >= 0; --i) {
                result = result + "." + packageNames[i];
            }
            result = result.substring(1);
        }
        return result;
    }
}

