/*
 * Decompiled with CFR 0.152.
 */
package ru.greatbit.utils.time;

import java.util.Arrays;
import org.springframework.stereotype.Service;

@Service
public class CronUtils {
    private final String DEFAULT_CRON = "";
    private final String DEFAULT_SIMPLE_CRON = "";

    public String convertToQuartz(String input) {
        String result = "";
        String[] entries = input.split(" ");
        if (entries.length < 5) {
            return "";
        }
        if ("*".equals(entries[4])) {
            entries[4] = "?";
        }
        if (!"*".equals(entries[4]) && !"?".equals(entries[4]) && "*".equals(entries[2])) {
            entries[2] = "?";
        }
        if (!"*".equals(entries[4]) && !"?".equals(entries[4])) {
            try {
                entries[4] = this.adjustDayOfWeek(entries[4]);
            }
            catch (NumberFormatException e) {
                return "";
            }
        }
        for (String entry : Arrays.asList(entries)) {
            result = result + entry + " ";
        }
        result = "0 " + result;
        return result.trim();
    }

    private String adjustDayOfWeek(String entry) throws NumberFormatException {
        String splitter = "";
        String result = "";
        if (entry.contains("-")) {
            entry = this.formCommaSeparatedEntry(entry);
        }
        if (!entry.contains(",")) {
            return result + this.convertCronDayToQuartz(Integer.parseInt(entry));
        }
        splitter = ",";
        for (String number : entry.split(splitter)) {
            result = result + this.convertCronDayToQuartz(Integer.parseInt(number)) + ",";
        }
        result = result.substring(0, result.length() - 1);
        return result;
    }

    private String formCommaSeparatedEntry(String entry) throws NumberFormatException {
        String result = "";
        String[] values = entry.split("-");
        if (values.length != 2) {
            throw new NumberFormatException();
        }
        int low = Integer.parseInt(values[0].trim());
        int high = Integer.parseInt(values[1].trim());
        for (int i = low; i <= high; ++i) {
            result = result + i + ",";
        }
        result = result.substring(0, result.length() - 1);
        return result;
    }

    private int convertCronDayToQuartz(int value) {
        if (value == 7 || value == 0) {
            return 1;
        }
        return value + 1;
    }
}

