/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.gradle.plugin.python.cmd.docker;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.DefaultGroovyStaticMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.GradleException;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.output.OutputFrame;
import ru.vyarus.gradle.plugin.python.cmd.docker.DockerConfig;
import ru.vyarus.gradle.plugin.python.cmd.docker.PythonContainer;
import ru.vyarus.gradle.plugin.python.cmd.env.Environment;
import ru.vyarus.gradle.plugin.python.util.DurationFormatter;

public class ContainerManager
implements GroovyObject {
    private static final String DOCKER_PROJECT_PATH = "/usr/src/";
    private static final String DOCKER_WINDOWS_PROJECT_PATH = "c:/projects/";
    private static final byte[] EMPTY;
    private static final String NL;
    private static final char WIN_SEPARATOR = '\\';
    private static final char LINUX_SEPARATOR = '/';
    private static final int STARTUP_TIMEOUT = 3;
    private final String image;
    private final boolean windowsImage;
    private final Environment environment;
    private final String projectRootPath;
    private final String projectDockerPath;
    private PythonContainer container;
    private Config containerConfig;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public ContainerManager(String image, boolean windows, Environment environment) {
        String string;
        String string2;
        Environment environment2;
        boolean bl;
        String string3;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.image = string3 = image;
        this.windowsImage = bl = windows;
        this.environment = environment2 = environment;
        this.projectRootPath = string2 = environment.getRootDir().getAbsolutePath();
        this.projectDockerPath = string = StringGroovyMethods.plus((String)(windows ? DOCKER_WINDOWS_PROJECT_PATH : DOCKER_PROJECT_PATH), (CharSequence)environment.getRootName());
    }

    public boolean isWindows() {
        return this.windowsImage;
    }

    public void convertCommand(String ... command) {
        int i = 0;
        while (i < command.length) {
            String string = this.toDockerPath(ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])command, (int)i)));
            BytecodeInterface8.objectArraySet((Object[])command, (int)i, (Object)string);
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
    }

    public String toDockerPath(String path) {
        return this.canonicalPath(path.replace(this.projectRootPath, this.projectDockerPath));
    }

    public String canonicalPath(String path) {
        String res = path;
        char from = Os.isFamily((String)Os.FAMILY_WINDOWS) ? WIN_SEPARATOR : LINUX_SEPARATOR;
        char to = this.isWindows() ? WIN_SEPARATOR : LINUX_SEPARATOR;
        if (from != to) {
            res = res.replace(from, to);
        }
        return res;
    }

    public String toLocalPath(String path) {
        if (path.startsWith(this.projectRootPath)) {
            return path;
        }
        if (path.startsWith(this.projectDockerPath)) {
            return path.replace(this.projectDockerPath, this.projectRootPath);
        }
        return ShortTypeHandling.castToString(null);
    }

    public synchronized void restartIfRequired(DockerConfig config, String workDir, Map<String, Object> envVars) {
        Config upd = new Config(config, workDir, envVars);
        if (this.container == null) {
            this.start(upd);
        } else {
            String diff = this.containerConfig.diff(upd);
            if (DefaultTypeTransformation.booleanUnbox((Object)diff)) {
                this.environment.getLogger().lifecycle("Restarting container due to changed {}", new Object[]{diff});
                this.stop();
                this.start(upd);
            }
        }
    }

    public boolean isStarted() {
        return this.container != null;
    }

    public String getContainerName() {
        PythonContainer pythonContainer = this.container;
        Boolean bl = pythonContainer != null ? Boolean.valueOf(pythonContainer.isRunning()) : null;
        return ShortTypeHandling.castToString((bl == null ? false : bl) ? this.container.getContainerName() : null);
    }

    public synchronized void stop() {
        if (DefaultTypeTransformation.booleanUnbox((Object)((Object)this.container)) && this.container.isRunning()) {
            this.doStop("container", this.container);
            Object var1_1 = null;
            this.container = (PythonContainer)((Object)ScriptBytecodeAdapter.castToType(var1_1, PythonContainer.class));
            Object var2_2 = null;
            this.containerConfig = (Config)ScriptBytecodeAdapter.castToType(var2_2, Config.class);
        }
    }

    public synchronized int exec(String[] command, OutputStream out) {
        long watch = System.currentTimeMillis();
        Container.ExecResult res = this.container.execInContainer(StandardCharsets.UTF_8, command);
        this.environment.getLogger().info("Command executed in pre-started container ({}) in {}", (Object)this.container.getContainerName(), (Object)DurationFormatter.format(System.currentTimeMillis() - watch));
        if (res.getStdout() != null) {
            out.write(res.getStdout().getBytes(StandardCharsets.UTF_8));
        }
        if (res.getStderr() != null) {
            out.write(res.getStderr().getBytes(StandardCharsets.UTF_8));
        }
        return res.getExitCode();
    }

    public int execExclusive(String[] command, OutputStream out, DockerConfig config, String workDir, Map<String, Object> env) {
        Reference out2 = new Reference((Object)out);
        public final class _execExclusive_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference out;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _execExclusive_closure1(Object _outerInstance, Object _thisObject, Reference out) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.out = reference = out;
            }

            public Void doCall(OutputFrame frame) {
                byte[] byArray;
                ((OutputStream)this.out.get()).write(DefaultTypeTransformation.booleanUnbox((Object)(byArray = frame.getBytes())) ? byArray : ContainerManager.pfaccess$0(null));
                return (Void)ScriptBytecodeAdapter.castToType(null, Void.class);
            }

            @Generated
            public Void call(OutputFrame frame) {
                return this.doCall(frame);
            }

            @Generated
            public OutputStream getOut() {
                return (OutputStream)ScriptBytecodeAdapter.castToType((Object)this.out.get(), OutputStream.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _execExclusive_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        PythonContainer cont = (PythonContainer)((Object)ScriptBytecodeAdapter.castToType((Object)((PythonContainer)((PythonContainer)this.createContainer(config, workDir, env).withCommand(command)).withStartupTimeout(Duration.ofSeconds(STARTUP_TIMEOUT))).withLogConsumer((Consumer)ScriptBytecodeAdapter.castToType((Object)((Object)new _execExclusive_closure1(this, this, out2)), Consumer.class)), PythonContainer.class));
        try {
            try {
                this.doStart("exclusive container", cont);
                while (cont.isRunning() && !Thread.currentThread().isInterrupted()) {
                    DefaultGroovyStaticMethods.sleep(null, (long)300);
                }
            }
            catch (GradleException ex) {
                this.environment.getLogger().lifecycle("Exclusive container failed to start: {}", new Object[]{ex.getMessage()});
                this.environment.getLogger().info("Container error stacktrace", (Throwable)ex);
            }
        }
        finally {
            this.doStop("exclusive container", cont);
        }
        return DefaultTypeTransformation.intUnbox((Object)cont.getDockerClient().inspectContainerCmd(cont.getContainerId()).exec().getState().getExitCodeLong());
    }

    public String formatContainerInfo(DockerConfig config, String workDir, Map<String, Object> env) {
        StringBuilder res = new StringBuilder();
        String labelPattern = "\t%-15s ";
        res.append(String.format(labelPattern, "Mount")).append(this.projectRootPath).append(":").append(this.projectDockerPath).append(NL);
        res.append(String.format(labelPattern, "Work dir")).append(this.getDockerWorkDir(workDir)).append(NL);
        if (env != null && !env.isEmpty()) {
            res.append(String.format(labelPattern, new GStringImpl(new Object[]{env.size()}, new String[]{"Env (", ")"}))).append(DefaultGroovyMethods.join(env.keySet(), (String)", ")).append(NL);
        }
        if (config.isUseHostNetwork()) {
            res.append(String.format(labelPattern, "Host network")).append(NL);
        } else if (config.getPorts() != null && !config.getPorts().isEmpty()) {
            res.append(String.format(labelPattern, "Ports")).append(DefaultGroovyMethods.join(config.getPorts(), (String)", ")).append(NL);
        }
        return res.toString();
    }

    private void start(Config config) {
        Config config2;
        PythonContainer pythonContainer;
        if (this.container != null) {
            return;
        }
        this.container = pythonContainer = this.createContainer(config.getDocker(), config.getWorkDir(), config.getEnv());
        if (this.isWindows()) {
            this.container.withCommand(new String[]{"ping", "-t", "localhost", ">", "NUL"});
        } else {
            this.container.withCommand(new String[]{"tail", "-f", "/dev/null"});
        }
        public final class _start_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _start_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Void doCall(OutputFrame frame) {
                if (frame.getBytes() != null) {
                    ((ContainerManager)this.getThisObject()).environment.getLogger().lifecycle("[docker{}] {}", new Object[]{((ContainerManager)this.getThisObject()).container.getContainerName(), frame.getUtf8String()});
                    return (Void)ScriptBytecodeAdapter.castToType(null, Void.class);
                }
                return (Void)ScriptBytecodeAdapter.castToType(null, Void.class);
            }

            @Generated
            public Void call(OutputFrame frame) {
                return this.doCall(frame);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _start_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        ((PythonContainer)this.container.withStartupTimeout(Duration.ofSeconds(STARTUP_TIMEOUT))).withLogConsumer((Consumer)ScriptBytecodeAdapter.castToType((Object)((Object)new _start_closure2(this, this)), Consumer.class));
        this.doStart("container", this.container, config.getDocker(), config.getWorkDir(), config.getEnv());
        this.containerConfig = config2 = config;
    }

    private void doStart(String message, PythonContainer container, DockerConfig config, String workDir, Map<String, Object> env) {
        long watch = System.currentTimeMillis();
        try {
            container.start();
        }
        catch (Exception ex) {
            throw (Throwable)new GradleException(this.collectErrors(ex), (Throwable)ex);
        }
        String info = config != null ? this.formatContainerInfo(config, workDir, env) : "";
        this.environment.getLogger().lifecycle("[docker] {} '{}' ({}) started in {}{}", new Object[]{message, this.image, container.getContainerName(), DurationFormatter.format(System.currentTimeMillis() - watch), StringGroovyMethods.plus((String)NL, (CharSequence)info)});
    }

    private String collectErrors(Exception ex) {
        String res = ex.getMessage();
        String prefix = "";
        Throwable current = ex;
        while (DefaultTypeTransformation.booleanUnbox((Object)current.getCause())) {
            StringGroovyMethods.plus((String)prefix, (CharSequence)"\t");
            current.getCause();
            StringGroovyMethods.plus((String)res, (CharSequence)new GStringImpl(new Object[]{prefix, current.getMessage()}, new String[]{"\n", " ", ""}));
        }
        return res;
    }

    private void doStop(String message, PythonContainer container) {
        if (container.isRunning()) {
            long watch = System.currentTimeMillis();
            String name = container.getContainerName();
            try {
                container.stop();
                this.environment.getLogger().lifecycle("[docker] {} '{}' ({}) stopped in {}", new Object[]{message, this.image, name, DurationFormatter.format(System.currentTimeMillis() - watch)});
            }
            catch (Exception ex) {
                this.environment.getLogger().warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"Container '", "' stop failed"})), (Throwable)ex);
            }
        }
    }

    private PythonContainer createContainer(DockerConfig config, String workDir, Map<String, Object> env) {
        Reference container = new Reference((Object)((PythonContainer)((Object)ScriptBytecodeAdapter.castToType((Object)((PythonContainer)new PythonContainer(this.image).withFileSystemBind(this.projectRootPath, this.projectDockerPath, BindMode.READ_WRITE)).withWorkingDirectory(this.getDockerWorkDir(workDir)), PythonContainer.class))));
        if (env != null && !env.isEmpty()) {
            public final class _createContainer_closure3
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference container;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _createContainer_closure3(Object _outerInstance, Object _thisObject, Reference container) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.container = reference = container;
                }

                public Object doCall(Object k, Object v) {
                    ((PythonContainer)((Object)this.container.get())).addEnv(ShortTypeHandling.castToString((Object)k), String.valueOf(v));
                    return null;
                }

                @Generated
                public Object call(Object k, Object v) {
                    return this.doCall(k, v);
                }

                @Generated
                public PythonContainer getContainer() {
                    return (PythonContainer)((Object)ScriptBytecodeAdapter.castToType((Object)this.container.get(), PythonContainer.class));
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _createContainer_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each(env, (Closure)new _createContainer_closure3(this, this, container));
        }
        Map<Integer, Integer> mappings = this.parseMappings(config.getPorts());
        if (config.isUseHostNetwork()) {
            ((PythonContainer)((Object)container.get())).withNetworkMode("host");
            if (!mappings.isEmpty()) {
                this.environment.getLogger().warn(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"WARNING: Ignoring mapped ports {} configuration because container use host ", (CharSequence)"network and so all container ports would be available on host directly (mapping not "), (CharSequence)"possible). See python.docker.useHostNetwork option."), config.getPorts());
            }
        } else {
            public final class _createContainer_closure4
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference container;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _createContainer_closure4(Object _outerInstance, Object _thisObject, Reference container) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.container = reference = container;
                }

                public PythonContainer doCall(Object k, Object v) {
                    return ((PythonContainer)((Object)this.container.get())).withFixedExposedPort(DefaultTypeTransformation.intUnbox((Object)k), DefaultTypeTransformation.intUnbox((Object)v));
                }

                @Generated
                public PythonContainer call(Object k, Object v) {
                    return this.doCall(k, v);
                }

                @Generated
                public PythonContainer getContainer() {
                    return (PythonContainer)((Object)ScriptBytecodeAdapter.castToType((Object)this.container.get(), PythonContainer.class));
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _createContainer_closure4.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each(mappings, (Closure)new _createContainer_closure4(this, this, container));
        }
        return (PythonContainer)((Object)container.get());
    }

    private String getDockerWorkDir(String workDir) {
        return DefaultTypeTransformation.booleanUnbox((Object)workDir) ? this.toDockerPath(this.environment.file(workDir).getAbsolutePath()) : this.projectDockerPath;
    }

    private Map<Integer, Integer> parseMappings(Set<String> mappings) {
        Reference res = new Reference((Object)((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class)));
        if (mappings != null) {
            public final class _parseMappings_closure5
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference res;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _parseMappings_closure5(Object _outerInstance, Object _thisObject, Reference res) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.res = reference = res;
                }

                public Integer doCall(Object it) {
                    int src = 0;
                    int target = 0;
                    Object[] split = ((String)it).split(":");
                    src = Integer.valueOf(ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])split, (int)0)));
                    target = DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)split, Object[].class))) > 1 ? Integer.valueOf(ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])split, (int)1))) : Integer.valueOf(src);
                    int n = target;
                    ScriptBytecodeAdapter.invokeMethodN(_parseMappings_closure5.class, (Object)this.res.get(), (String)"putAt", (Object[])new Object[]{src, n});
                    return n;
                }

                @Generated
                public Map getRes() {
                    return (Map)ScriptBytecodeAdapter.castToType((Object)this.res.get(), Map.class);
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Integer doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _parseMappings_closure5.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each(mappings, (Closure)new _parseMappings_closure5(this, this, res));
        }
        return (LinkedHashMap)res.get();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ContainerManager.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
        }
        if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ContainerManager.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ContainerManager.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, ContainerManager.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(ContainerManager.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public static /* synthetic */ byte[] pfaccess$0(ContainerManager $that) {
        return (byte[])ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.getField(ContainerManager.class, ContainerManager.class, (String)"EMPTY"), byte[].class);
    }

    @Generated
    private void doStart(String message, PythonContainer container, DockerConfig config, String workDir) {
        CallSite[] callSiteArray = ContainerManager.$getCallSiteArray();
        this.doStart(message, container, config, workDir, null);
    }

    @Generated
    private void doStart(String message, PythonContainer container, DockerConfig config) {
        CallSite[] callSiteArray = ContainerManager.$getCallSiteArray();
        this.doStart(message, container, config, null, null);
    }

    @Generated
    private void doStart(String message, PythonContainer container) {
        CallSite[] callSiteArray = ContainerManager.$getCallSiteArray();
        this.doStart(message, container, null, null, null);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ContainerManager.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        String string;
        NL = string = "\n";
        byte[] byArray = new byte[]{};
        EMPTY = byArray;
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[]{};
        return new CallSiteArray(ContainerManager.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ContainerManager.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    public static class Config
    implements GroovyObject {
        private DockerConfig docker;
        private String workDir;
        private Map<String, Object> env;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        public Config(DockerConfig docker, String workDir, Map<String, Object> env) {
            String string;
            DockerConfig dockerConfig;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.docker = dockerConfig = docker;
            this.workDir = string = workDir;
            Map<String, Object> map = env;
            this.env = map;
        }

        public String diff(Config conf) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)this.workDir, (Object)conf.getWorkDir())) {
                return "working directory";
            }
            public final class _diff_closure1
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _diff_closure1(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Boolean doCall(Object k, Object v) {
                    return ScriptBytecodeAdapter.compareNotEqual((Object)DefaultGroovyMethods.getAt(((Config)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), Config.class)).getEnv(), (Object)k), (Object)v);
                }

                @Generated
                public Boolean call(Object k, Object v) {
                    return this.doCall(k, v);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _diff_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            if (DefaultTypeTransformation.booleanUnbox(conf.getEnv()) && (this.env == null || DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.find(conf.getEnv(), (Closure)new _diff_closure1(this, this))))) {
                return "environment variables";
            }
            if (DefaultTypeTransformation.booleanUnbox(conf.getDocker().getPorts()) && (!DefaultTypeTransformation.booleanUnbox(this.docker.getPorts()) || !this.docker.getPorts().containsAll(conf.getDocker().getPorts()))) {
                return "ports";
            }
            return ShortTypeHandling.castToString(null);
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(Config.class, ContainerManager.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
                return ScriptBytecodeAdapter.invokeMethodN(Config.class, ContainerManager.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(Config.class, ContainerManager.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(Config.class, ContainerManager.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
                return ScriptBytecodeAdapter.invokeMethodN(Config.class, ContainerManager.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(Config.class, ContainerManager.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ContainerManager.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ContainerManager.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(Config.class, ContainerManager.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(Config.class, ContainerManager.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Map<String, Object> pfaccess$0(Config $that) {
            return $that.env;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != Config.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public DockerConfig getDocker() {
            return this.docker;
        }

        @Generated
        public void setDocker(DockerConfig dockerConfig) {
            this.docker = dockerConfig;
        }

        @Generated
        public String getWorkDir() {
            return this.workDir;
        }

        @Generated
        public void setWorkDir(String string) {
            this.workDir = string;
        }

        @Generated
        public Map<String, Object> getEnv() {
            return this.env;
        }

        @Generated
        public void setEnv(Map<String, Object> map) {
            this.env = map;
        }
    }
}

