/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.gradle.plugin.python.cmd.exec;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.IntRange;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.IOGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberPlus;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.logging.LogLevel;
import ru.vyarus.gradle.plugin.python.cmd.LoggedCommandCleaner;
import ru.vyarus.gradle.plugin.python.cmd.docker.ContainerManager;
import ru.vyarus.gradle.plugin.python.cmd.docker.DockerConfig;
import ru.vyarus.gradle.plugin.python.cmd.docker.DockerFactory;
import ru.vyarus.gradle.plugin.python.cmd.env.Environment;
import ru.vyarus.gradle.plugin.python.util.CliUtils;
import ru.vyarus.gradle.plugin.python.util.DurationFormatter;
import ru.vyarus.gradle.plugin.python.util.PythonExecutionFailed;

public final class PythonBinary
implements GroovyObject {
    private static final String PYTHON3 = "python3";
    private static final String SPACE;
    private static final String NL;
    private final Environment environment;
    private final String sourcePythonPath;
    private final String sourcePythonBinary;
    private boolean validateBinary;
    private ContainerManager dockerManager;
    private DockerConfig dockerConfig;
    private String workDir;
    private final Map<String, Object> envVars;
    private boolean initialized;
    private String executable;
    private boolean withCmd;
    private boolean customBinaryPath;
    private final List<LoggedCommandCleaner> logCleaners;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public PythonBinary(Environment environment, String pythonPath, String binary) {
        String string;
        String string2;
        Environment environment2;
        MetaClass metaClass;
        List list;
        Map map;
        boolean bl;
        this.validateBinary = bl = true;
        this.envVars = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        this.logCleaners = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.environment = environment2 = environment;
        this.sourcePythonPath = string2 = pythonPath;
        this.sourcePythonBinary = string = binary;
    }

    public void validateSystemBinary(boolean validateBinary) {
        boolean bl;
        this.beforeInit("System binary check must be set before initialization");
        this.validateBinary = bl = validateBinary;
    }

    public void withDocker(DockerConfig docker) {
        this.beforeInit("Docker config must be set before initialization");
        if (DefaultTypeTransformation.booleanUnbox((Object)docker)) {
            ContainerManager containerManager;
            DockerConfig dockerConfig;
            this.dockerConfig = dockerConfig = docker;
            this.dockerManager = containerManager = DockerFactory.getContainer(docker, this.environment);
        }
    }

    public void addLogCleaner(LoggedCommandCleaner cleaner) {
        this.logCleaners.add(cleaner);
    }

    public void workDir(String workDir) {
        String string;
        this.workDir = string = workDir;
    }

    public String getWorkDir() {
        return this.workDir;
    }

    public Map<String, Object> getEnvVars() {
        return this.envVars;
    }

    public String getExecutable() {
        this.init();
        return this.executable;
    }

    public String targetOsCanonicalPath(String path) {
        return this.isDocker() ? this.dockerManager.canonicalPath(path) : path;
    }

    public String getBinaryDir(Supplier<String> sysExecutableProvider, Supplier<String> sysPrefixProvider) {
        this.init();
        String path = this.customBinaryPath ? this.environment.file(this.executable).getAbsolutePath() : ShortTypeHandling.castToString((Object)sysExecutableProvider.get());
        int idx = path.lastIndexOf(File.separator);
        String res = null;
        if (path.isEmpty() || idx <= 0) {
            path = ShortTypeHandling.castToString((Object)sysPrefixProvider.get());
            res = CliUtils.pythonBinPath(path, this.isWindows());
        } else {
            res = StringGroovyMethods.getAt((String)path, (IntRange)new IntRange(true, 0, idx - 1));
        }
        if (this.isDocker()) {
            res = this.dockerManager.toDockerPath(res);
        }
        return res;
    }

    public boolean isWindows() {
        return this.isDocker() ? this.dockerManager.isWindows() : Os.isFamily((String)Os.FAMILY_WINDOWS);
    }

    public boolean isDocker() {
        return this.dockerManager != null;
    }

    public String getIdentity() {
        return this.buildIdentity(this.sourcePythonPath, this.sourcePythonBinary, this.isDocker());
    }

    public boolean exists(String path) {
        this.init();
        if (this.isDocker()) {
            String localPath = this.dockerManager.toLocalPath(path);
            if (localPath != null) {
                return new File(localPath).exists();
            }
            String res = this.rawExec(ShortTypeHandling.castToString((Object)(this.isWindows() ? new GStringImpl(new Object[]{path}, new String[]{"IF EXIST \"", "\" ECHO exists"}) : new GStringImpl(new Object[]{path}, new String[]{"test -f ", " && echo \"exists\""}))));
            return ScriptBytecodeAdapter.compareEqual((Object)res, (Object)"exists");
        }
        File file = new File(path);
        boolean res = file.exists();
        this.environment.getLogger().info("File {} exists: {}", (Object)file.getAbsolutePath(), (Object)res);
        return res;
    }

    public void exec(Object args, List<String> pythonArgs, List<String> extraArgs, OutputStream outputConsumer, LogLevel logLevel) {
        this.init();
        String exec = this.getCommandBinary(this.workDir);
        String[] cmdArgs = this.getCommandArguments(this.workDir, args, pythonArgs, extraArgs);
        this.environment.getLogger().info("Python arguments: {}", (Object[])ScriptBytecodeAdapter.castToType((Object)cmdArgs, Object[].class));
        String[] cmd = new String[]{exec};
        cmd = (String[])ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.plus((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)cmd, Object[].class)), (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)cmdArgs, Object[].class))), String[].class);
        if (this.isDocker()) {
            this.dockerManager.convertCommand(cmd);
            this.prepareEnvironment();
        }
        String formattedCommand = this.cleanLoggedCommand(cmd);
        this.environment.getLogger().log(logLevel, ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{formattedCommand}, new String[]{"[python] ", ""})));
        long start = System.currentTimeMillis();
        int res = this.rawExec(cmd, outputConsumer);
        this.environment.getLogger().info("Python execution time: {}", (Object)DurationFormatter.format(System.currentTimeMillis() - start));
        if (res != 0) {
            String out = this.reformatOutputForException(outputConsumer);
            throw (Throwable)((Object)new PythonExecutionFailed(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{formattedCommand}, new String[]{"Python call failed: ", ""}).plus(DefaultTypeTransformation.booleanUnbox((Object)out) ? StringGroovyMethods.plus((String)"\n\n\tOUTPUT:\n", (CharSequence)out) : ""))));
        }
    }

    public void init() {
        if (this.initialized) {
            return;
        }
        PythonBinary pythonBinary = this;
        synchronized (pythonBinary) {
            if (!this.initialized) {
                boolean bl;
                boolean bl2;
                boolean bl3;
                String string;
                this.executable = string = this.findPython(this.environment, this.sourcePythonPath, this.sourcePythonBinary, this.validateBinary);
                this.withCmd = bl3 = DefaultTypeTransformation.booleanUnbox((Object)this.sourcePythonPath) && this.isWindows();
                this.customBinaryPath = bl2 = DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.asType((Object)this.sourcePythonPath, Boolean.TYPE));
                this.initialized = bl = true;
            }
        }
    }

    public <T> T getOrCompute(String key, Supplier<T> value) {
        String id = this.getIdentity();
        if (id.startsWith(this.environment.relativeRootPath(this.environment.getProjectDir().getAbsolutePath()))) {
            return this.environment.projectCache(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{key, id}, new String[]{"", ":", ""})), value);
        }
        return this.environment.globalCache(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{key, id}, new String[]{"", ":", ""})), value);
    }

    private String buildIdentity(String pythonPath, String binary, boolean docker) {
        String string = binary;
        return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)(pythonPath == null ? "" : CliUtils.canonicalPath(this.environment.file(pythonPath)).replace(StringGroovyMethods.plus((String)this.environment.getRootDir().getPath(), (CharSequence)"/"), "")), (CharSequence)(DefaultTypeTransformation.booleanUnbox((Object)string) ? string : "")), (CharSequence)(docker ? "[docker]" : ""));
    }

    /*
     * WARNING - void declaration
     */
    private String getPythonBinary(String pythonPath, String binary, boolean python3Available) {
        void var2_2;
        Reference pythonPath2 = new Reference((Object)pythonPath);
        Reference binary2 = new Reference((Object)var2_2);
        Reference python3Available2 = new Reference((Object)python3Available);
        String string = (String)pythonPath2.get();
        Boolean bl = string != null ? Boolean.valueOf(string.startsWith("..")) : null;
        String id = ShortTypeHandling.castToString((Object)((bl == null ? false : bl) ? new GStringImpl(new Object[]{(String)pythonPath2.get(), (String)binary2.get()}, new String[]{"", ":", ""}) : this.buildIdentity((String)pythonPath2.get(), (String)binary2.get(), this.isDocker())));
        public final class _getPythonBinary_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference binary;
            private /* synthetic */ Reference pythonPath;
            private /* synthetic */ Reference python3Available;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getPythonBinary_closure1(Object _outerInstance, Object _thisObject, Reference binary, Reference pythonPath, Reference python3Available) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.binary = reference3 = binary;
                this.pythonPath = reference2 = pythonPath;
                this.python3Available = reference = python3Available;
            }

            public String doCall(Object it) {
                Object object = this.binary.get();
                String string = ShortTypeHandling.castToString((Object)object);
                String res = DefaultTypeTransformation.booleanUnbox((Object)object) ? string : "python";
                if (DefaultTypeTransformation.booleanUnbox((Object)this.pythonPath.get())) {
                    String path = StringGroovyMethods.plus((String)ShortTypeHandling.castToString((Object)this.pythonPath.get()), (CharSequence)(((String)this.pythonPath.get()).endsWith(File.separator) ? "" : File.separator));
                    res = ShortTypeHandling.castToString((Object)(((PythonBinary)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), PythonBinary.class)).isWindows() ? new GStringImpl(new Object[]{path, res}, new String[]{"", "", ".exe"}) : new GStringImpl(new Object[]{path, res}, new String[]{"", "", ""})));
                } else if (!DefaultTypeTransformation.booleanUnbox((Object)this.binary.get()) && DefaultTypeTransformation.booleanUnbox((Object)this.python3Available.get())) {
                    res = PythonBinary.pfaccess$0(null);
                }
                return res;
            }

            @Generated
            public String getBinary() {
                return ShortTypeHandling.castToString((Object)this.binary.get());
            }

            @Generated
            public String getPythonPath() {
                return ShortTypeHandling.castToString((Object)this.pythonPath.get());
            }

            @Generated
            public boolean getPython3Available() {
                return DefaultTypeTransformation.booleanUnbox((Object)this.python3Available.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public String doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getPythonBinary_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (String)this.environment.globalCache(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{id}, new String[]{"python.binary:", ""})), (Supplier)ScriptBytecodeAdapter.castToType((Object)((Object)new _getPythonBinary_closure1(this, this, binary2, pythonPath2, python3Available2)), Supplier.class));
    }

    private File findSystemBinary(String binary) {
        Reference binary2 = new Reference((Object)binary);
        public final class _findSystemBinary_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference binary;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _findSystemBinary_closure2(Object _outerInstance, Object _thisObject, Reference binary) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.binary = reference = binary;
            }

            public File doCall(Object it) {
                return CliUtils.searchSystemBinary(ShortTypeHandling.castToString((Object)this.binary.get()));
            }

            @Generated
            public String getBinary() {
                return ShortTypeHandling.castToString((Object)this.binary.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public File doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _findSystemBinary_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (File)this.environment.globalCache(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{(String)binary2.get()}, new String[]{"system.binary:", ""})), (Supplier)ScriptBytecodeAdapter.castToType((Object)((Object)new _findSystemBinary_closure2(this, this, binary2)), Supplier.class));
    }

    private String[] prepareArgs(Object args, List<String> pythonArgs, List<String> extraArgs) {
        String[] cmd = CliUtils.parseArgs(args);
        this.detectAndWrapCommand(cmd);
        if (DefaultTypeTransformation.booleanUnbox(pythonArgs)) {
            cmd = CliUtils.mergeArgs(pythonArgs, cmd);
        }
        if (DefaultTypeTransformation.booleanUnbox(extraArgs)) {
            cmd = CliUtils.mergeArgs(cmd, extraArgs);
        }
        return cmd;
    }

    private void detectAndWrapCommand(String ... cmd) {
        Reference cmd2 = new Reference((Object)cmd);
        Reference moduleCall = new Reference((Object)false);
        public final class _detectAndWrapCommand_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference moduleCall;
            private /* synthetic */ Reference cmd;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _detectAndWrapCommand_closure3(Object _outerInstance, Object _thisObject, Reference moduleCall, Reference cmd) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.moduleCall = reference2 = moduleCall;
                this.cmd = reference = cmd;
            }

            public String doCall(String arg, int i) {
                if (ScriptBytecodeAdapter.compareEqual((Object)arg, (Object)"-m")) {
                    boolean bl = true;
                    this.moduleCall.set((Object)bl);
                }
                Object object = this.moduleCall.get();
                if (!(object == null ? false : (Boolean)object) && ScriptBytecodeAdapter.compareEqual((Object)arg, (Object)"-c") && DefaultTypeTransformation.intUnbox((Object)NumberNumberPlus.plus((Number)i, (Number)2)) == ((String[])ScriptBytecodeAdapter.castToType((Object)this.cmd.get(), String[].class)).length) {
                    String string = CliUtils.wrapCommand(ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])((String[])ScriptBytecodeAdapter.castToType((Object)this.cmd.get(), String[].class)), (int)DefaultTypeTransformation.intUnbox((Object)NumberNumberPlus.plus((Number)i, (Number)1)))), ((PythonBinary)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), PythonBinary.class)).isWindows());
                    BytecodeInterface8.objectArraySet((Object[])((String[])ScriptBytecodeAdapter.castToType((Object)this.cmd.get(), String[].class)), (int)DefaultTypeTransformation.intUnbox((Object)NumberNumberPlus.plus((Number)i, (Number)1)), (Object)string);
                    return string;
                }
                return ShortTypeHandling.castToString(null);
            }

            @Generated
            public String call(String arg, int i) {
                return this.doCall(arg, i);
            }

            @Generated
            public Boolean getModuleCall() {
                return (Boolean)ScriptBytecodeAdapter.castToType((Object)this.moduleCall.get(), Boolean.class);
            }

            @Generated
            public String[] getCmd() {
                return (String[])ScriptBytecodeAdapter.castToType((Object)this.cmd.get(), String[].class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _detectAndWrapCommand_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.eachWithIndex((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)((String[])cmd2.get()), Object[].class)), (Closure)new _detectAndWrapCommand_closure3(this, this, moduleCall, cmd2));
    }

    private String findPython(Environment environment, String pythonPath, String binary, boolean validateBinary) {
        String normalizedPath = ShortTypeHandling.castToString(pythonPath == null ? null : Paths.get(pythonPath, new String[0]).normalize().toString());
        boolean python3found = DefaultTypeTransformation.booleanUnbox((Object)binary) || DefaultTypeTransformation.booleanUnbox((Object)pythonPath) ? false : this.detectPython3Binary();
        String executable = this.getPythonBinary(normalizedPath, binary, python3found);
        if (validateBinary && !DefaultTypeTransformation.booleanUnbox((Object)pythonPath) && !this.isDocker()) {
            environment.getLogger().info("Found python binary: {}", (Object)this.findSystemBinary(executable).getAbsolutePath());
        }
        return executable;
    }

    private boolean detectPython3Binary() {
        CallSite[] callSiteArray = PythonBinary.$getCallSiteArray();
        public final class _detectPython3Binary_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _detectPython3Binary_closure4(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _detectPython3Binary_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _detectPython3Binary_closure4.$getCallSiteArray();
                if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGroovyObjectGetProperty((Object)this)) && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[1].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String[])ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{ScriptBytecodeAdapter.getField(_detectPython3Binary_closure4.class, PythonBinary.class, (String)"PYTHON3"), "--version"}), String[].class)), String[].class)), null);
                }
                return !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].callGroovyObjectGetProperty((Object)this)) && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[3].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String[])ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{ScriptBytecodeAdapter.getField(_detectPython3Binary_closure4.class, PythonBinary.class, (String)"PYTHON3"), "--version"}), String[].class)), String[].class)), null);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _detectPython3Binary_closure4.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _detectPython3Binary_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "windows";
                stringArray[1] = "rawExec";
                stringArray[2] = "windows";
                stringArray[3] = "rawExec";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _detectPython3Binary_closure4.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_detectPython3Binary_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _detectPython3Binary_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call((Object)this.environment, (Object)new GStringImpl(new Object[]{DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].callGroovyObjectGetProperty((Object)this)) ? callSiteArray[2].callGroovyObjectGetProperty((Object)this.dockerManager) : ""}, new String[]{"python3.binary:", ""}), (Object)new _detectPython3Binary_closure4(this, this)));
    }

    private String cleanLoggedCommand(String ... cmd) {
        String commandLine = DefaultGroovyMethods.join((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)cmd, Object[].class)), (String)SPACE);
        Reference res = new Reference((Object)commandLine.replace("\r", "").replace(NL, SPACE));
        public final class _cleanLoggedCommand_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference res;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _cleanLoggedCommand_closure5(Object _outerInstance, Object _thisObject, Reference res) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.res = reference = res;
            }

            public String doCall(Object it) {
                String string = ((LoggedCommandCleaner)it).clear(ShortTypeHandling.castToString((Object)this.res.get()));
                this.res.set((Object)string);
                return string;
            }

            @Generated
            public String getRes() {
                return ShortTypeHandling.castToString((Object)this.res.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public String doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _cleanLoggedCommand_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(this.logCleaners, (Closure)new _cleanLoggedCommand_closure5(this, this, res));
        return (String)res.get();
    }

    private String reformatOutputForException(OutputStream os) {
        os.flush();
        String out = ShortTypeHandling.castToString((Object)os);
        public final class _reformatOutputForException_closure6
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _reformatOutputForException_closure6(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public String doCall(Object it) {
                return StringGroovyMethods.plus((String)"\t\t", (CharSequence)((CharSequence)ScriptBytecodeAdapter.castToType((Object)it, CharSequence.class)));
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public String doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _reformatOutputForException_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultTypeTransformation.booleanUnbox((Object)out) ? StringGroovyMethods.plus((String)DefaultGroovyMethods.join((Iterable)DefaultGroovyMethods.collect((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)out.split(NL), Object[].class)), (Closure)new _reformatOutputForException_closure6(this, this)), (String)NL), (CharSequence)NL) : "";
    }

    private void prepareEnvironment() {
        if (this.dockerConfig.getExclusive()) {
            this.environment.getLogger().lifecycle("[docker] executing command in exclusive container '{}' \n{}", new Object[]{this.dockerConfig.getImage(), this.dockerManager.formatContainerInfo(this.dockerConfig, this.workDir, this.envVars)});
        } else {
            this.dockerManager.restartIfRequired(this.dockerConfig, this.workDir, this.envVars);
        }
    }

    private String rawExec(String ... command) {
        Reference command2 = new Reference((Object)command);
        public final class _rawExec_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference command;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _rawExec_closure7(Object _outerInstance, Object _thisObject, Reference command) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.command = reference = command;
            }

            public String doCall(Object os) {
                return ShortTypeHandling.castToString(((PythonBinary)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), PythonBinary.class)).rawExec((String[])ScriptBytecodeAdapter.castToType((Object)this.command.get(), String[].class), (OutputStream)ScriptBytecodeAdapter.castToType((Object)os, OutputStream.class)) == 0 ? ((ByteArrayOutputStream)os).toString() : null);
            }

            @Generated
            public String[] getCommand() {
                return (String[])ScriptBytecodeAdapter.castToType((Object)this.command.get(), String[].class);
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _rawExec_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return ShortTypeHandling.castToString((Object)IOGroovyMethods.withStream((OutputStream)new ByteArrayOutputStream(), (Closure)new _rawExec_closure7(this, this, command2)));
    }

    private int rawExec(String[] command, OutputStream out) {
        long start = System.currentTimeMillis();
        int res = -1;
        String cmdForLog = this.cleanLoggedCommand(command);
        try {
            this.environment.debug(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)cmdForLog, (CharSequence)"    (WorkDir: "), (CharSequence)(this.workDir != null ? this.workDir : this.environment.relativeRootPath(this.environment.getProjectDir().getPath()))), (CharSequence)")"));
            if (this.isDocker()) {
                if (!this.dockerManager.isStarted()) {
                    this.dockerManager.restartIfRequired(this.dockerConfig, this.workDir, this.envVars);
                }
                res = this.dockerConfig.getExclusive() ? this.dockerManager.execExclusive(command, out, this.dockerConfig, this.workDir, this.envVars) : this.dockerManager.exec(command, out);
            } else {
                res = this.environment.exec(command, out, out, this.workDir, this.envVars);
            }
            this.environment.stat(ShortTypeHandling.castToString(this.isDocker() ? this.dockerManager.getContainerName() : null), cmdForLog, this.workDir, !this.customBinaryPath, start, res == 0);
        }
        catch (Throwable throwable) {
            this.environment.stat(ShortTypeHandling.castToString(this.isDocker() ? this.dockerManager.getContainerName() : null), cmdForLog, this.workDir, !this.customBinaryPath, start, res == 0);
            throw throwable;
        }
        return res;
    }

    private String getCommandBinary(String workDir) {
        this.init();
        boolean wrkDirUsed = DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.asType((Object)workDir, Boolean.TYPE));
        return this.withCmd ? "cmd" : (wrkDirUsed && this.customBinaryPath ? CliUtils.canonicalPath(this.environment.file(this.executable)) : this.executable);
    }

    private String[] getCommandArguments(String workDir, Object args, List<String> pythonArgs, List<String> extraArgs) {
        this.init();
        boolean wrkDirUsed = DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.asType((Object)workDir, Boolean.TYPE));
        return this.withCmd ? CliUtils.wincmdArgs(this.executable, this.environment.getProjectDir(), this.prepareArgs(args, pythonArgs, extraArgs), wrkDirUsed) : this.prepareArgs(args, pythonArgs, extraArgs);
    }

    private void beforeInit(String message) {
        if (this.initialized) {
            throw (Throwable)new IllegalStateException(message);
        }
    }

    public static /* synthetic */ String pfaccess$0(PythonBinary $that) {
        return ShortTypeHandling.castToString((Object)ScriptBytecodeAdapter.getField(PythonBinary.class, PythonBinary.class, (String)"PYTHON3"));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != PythonBinary.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        String string;
        String string2;
        NL = string2 = "\n";
        SPACE = string = " ";
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "globalCache";
        stringArray[1] = "docker";
        stringArray[2] = "containerName";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[3];
        PythonBinary.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(PythonBinary.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = PythonBinary.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

