/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.gradle.plugin.python.task;

import groovy.lang.GString;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import java.lang.ref.SoftReference;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.GradleException;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.internal.ExecException;
import ru.vyarus.gradle.plugin.python.PythonExtension;
import ru.vyarus.gradle.plugin.python.cmd.Pip;
import ru.vyarus.gradle.plugin.python.cmd.Python;
import ru.vyarus.gradle.plugin.python.cmd.env.Environment;
import ru.vyarus.gradle.plugin.python.service.EnvService;
import ru.vyarus.gradle.plugin.python.task.env.EnvSupport;
import ru.vyarus.gradle.plugin.python.task.env.FallbackException;
import ru.vyarus.gradle.plugin.python.task.env.VenvSupport;
import ru.vyarus.gradle.plugin.python.task.env.VirtualenvSupport;
import ru.vyarus.gradle.plugin.python.task.pip.BasePipTask;
import ru.vyarus.gradle.plugin.python.util.CliUtils;
import ru.vyarus.gradle.plugin.python.util.PythonExecutionFailed;

public abstract class CheckPythonTask
extends BasePipTask {
    private static final Object SYNC;
    private boolean virtual;
    private boolean envCreated;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public CheckPythonTask() {
        boolean bl;
        boolean bl2;
        this.virtual = bl2 = false;
        this.envCreated = bl = false;
    }

    @Input
    public abstract Property<PythonExtension.Scope> getScope();

    @Input
    public abstract Property<String> getEnvPath();

    @Input
    @Optional
    public abstract Property<String> getMinPythonVersion();

    @Input
    @Optional
    public abstract Property<String> getMinPipVersion();

    @Input
    public abstract Property<Boolean> getUseVenv();

    @Input
    public abstract Property<Boolean> getInstallVirtualenv();

    @Input
    public abstract Property<String> getVirtualenvVersion();

    @Input
    @Optional
    public abstract Property<String> getMinVirtualenvVersion();

    @Input
    public abstract Property<Boolean> getEnvCopy();

    @TaskAction
    public void run() {
        EnvSupport envSupport;
        ((EnvService)this.getEnvService().get()).setPythonPath(((Environment)this.getGradleEnv().get()).getProjectPath(), ShortTypeHandling.castToString((Object)this.getPythonPath().getOrNull()));
        boolean envRequested = ScriptBytecodeAdapter.compareGreaterThanEqual((Object)this.getScope().get(), (Object)((Object)PythonExtension.Scope.VIRTUALENV_OR_USER));
        if (envRequested) {
            Object object = this.getUseVenv().get();
            envSupport = (object == null ? false : (Boolean)object) ? new VenvSupport(this) : new VirtualenvSupport(this);
        } else {
            envSupport = null;
        }
        EnvSupport env = (EnvSupport)ScriptBytecodeAdapter.castToType(envSupport, EnvSupport.class);
        Object object = SYNC;
        synchronized (object) {
            if (envRequested && env.exists()) {
                boolean bl;
                this.virtual = bl = true;
            } else {
                this.checkPython();
                if (this.isModulesInstallationRequired()) {
                    this.checkPip();
                    if (envRequested) {
                        try {
                            boolean bl;
                            this.virtual = bl = this.checkEnv(env);
                        }
                        catch (FallbackException ignored) {
                            boolean bl;
                            env = new VirtualenvSupport(this);
                            this.virtual = bl = this.checkEnv(env);
                        }
                    }
                }
            }
        }
        if (this.virtual) {
            this.switchEnvironment(env);
        }
        if (!this.getPython().getCanonicalBinaryDir().startsWith(this.getPython().getCanonicalHomeDir())) {
            this.getLogger().error(StringGroovyMethods.plus((String)"WARNING: Python binary path '{}' does not match home path reported by python (sys.prefix): ", (CharSequence)"'{}'. Everything could still work as expected if code doesn't rely on python location."), (Object)this.getPython().getCanonicalBinaryDir(), (Object)this.getPython().getCanonicalHomeDir());
        }
    }

    @Internal
    public String getActualPythonPath() {
        return ((EnvService)this.getEnvService().get()).getPythonPath(((Environment)this.getGradleEnv().get()).getProjectPath());
    }

    private void checkPython() {
        Python python = new Python((Environment)ScriptBytecodeAdapter.castToType((Object)this.getGradleEnv().get(), Environment.class), this.getActualPythonPath(), ShortTypeHandling.castToString((Object)this.getPythonBinary().getOrNull())).workDir(ShortTypeHandling.castToString((Object)this.getWorkDir().getOrNull())).environment((Map)ScriptBytecodeAdapter.castToType((Object)this.getEnvironment().get(), Map.class)).validateSystemBinary(DefaultTypeTransformation.booleanUnbox((Object)this.getValidateSystemBinary().get())).withDocker(this.getDocker().toConfig()).validate();
        try {
            python.getVersion();
        }
        catch (ExecException ex) {
            throw (Throwable)new GradleException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{python.getCanonicalUsedBinary()}, new String[]{"Python not found: ", ". "}).plus(this.virtual ? StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"This must be a bug of virtualenv support, please report it ", (CharSequence)"(https://github.com/xvik/gradle-use-python-plugin/issues). You can disable "), (CharSequence)"virtualenv usage with 'python.scope = USER'.") : StringGroovyMethods.plus((String)"Please install it (http://docs.python-guide.org/en/latest/starting/installation/) ", (CharSequence)"or configure correct location with 'python.pythonPath'."))), (Throwable)ex);
        }
        this.checkPythonVersion(python);
    }

    private void checkPythonVersion(Python python) {
        String version = python.getVersion();
        if (!CliUtils.isVersionMatch(version, ShortTypeHandling.castToString((Object)this.getMinPythonVersion().getOrNull()))) {
            throw (Throwable)new GradleException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{python.getHomeDir(), version}, new String[]{"Python (", ") verion ", " does not match minimal "}).plus((GString)new GStringImpl(new Object[]{this.getMinPythonVersion().get()}, new String[]{"required version: ", ""}))));
        }
        this.getLogger().lifecycle("Using python {} from {} ({})", new Object[]{python.getVersion(), python.getCanonicalHomeDir(), python.getCanonicalUsedBinary()});
    }

    private void checkPip() {
        Pip pip = new Pip((Environment)ScriptBytecodeAdapter.castToType((Object)this.getGradleEnv().get(), Environment.class), this.getActualPythonPath(), ShortTypeHandling.castToString((Object)this.getPythonBinary().getOrNull())).userScope(false).workDir(ShortTypeHandling.castToString((Object)this.getWorkDir().getOrNull())).environment((Map)ScriptBytecodeAdapter.castToType((Object)this.getEnvironment().get(), Map.class)).validateSystemBinary(DefaultTypeTransformation.booleanUnbox((Object)this.getValidateSystemBinary().get())).withDocker(this.getDocker().toConfig()).validate();
        try {
            pip.getVersionLine();
        }
        catch (PythonExecutionFailed ex) {
            throw (Throwable)new GradleException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.virtual ? new GStringImpl(new Object[]{this.getEnvPath().get()}, new String[]{" on virtualenv ", ""}) : ""}, new String[]{"Pip is not installed", ". "}).plus("Please install it (https://pip.pypa.io/en/stable/installing/).")), (Throwable)((Object)ex));
        }
        this.checkPipVersion(pip);
    }

    private void checkPipVersion(Pip pip) {
        String version = pip.getVersion();
        if (!CliUtils.isVersionMatch(version, ShortTypeHandling.castToString((Object)this.getMinPipVersion().getOrNull()))) {
            throw (Throwable)new GradleException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{version}, new String[]{"Pip verion ", " does not match minimal "}).plus((GString)new GStringImpl(new Object[]{this.getMinPipVersion().get()}, new String[]{"required version: ", ". Use 'pip install -U pip' to upgrade pip."}))));
        }
        this.getLogger().lifecycle("Using {}", new Object[]{pip.getVersionLine()});
    }

    private boolean checkEnv(EnvSupport env) {
        CallSite[] callSiteArray = CheckPythonTask.$getCallSiteArray();
        Pip pip = (Pip)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].call(callSiteArray[6].call(callSiteArray[7].callConstructor(Pip.class, callSiteArray[8].call(callSiteArray[9].callGroovyObjectGetProperty((Object)this)), callSiteArray[10].callGroovyObjectGetProperty((Object)this), callSiteArray[11].callGetProperty(callSiteArray[12].callGroovyObjectGetProperty((Object)this))), (Object)true), callSiteArray[13].call(callSiteArray[14].callGroovyObjectGetProperty((Object)this))), callSiteArray[15].callGetProperty(callSiteArray[16].callGroovyObjectGetProperty((Object)this))), callSiteArray[17].call(callSiteArray[18].callGroovyObjectGetProperty((Object)this))), callSiteArray[19].call(callSiteArray[20].callGroovyObjectGetProperty((Object)this))), callSiteArray[21].call(callSiteArray[22].callCurrent((GroovyObject)this)))), Pip.class);
        callSiteArray[23].call(callSiteArray[24].call(callSiteArray[25].callGroovyObjectGetProperty((Object)this)), (Object)"Creating environment");
        Object object = callSiteArray[26].call((Object)env, (Object)pip);
        this.envCreated = DefaultTypeTransformation.booleanUnbox((Object)object);
        return this.envCreated;
    }

    private void switchEnvironment(EnvSupport env) {
        ((EnvService)this.getEnvService().get()).setPythonPath(((Environment)this.getGradleEnv().get()).getProjectPath(), env.getPythonPath());
        this.checkPython();
        if (this.isModulesInstallationRequired()) {
            this.checkPip();
        }
        if (!this.getPython().isVirtualenv()) {
            throw (Throwable)new GradleException(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"Configured environment is not a virtualenv: ", (CharSequence)new GStringImpl(new Object[]{((Environment)this.getGradleEnv().get()).file(ShortTypeHandling.castToString((Object)this.getEnvPath().get())).getAbsolutePath()}, new String[]{"", ". "})), (CharSequence)"Most likely, issue appear due to incorrect `python.envPath` configuration."));
        }
        if (this.envCreated) {
            this.dockerChown(ShortTypeHandling.castToString((Object)this.getEnvPath().get()));
        }
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != CheckPythonTask.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        Object object;
        SYNC = object = new Object();
    }

    public /* synthetic */ MetaClass super$5$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "validate";
        stringArray[1] = "withDocker";
        stringArray[2] = "validateSystemBinary";
        stringArray[3] = "environment";
        stringArray[4] = "workDir";
        stringArray[5] = "breakSystemPackages";
        stringArray[6] = "userScope";
        stringArray[7] = "<$constructor$>";
        stringArray[8] = "get";
        stringArray[9] = "gradleEnv";
        stringArray[10] = "actualPythonPath";
        stringArray[11] = "orNull";
        stringArray[12] = "pythonBinary";
        stringArray[13] = "get";
        stringArray[14] = "breakSystemPackages";
        stringArray[15] = "orNull";
        stringArray[16] = "workDir";
        stringArray[17] = "get";
        stringArray[18] = "environment";
        stringArray[19] = "get";
        stringArray[20] = "validateSystemBinary";
        stringArray[21] = "toConfig";
        stringArray[22] = "getDocker";
        stringArray[23] = "debug";
        stringArray[24] = "get";
        stringArray[25] = "gradleEnv";
        stringArray[26] = "create";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[27];
        CheckPythonTask.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(CheckPythonTask.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = CheckPythonTask.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

