/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent;

import java.beans.ConstructorProperties;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.codeguruprofilerjavaagent.CodeGuruProfilerSDKClient;
import software.amazon.codeguruprofilerjavaagent.CodeGuruProfilerSDKClientOverrideConfiguration;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.AgentMetadata;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.ErrorsMetadata;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.FleetInfo;

class CodeGuruProfilerSDKClientProvider {
    private final String profilingGroupName;
    private final AwsCredentialsProvider awsCredentialsProvider;
    private final Region awsRegion;
    private final ErrorsMetadata errorsMetadata;
    private final AgentMetadata agentMetadata;
    private CodeGuruProfilerSDKClient client;

    public CodeGuruProfilerSDKClient getClient() {
        if (this.client == null) {
            String fleetInstanceId = this.agentMetadata.getFleetInfo().map(FleetInfo::getFleetInstanceId).orElse("");
            this.client = new CodeGuruProfilerSDKClient(this.profilingGroupName, fleetInstanceId, this.awsCredentialsProvider, this.awsRegion, CodeGuruProfilerSDKClientOverrideConfiguration.DEFAULT, this.errorsMetadata);
        }
        return this.client;
    }

    @ConstructorProperties(value={"profilingGroupName", "awsCredentialsProvider", "awsRegion", "errorsMetadata", "agentMetadata", "client"})
    CodeGuruProfilerSDKClientProvider(String profilingGroupName, AwsCredentialsProvider awsCredentialsProvider, Region awsRegion, ErrorsMetadata errorsMetadata, AgentMetadata agentMetadata, CodeGuruProfilerSDKClient client) {
        this.profilingGroupName = profilingGroupName;
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.awsRegion = awsRegion;
        this.errorsMetadata = errorsMetadata;
        this.agentMetadata = agentMetadata;
        this.client = client;
    }

    public static CodeGuruProfilerSDKClientProviderBuilder builder() {
        return new CodeGuruProfilerSDKClientProviderBuilder();
    }

    public static class CodeGuruProfilerSDKClientProviderBuilder {
        private String profilingGroupName;
        private AwsCredentialsProvider awsCredentialsProvider;
        private Region awsRegion;
        private ErrorsMetadata errorsMetadata;
        private AgentMetadata agentMetadata;
        private CodeGuruProfilerSDKClient client;

        public Region getAwsRegion() {
            return this.awsRegion;
        }

        public AwsCredentialsProvider getAwsCredentialsProvider() {
            return this.awsCredentialsProvider;
        }

        CodeGuruProfilerSDKClientProviderBuilder() {
        }

        public CodeGuruProfilerSDKClientProviderBuilder profilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
            return this;
        }

        public CodeGuruProfilerSDKClientProviderBuilder awsCredentialsProvider(AwsCredentialsProvider awsCredentialsProvider) {
            this.awsCredentialsProvider = awsCredentialsProvider;
            return this;
        }

        public CodeGuruProfilerSDKClientProviderBuilder awsRegion(Region awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public CodeGuruProfilerSDKClientProviderBuilder errorsMetadata(ErrorsMetadata errorsMetadata) {
            this.errorsMetadata = errorsMetadata;
            return this;
        }

        public CodeGuruProfilerSDKClientProviderBuilder agentMetadata(AgentMetadata agentMetadata) {
            this.agentMetadata = agentMetadata;
            return this;
        }

        public CodeGuruProfilerSDKClientProviderBuilder client(CodeGuruProfilerSDKClient client) {
            this.client = client;
            return this;
        }

        public CodeGuruProfilerSDKClientProvider build() {
            return new CodeGuruProfilerSDKClientProvider(this.profilingGroupName, this.awsCredentialsProvider, this.awsRegion, this.errorsMetadata, this.agentMetadata, this.client);
        }

        public String toString() {
            return "CodeGuruProfilerSDKClientProvider.CodeGuruProfilerSDKClientProviderBuilder(profilingGroupName=" + this.profilingGroupName + ", awsCredentialsProvider=" + this.awsCredentialsProvider + ", awsRegion=" + this.awsRegion + ", errorsMetadata=" + this.errorsMetadata + ", agentMetadata=" + this.agentMetadata + ", client=" + this.client + ")";
        }
    }
}

