/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent;

class Counter {
    public static final String AVERAGE_SUFFIX = "_average";
    public static final String MAX_SUFFIX = "_max";
    private long count;
    private long sum;
    private long max;

    Counter() {
    }

    synchronized long getSum() {
        return this.sum;
    }

    synchronized MaxAndAverage getMaxAndAverage() {
        return new MaxAndAverage(this.max, this.getAverage());
    }

    private long getAverage() {
        if (this.count == 0L) {
            return 0L;
        }
        return this.sum / this.count;
    }

    synchronized long getCount() {
        return this.count;
    }

    synchronized void count(long value) {
        ++this.count;
        this.sum += value;
        this.max = Math.max(this.max, value);
    }

    synchronized void reset() {
        this.count = 0L;
        this.sum = 0L;
        this.max = 0L;
    }

    static class MaxAndAverage {
        private final long max;
        private final long average;

        MaxAndAverage(long max, long average) {
            this.max = max;
            this.average = average;
        }

        public long getMax() {
            return this.max;
        }

        public long getAverage() {
            return this.average;
        }
    }
}

