/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent.jvmagent;

import java.util.logging.Level;
import java.util.logging.Logger;
import software.amazon.codeguruprofilerjavaagent.EnvironmentReader;
import software.amazon.codeguruprofilerjavaagent.IProfiler;
import software.amazon.codeguruprofilerjavaagent.Profiler;
import software.amazon.codeguruprofilerjavaagent.ProfilerWithPause;
import software.amazon.codeguruprofilerjavaagent.jvmagent.JvmArgumentParser;
import software.amazon.codeguruprofilerjavaagent.jvmagent.LambdaJvmArgumentParser;
import software.amazon.codeguruprofilerjavaagent.jvmagent.ProfilerShutdownHook;

class ProfilerAsJvmAgent {
    private static final Logger LOG = Logger.getLogger(ProfilerAsJvmAgent.class.getName());
    private static EnvironmentReader environmentReader = new EnvironmentReader();

    private ProfilerAsJvmAgent() {
    }

    public static void premain(String agentArgs) {
        try {
            IProfiler profiler = ProfilerAsJvmAgent.isInstanceTypeLambda() ? ProfilerAsJvmAgent.getLambdaProfiler(agentArgs) : ProfilerAsJvmAgent.getNonLambdaProfiler(agentArgs);
            ProfilerAsJvmAgent.tryAddShutdownHook(profiler);
            profiler.start();
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "There was a problem starting the profiler", e);
        }
    }

    private static IProfiler getLambdaProfiler(String agentArgs) {
        LambdaJvmArgumentParser argumentParser = new LambdaJvmArgumentParser(agentArgs);
        ProfilerWithPause.Builder builder = ProfilerWithPause.builder();
        builder.environmentReader(environmentReader);
        argumentParser.configureProfilerBuilder(builder);
        return builder.build();
    }

    private static IProfiler getNonLambdaProfiler(String agentArgs) {
        JvmArgumentParser argumentParser = new JvmArgumentParser(agentArgs);
        Profiler.Builder builder = Profiler.builder();
        argumentParser.configureProfilerBuilder(builder);
        return builder.build();
    }

    private static boolean isInstanceTypeLambda() {
        return environmentReader.get("LAMBDA_TASK_ROOT") != null && environmentReader.get("LAMBDA_RUNTIME_DIR") != null;
    }

    private static void tryAddShutdownHook(IProfiler profiler) {
        try {
            Runtime.getRuntime().addShutdownHook(new ProfilerShutdownHook(profiler));
        }
        catch (Exception e) {
            LOG.info("Failed to add Profiler shutdown hook: " + e.getMessage());
        }
    }

    static void setEnv(EnvironmentReader newEnvironmentReader) {
        environmentReader = newEnvironmentReader;
    }
}

