/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent.profile;

import com.amazon.ion.IonWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.time.Instant;
import java.util.Map;
import java.util.logging.Logger;
import software.amazon.codeguruprofilerjavaagent.profile.IonUtils;

public class AgentDebugInfo {
    private static final Logger LOG = Logger.getLogger(AgentDebugInfo.class.getName());
    private static final Long COMPUTED_PROCESS_ID = AgentDebugInfo.getProcessId();
    private final Map<String, Long> genericMetrics;
    private final Instant agentStartTime;
    private final Long processId;

    public AgentDebugInfo(Map<String, Long> genericMetrics, Instant agentStartTime) {
        this.genericMetrics = genericMetrics;
        this.agentStartTime = agentStartTime;
        this.processId = COMPUTED_PROCESS_ID;
    }

    AgentDebugInfo(Map<String, Long> genericMetrics, Instant agentStartTime, Long processId) {
        this.genericMetrics = genericMetrics;
        this.agentStartTime = agentStartTime;
        this.processId = processId;
    }

    public static AgentDebugInfo empty() {
        return new AgentDebugInfo(null, null, null);
    }

    void write(IonWriter out, String fieldName) throws IOException {
        IonUtils.writeStruct(out, fieldName, () -> {
            if (this.genericMetrics != null && !this.genericMetrics.isEmpty()) {
                IonUtils.writeStruct(out, "genericMetrics", () -> {
                    for (Map.Entry<String, Long> metricEntry : this.genericMetrics.entrySet()) {
                        IonUtils.writeInt(out, metricEntry.getKey(), metricEntry.getValue());
                    }
                });
            }
            if (this.agentStartTime != null) {
                IonUtils.writeTimestamp(out, "agentStartTime", this.agentStartTime);
            }
            if (this.processId != null) {
                IonUtils.writeInt(out, "processId", this.processId);
            }
        });
    }

    public Map<String, Long> getGenericMetrics() {
        return this.genericMetrics;
    }

    private static Long getProcessId() {
        try {
            String processName = ManagementFactory.getRuntimeMXBean().getName();
            return Long.parseLong(processName.substring(0, processName.indexOf(64)));
        }
        catch (Exception e) {
            LOG.info("Failed to get the process id, " + e.getMessage());
            return null;
        }
    }
}

