/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent.profile;

import com.amazon.ion.IonSystem;
import com.amazon.ion.IonWriter;
import com.amazon.ion.SymbolTable;
import com.amazon.ion.SymbolToken;
import com.amazon.ion.UnknownSymbolException;
import com.amazon.ion.system.IonBinaryWriterBuilder;
import com.amazon.ion.system.IonSystemBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Map;
import software.amazon.codeguruprofilerjavaagent.profile.CallGraph;
import software.amazon.codeguruprofilerjavaagent.profile.IonUtils;
import software.amazon.codeguruprofilerjavaagent.profile.Profile;
import software.amazon.codeguruprofilerjavaagent.profile.StateEncodings;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.AgentMetadataIonWriter;

public class ProfileIonSerializer {
    static final BigDecimal CURRENT_SCHEMA_VERSION = BigDecimal.valueOf(1.0);
    private final IonSystem system = IonSystemBuilder.standard().build();

    public void serialize(Profile profile, OutputStream out) throws IOException {
        SymbolTable symbols = this.system.newLocalSymbolTable(new SymbolTable[0]);
        SymbolToken countsSymbol = symbols.intern("counts");
        SymbolToken childrensToken = symbols.intern("children");
        SymbolToken[] stateMapping = this.encodeSymbols(StateEncodings.getEncodings(), symbols);
        try (IonWriter writer = IonBinaryWriterBuilder.standard().withInitialSymbolTable(symbols).build(out);){
            this.writeProfile(profile, writer, countsSymbol, childrensToken, stateMapping, profile.getFrameEncodings().getEncodings());
        }
    }

    private SymbolToken[] encodeSymbols(Map<Integer, String> encodings, SymbolTable symbolTable) {
        SymbolToken[] remapping = new SymbolTokenWithoutText[encodings.size()];
        for (int i = 0; i < encodings.size(); ++i) {
            remapping[i] = new SymbolTokenWithoutText(symbolTable.intern(encodings.get(i)).getSid());
        }
        return remapping;
    }

    private void writeProfile(Profile profile, IonWriter out, SymbolToken countsSymbol, SymbolToken childrensToken, SymbolToken[] stateMapping, Map<Integer, String> frameMapping) throws IOException {
        IonUtils.writeStruct(out, () -> {
            IonUtils.writeDecimal(out, "schemaVersion", CURRENT_SCHEMA_VERSION);
            IonUtils.writeTimestamp(out, "start", profile.getStart());
            IonUtils.writeTimestamp(out, "end", profile.getEnd());
            out.setFieldName("callgraph");
            this.writeCallGraphNode(profile.getRoot(), out, countsSymbol, childrensToken, stateMapping, frameMapping);
            out.setFieldName("agentMetadata");
            AgentMetadataIonWriter.write(out, profile.getAgentMetadata(), profile.getSamplingMetadata());
            profile.getAgentDebugInfo().write(out, "debugInfo");
        });
    }

    private void writeCallGraphNode(CallGraph node, IonWriter out, SymbolToken countsSymbol, SymbolToken childrensToken, SymbolToken[] stateMapping, Map<Integer, String> frameMapping) throws IOException {
        IonUtils.writeStruct(out, () -> {
            this.writeCounts(node.getCounts(), out, countsSymbol, stateMapping);
            this.writeChildren(node.getChildren(), out, countsSymbol, childrensToken, stateMapping, frameMapping);
        });
    }

    private void writeCounts(long[] counts, IonWriter out, SymbolToken countsSymbol, SymbolToken[] stateMapping) throws IOException {
        if (counts.length == 0) {
            return;
        }
        out.setFieldNameSymbol(countsSymbol);
        IonUtils.writeStruct(out, () -> {
            for (int i = 0; i < counts.length; ++i) {
                if (counts[i] <= 0L) continue;
                out.setFieldNameSymbol(stateMapping[i]);
                out.writeInt(counts[i]);
            }
        });
    }

    private void writeChildren(CallGraph[] children, IonWriter out, SymbolToken countsSymbol, SymbolToken childrensToken, SymbolToken[] stateMapping, Map<Integer, String> frameMapping) throws IOException {
        if (children.length == 0) {
            return;
        }
        out.setFieldNameSymbol(childrensToken);
        IonUtils.writeStruct(out, () -> {
            for (CallGraph child : children) {
                if (!child.hasCounts()) continue;
                out.setFieldName((String)frameMapping.get(child.getFrame()));
                this.writeCallGraphNode(child, out, countsSymbol, childrensToken, stateMapping, frameMapping);
            }
        });
    }

    private static class SymbolTokenWithoutText
    implements SymbolToken {
        private final int sid;

        public SymbolTokenWithoutText(int sid) {
            this.sid = sid;
        }

        public String getText() {
            return null;
        }

        public String assumeText() {
            throw new UnknownSymbolException(this.sid);
        }

        public int getSid() {
            return this.sid;
        }
    }
}

