/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent.profile.metadata;

import com.amazon.ion.IonWriter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import software.amazon.codeguruprofilerjavaagent.profile.IonUtils;

public class ErrorsMetadata {
    private int errorsCount = 0;
    private int profilingCommandErrors = 0;
    private int sdkClientErrors = 0;
    private int fargateErrors = 0;
    private int gcErrors = 0;

    synchronized void write(IonWriter out, String fieldName) throws IOException {
        IonUtils.writeStruct(out, fieldName, () -> {
            IonUtils.writeInt(out, "errorsCount", this.errorsCount);
            IonUtils.writeInt(out, "profilingCommandErrors", this.profilingCommandErrors);
            IonUtils.writeInt(out, "sdkClientErrors", this.sdkClientErrors);
            IonUtils.writeInt(out, "fargateErrors", this.fargateErrors);
            IonUtils.writeInt(out, "gcErrors", this.gcErrors);
        });
    }

    public synchronized void incrementErrors() {
        ++this.errorsCount;
    }

    public synchronized void incrementProfiling() {
        ++this.errorsCount;
        ++this.profilingCommandErrors;
    }

    public synchronized void incrementSdk() {
        ++this.errorsCount;
        ++this.sdkClientErrors;
    }

    public synchronized void incrementFargate() {
        ++this.errorsCount;
        ++this.fargateErrors;
    }

    public synchronized void incrementGc() {
        ++this.errorsCount;
        ++this.gcErrors;
    }

    public void record(Logger logger, Level level, String message, Exception e) {
        logger.log(level, message, e);
        this.incrementErrors();
    }

    public void recordProfiling(Logger logger, Level level, String message, Exception e) {
        logger.log(level, message, e);
        this.incrementProfiling();
    }

    public void recordSdk(Logger logger, Level level, String message, Exception e) {
        logger.log(level, message, e);
        this.incrementSdk();
    }

    public void recordFargate(Logger logger, Level level, String message) {
        logger.log(level, message);
        this.incrementFargate();
    }

    public void recordGc(Logger logger, Level level, String message, Exception e) {
        logger.log(level, message, e);
        this.incrementGc();
    }

    public synchronized int getErrorsCount() {
        return this.errorsCount;
    }

    public synchronized int getProfiling() {
        return this.profilingCommandErrors;
    }

    public synchronized int getSdk() {
        return this.sdkClientErrors;
    }

    public synchronized int getFargate() {
        return this.fargateErrors;
    }

    public synchronized int getGc() {
        return this.gcErrors;
    }
}

