/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent;

import com.amazonaws.services.lambda.runtime.Context;
import java.util.logging.Logger;
import software.amazon.codeguruprofilerjavaagent.LambdaProfilerUtils;
import software.amazon.codeguruprofilerjavaagent.ProfilerWithPause;

abstract class LambdaRequestHandler {
    private static final Logger LOG = Logger.getLogger(LambdaRequestHandler.class.getName());
    private static ProfilerWithPause profilerWithPause;
    private static boolean createProfilerAttempted;

    LambdaRequestHandler() {
    }

    protected static void resumeProfiler(Context context) {
        try {
            if (LambdaRequestHandler.getProfiler(context) != null) {
                LambdaRequestHandler.getProfiler(context).resume(context);
            }
        }
        catch (Exception e) {
            LOG.info("Exception while starting/resuming profiler, disabling profiler. " + e);
            profilerWithPause = null;
        }
    }

    protected static void pauseProfiler(Context context) {
        try {
            if (LambdaRequestHandler.getProfiler(context) != null) {
                LambdaRequestHandler.getProfiler(context).pause();
            }
        }
        catch (Exception e) {
            LOG.info("Exception while pausing profiler, disabling profiler. " + e);
            profilerWithPause = null;
        }
    }

    protected static ProfilerWithPause getProfiler(Context context) {
        if (!createProfilerAttempted) {
            createProfilerAttempted = true;
            if (LambdaProfilerUtils.isProfilerEnabled()) {
                profilerWithPause = LambdaProfilerUtils.attemptToCreateProfiler(context);
            }
        }
        return profilerWithPause;
    }
}

