/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeNotFoundException;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import software.amazon.codeguruprofilerjavaagent.Profiler;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.ErrorsMetadata;

class GarbageCollectorMonitor {
    private static final Logger LOG = Logger.getLogger(Profiler.class.getName());
    private Date lastRunDate = new Date();
    private final List<GCType> gcTypes = new ArrayList<GCType>();
    private final MBeanServerConnection server = ManagementFactory.getPlatformMBeanServer();
    private final int availableProcessors = Runtime.getRuntime().availableProcessors();
    private final ErrorsMetadata errorsMetadata;

    public GarbageCollectorMonitor(ErrorsMetadata errorsMetadata) {
        this.errorsMetadata = errorsMetadata;
        try {
            for (ObjectName jmxName : this.server.queryNames(new ObjectName("java.lang:type=GarbageCollector,*"), null)) {
                this.gcTypes.add(new GCType(jmxName));
            }
        }
        catch (IOException | JMException e) {
            errorsMetadata.recordGc(LOG, Level.INFO, "Failed to connect to GarbageCollector MBeans", e);
        }
        this.pollAndReportDiff();
    }

    public List<GCTimeSpent> pollAndReportDiff() {
        ArrayList<GCTimeSpent> result = new ArrayList<GCTimeSpent>();
        if (this.gcTypes == null || this.server == null) {
            return result;
        }
        Date runDate = new Date();
        long millisSinceLastRun = runDate.getTime() - this.lastRunDate.getTime();
        try {
            for (GCType gcType : this.gcTypes) {
                GCStat current = this.getStats(gcType);
                if (gcType.prevGCStat != null) {
                    long millisUsed = current.time - gcType.prevGCStat.time;
                    result.add(new GCTimeSpent(gcType.label, millisUsed, millisSinceLastRun, current.numGCThreads));
                }
                gcType.prevGCStat = current;
            }
        }
        catch (IOException | JMException e) {
            this.errorsMetadata.recordGc(LOG, Level.INFO, "Failed to gather GC stats", e);
        }
        this.lastRunDate = runDate;
        return result;
    }

    private GCStat getStats(GCType gcType) throws JMException, IOException {
        GCStat result = new GCStat();
        result.time = (Long)this.server.getAttribute(gcType.jmxName, "CollectionTime");
        result.numGCThreads = 1;
        try {
            CompositeData data = (CompositeData)this.server.getAttribute(gcType.jmxName, "LastGcInfo");
            if (data != null) {
                int threadsConfigured = (Integer)data.get("GcThreadCount");
                result.numGCThreads = Math.min(threadsConfigured, this.availableProcessors);
            }
        }
        catch (AttributeNotFoundException e) {
            this.errorsMetadata.incrementGc();
        }
        return result;
    }

    protected Set<String> getAllKnownLabels() {
        HashSet<String> results = new HashSet<String>();
        for (GCType gcType : this.gcTypes) {
            results.add(gcType.label);
        }
        return results;
    }

    public static class GCTimeSpent {
        private final String label;
        private final float fractionOfTime;
        private final int numGCThreads;

        GCTimeSpent(String label, long gcTimeMills, long overallTimeMillis, int threads) {
            this.label = label != null && !label.isEmpty() ? label : "Unknown";
            this.fractionOfTime = overallTimeMillis > 0L ? (float)gcTimeMills / (float)overallTimeMillis : 0.0f;
            this.numGCThreads = threads;
        }

        public String getLabel() {
            return this.label;
        }

        public float getFractionOfTime() {
            return this.fractionOfTime;
        }

        public int getNumGCThreads() {
            return this.numGCThreads;
        }

        public String toString() {
            int percent = 100;
            return this.label + " at " + 100.0f * this.fractionOfTime + "% on " + this.numGCThreads + " threads";
        }
    }

    private static class GCStat {
        private long time;
        private int numGCThreads;

        private GCStat() {
        }
    }

    private static class GCType {
        private final ObjectName jmxName;
        private final String label;
        private GCStat prevGCStat;

        public GCType(ObjectName name) {
            this.jmxName = name;
            this.label = name.getKeyProperty("name").replace(' ', '_');
        }
    }
}

