/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent.profile.metadata;

import com.amazon.ion.IonWriter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import software.amazon.codeguruprofilerjavaagent.profile.IonUtils;
import software.amazon.codeguruprofilerjavaagent.profile.ProfileIonKeys;

public class ErrorsMetadata {
    private int errorsCount;
    private int profilingCommandErrors;
    private int sdkClientErrors;
    private int fargateErrors;
    private int gcErrors;
    private int configureAgentErrors;
    private int configureAgentRnfeAutoCreateEnabledErrors;
    private int createProfilingGroupErrors;
    private int postAgentProfileErrors;
    private int postAgentProfileRnfeAutoCreateEnabledErrors;

    public void reset() {
        this.errorsCount = 0;
        this.profilingCommandErrors = 0;
        this.sdkClientErrors = 0;
        this.fargateErrors = 0;
        this.gcErrors = 0;
        this.configureAgentErrors = 0;
        this.configureAgentRnfeAutoCreateEnabledErrors = 0;
        this.createProfilingGroupErrors = 0;
        this.postAgentProfileErrors = 0;
        this.postAgentProfileRnfeAutoCreateEnabledErrors = 0;
    }

    public void write(IonWriter out, String fieldName) throws IOException {
        IonUtils.writeStruct(out, fieldName, () -> {
            IonUtils.writeInt(out, "errorsCount", this.errorsCount);
            IonUtils.writeInt(out, "profilingCommandErrors", this.profilingCommandErrors);
            IonUtils.writeInt(out, "sdkClientErrors", this.sdkClientErrors);
            IonUtils.writeInt(out, ProfileIonKeys.SDK_ERROR_TYPE.CONFIGURE_AGENT_ERRORS.getErrorType(), this.configureAgentErrors);
            IonUtils.writeInt(out, ProfileIonKeys.SDK_ERROR_TYPE.CONFIGURE_AGENT_RNFE_AUTO_CREATE_ENABLED_ERRORS.getErrorType(), this.configureAgentRnfeAutoCreateEnabledErrors);
            IonUtils.writeInt(out, ProfileIonKeys.SDK_ERROR_TYPE.CREATE_PROFILING_GROUP_ERRORS.getErrorType(), this.createProfilingGroupErrors);
            IonUtils.writeInt(out, ProfileIonKeys.SDK_ERROR_TYPE.POST_AGENT_PROFILE_ERRORS.getErrorType(), this.postAgentProfileErrors);
            IonUtils.writeInt(out, ProfileIonKeys.SDK_ERROR_TYPE.POST_AGENT_PROFILE_RNFE_AUTO_CREATE_ENABLED_ERRORS.getErrorType(), this.postAgentProfileRnfeAutoCreateEnabledErrors);
            IonUtils.writeInt(out, "fargateErrors", this.fargateErrors);
            IonUtils.writeInt(out, "gcErrors", this.gcErrors);
        });
    }

    public synchronized void incrementErrors() {
        ++this.errorsCount;
    }

    public synchronized void incrementProfiling() {
        ++this.errorsCount;
        ++this.profilingCommandErrors;
    }

    public synchronized void incrementSdk(ProfileIonKeys.SDK_ERROR_TYPE errorType) {
        ++this.errorsCount;
        ++this.sdkClientErrors;
        switch (errorType) {
            case CONFIGURE_AGENT_ERRORS: {
                ++this.configureAgentErrors;
                break;
            }
            case CONFIGURE_AGENT_RNFE_AUTO_CREATE_ENABLED_ERRORS: {
                ++this.configureAgentErrors;
                ++this.configureAgentRnfeAutoCreateEnabledErrors;
                break;
            }
            case CREATE_PROFILING_GROUP_ERRORS: {
                ++this.createProfilingGroupErrors;
                break;
            }
            case POST_AGENT_PROFILE_ERRORS: {
                ++this.postAgentProfileErrors;
                break;
            }
            case POST_AGENT_PROFILE_RNFE_AUTO_CREATE_ENABLED_ERRORS: {
                ++this.postAgentProfileErrors;
                ++this.postAgentProfileRnfeAutoCreateEnabledErrors;
                break;
            }
        }
    }

    public synchronized void incrementFargate() {
        ++this.errorsCount;
        ++this.fargateErrors;
    }

    public synchronized void incrementGc() {
        ++this.errorsCount;
        ++this.gcErrors;
    }

    public void record(Logger logger, Level level, String message, Exception e) {
        logger.log(level, message, e);
        this.incrementErrors();
    }

    public void recordProfiling(Logger logger, Level level, String message, Exception e) {
        logger.log(level, message, e);
        this.incrementProfiling();
    }

    public void recordSdk(Logger logger, Level level, String message, Exception e, ProfileIonKeys.SDK_ERROR_TYPE errorType) {
        logger.log(level, message, e);
        this.incrementSdk(errorType);
    }

    public void recordFargate(Logger logger, Level level, String message) {
        logger.log(level, message);
        this.incrementFargate();
    }

    public void recordGc(Logger logger, Level level, String message, Exception e) {
        logger.log(level, message, e);
        this.incrementGc();
    }

    public synchronized int getErrorsCount() {
        return this.errorsCount;
    }

    public synchronized int getProfiling() {
        return this.profilingCommandErrors;
    }

    public synchronized int getSdk() {
        return this.sdkClientErrors;
    }

    public synchronized int getFargate() {
        return this.fargateErrors;
    }

    public synchronized int getGc() {
        return this.gcErrors;
    }
}

