/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent;

import com.amazonaws.services.lambda.runtime.Context;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.logging.Logger;
import lombok.Generated;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codeguruprofiler.model.ComputePlatform;
import software.amazon.codeguruprofilerjavaagent.CodeGuruProfilerSDKClientProvider;
import software.amazon.codeguruprofilerjavaagent.EnvironmentReader;
import software.amazon.codeguruprofilerjavaagent.IProfiler;
import software.amazon.codeguruprofilerjavaagent.PausableProfiler;
import software.amazon.codeguruprofilerjavaagent.Profiler;
import software.amazon.codeguruprofilerjavaagent.ProfilerFinalParameters;
import software.amazon.codeguruprofilerjavaagent.ProfilerParameters;
import software.amazon.codeguruprofilerjavaagent.ProfilingCommandAccessor;
import software.amazon.codeguruprofilerjavaagent.ProfilingCommandWithPause;
import software.amazon.codeguruprofilerjavaagent.ProfilingCommands;
import software.amazon.codeguruprofilerjavaagent.configuration.ProfilerParametersMerger;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.AgentMetadata;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.AgentMetadataProvider;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.ErrorsMetadata;

public class ProfilerWithPause
extends ProfilingCommandAccessor
implements IProfiler,
PausableProfiler {
    private static final Logger LOG = Logger.getLogger(ProfilerWithPause.class.getName());
    private final Profiler internalProfiler;

    ProfilerWithPause(ProfilerParameters parameters, ProfilerFinalParameters profilerFinalParameters) {
        this.internalProfiler = new Profiler(parameters, profilerFinalParameters);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void start() {
        this.startWithProfilingCommand((parametersMerger, parameters, profilerFinalParameters) -> this.createNewProfilingCommand((ProfilerParametersMerger)parametersMerger, (ProfilerParameters)parameters, (ProfilerFinalParameters)profilerFinalParameters));
    }

    @Override
    public void stop() {
        this.internalProfiler.stop();
    }

    @Override
    public boolean isRunning() {
        return this.internalProfiler.isRunning();
    }

    @Override
    public boolean isProfiling() {
        return this.internalProfiler.isProfiling();
    }

    @Override
    public void pause() {
        this.getProfilingCommand().ifPresent(command -> ((ProfilingCommandWithPause)command).pauseProfiling());
    }

    @Override
    public void resume(Context context) {
        Optional<ProfilingCommandWithPause> command = this.getProfilingCommand().map(c -> (ProfilingCommandWithPause)c);
        if (command.isPresent()) {
            command.get().resumeProfiling(context);
        } else {
            this.start();
        }
    }

    @Override
    Optional<ProfilingCommands> getProfilingCommand() {
        return this.internalProfiler.getProfilingCommand();
    }

    @Override
    boolean setProfilingCommand(ProfilingCommands expectedValue, ProfilingCommands UpdatedValue) {
        return this.internalProfiler.setProfilingCommand(expectedValue, UpdatedValue);
    }

    @Override
    ProfilingCommands createNewProfilingCommand(ProfilerParametersMerger parametersMerger, ProfilerParameters params, ProfilerFinalParameters finalParams) {
        return new ProfilingCommandWithPause(parametersMerger, params, finalParams);
    }

    @Override
    void startWithProfilingCommand(ProfilingCommandAccessor.TriFunction<ProfilerParametersMerger, ProfilerParameters, ProfilerFinalParameters, ProfilingCommands> profilingCommandProvider) {
        this.internalProfiler.startWithProfilingCommand(profilingCommandProvider);
    }

    @Override
    public boolean isSamplingPaused() {
        return this.getProfilingCommand().map(c -> ((ProfilingCommandWithPause)c).isSamplingPaused()).orElse(false);
    }

    public String toString() {
        return "LambdaProfiler{profilingMetadata=" + this.internalProfiler.toString() + '}';
    }

    public static class Builder {
        private final ProfilerParameters.ProfilerParametersBuilder parametersBuilder = ProfilerParameters.builder();
        private final ProfilerFinalParameters.ProfilerFinalParametersBuilder finalParametersBuilder = ProfilerFinalParameters.builder();
        private final CodeGuruProfilerSDKClientProvider.CodeGuruProfilerSDKClientProviderBuilder codeGuruClientBuilder;
        private final BiFunction<ProfilerParameters, ProfilerFinalParameters, ProfilerWithPause> constructor;
        private final ErrorsMetadata errorsMetadata = new ErrorsMetadata();
        private Context context;
        private EnvironmentReader environmentReader;
        private String lambdaInvokedFunctionArn;

        Builder() {
            this(CodeGuruProfilerSDKClientProvider.builder().computePlatform(ComputePlatform.AWS_LAMBDA.toString()), ProfilerWithPause::new);
            this.codeGuruClientBuilder.errorsMetadata(this.errorsMetadata);
            this.finalParametersBuilder.codeGuruClientBuilder(this.codeGuruClientBuilder).errorsMetadata(this.errorsMetadata);
        }

        public Builder awsCredentialsProvider(AwsCredentialsProvider awsCredentialsProvider) {
            this.codeGuruClientBuilder.awsCredentialsProvider(awsCredentialsProvider);
            return this;
        }

        public Builder awsRegionToReportTo(Region awsRegion) {
            this.codeGuruClientBuilder.awsRegion(awsRegion);
            return this;
        }

        public Builder profilingGroupName(String profilingGroupName) {
            this.parametersBuilder.profilingGroupName(profilingGroupName);
            this.codeGuruClientBuilder.profilingGroupName(profilingGroupName);
            return this;
        }

        public Builder integrationModeStandalone() {
            this.parametersBuilder.integrationMode("-standalone");
            return this;
        }

        public Builder withHeapSummary(boolean shouldEnableHeapSummary) {
            this.parametersBuilder.heapSummaryEnabled(shouldEnableHeapSummary);
            return this;
        }

        public String getProfilingGroupName() {
            return this.parametersBuilder.getProfilingGroupName();
        }

        public AwsCredentialsProvider getAwsCredentialProvider() {
            return this.codeGuruClientBuilder.getAwsCredentialsProvider();
        }

        public Region getAwsRegion() {
            return this.codeGuruClientBuilder.getAwsRegion();
        }

        public Builder lambdaInvokedFunctionArn(String lambdaInvokedFunctionArn) {
            this.lambdaInvokedFunctionArn = lambdaInvokedFunctionArn;
            return this;
        }

        public Builder context(Context context) {
            this.context = context;
            return this;
        }

        public Builder environmentReader(EnvironmentReader environmentReader) {
            this.environmentReader = environmentReader;
            return this;
        }

        public ProfilerWithPause build() {
            this.finalizeParameters();
            return this.constructor.apply(this.parametersBuilder.build(), this.finalParametersBuilder.build());
        }

        protected void finalizeParameters() {
            AgentMetadata agentMetadata = AgentMetadataProvider.buildLambdaAgentMetadata(this.context, this.lambdaInvokedFunctionArn, this.environmentReader, this.errorsMetadata, this.parametersBuilder.build().getIntegrationMode());
            this.parametersBuilder.addProfilerOverheadAsSamples(false);
            this.finalParametersBuilder.agentMetadata(agentMetadata);
        }

        @Generated
        Builder(CodeGuruProfilerSDKClientProvider.CodeGuruProfilerSDKClientProviderBuilder codeGuruClientBuilder, BiFunction<ProfilerParameters, ProfilerFinalParameters, ProfilerWithPause> constructor) {
            this.codeGuruClientBuilder = codeGuruClientBuilder;
            this.constructor = constructor;
        }
    }
}

