/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent;

import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import software.amazon.codeguruprofilerjavaagent.KillSwitch;
import software.amazon.codeguruprofilerjavaagent.MemoryProfilerParameters;
import software.amazon.codeguruprofilerjavaagent.ProfilerFinalParameters;
import software.amazon.codeguruprofilerjavaagent.ProfilerParameters;
import software.amazon.codeguruprofilerjavaagent.ProfilingCommands;
import software.amazon.codeguruprofilerjavaagent.Timer;
import software.amazon.codeguruprofilerjavaagent.flightrecorder.AllocationEventProcessor;
import software.amazon.codeguruprofilerjavaagent.flightrecorder.EventProcessor;
import software.amazon.codeguruprofilerjavaagent.flightrecorder.MemoryProfiler;
import software.amazon.codeguruprofilerjavaagent.flightrecorder.ObjectCountEventProcessor;

abstract class ProfilingCommandExecutor
implements ProfilingCommands {
    private static final Logger LOG = Logger.getLogger(ProfilingCommandExecutor.class.getName());
    protected ScheduledExecutorService executor;
    protected ScheduledFuture<?> futureSampleTask;
    protected boolean isTerminated = false;
    protected final Lock lock = new ReentrantLock();
    protected final Timer overheadTimer = new Timer();
    protected final KillSwitch killSwitch = new KillSwitch();
    protected final MemoryProfiler memoryProfiler;

    public ProfilingCommandExecutor(MemoryProfilerParameters memoryProfilerParameters) {
        this.memoryProfiler = this.buildMemoryProfiler(memoryProfilerParameters);
    }

    @Override
    public void run() {
        this.overheadTimer.time(this::startSampling, Timer.ProfilingTimes.runProfiler);
    }

    @Override
    public void scheduleProfiling() {
        this.lock.lock();
        try {
            if (this.isTerminated) {
                LOG.info("ProfilingCommand cannot be started again, create another instance instead");
                return;
            }
            if (this.isProfilingDisabled()) {
                return;
            }
            this.setProfilingScheduledExecutor();
            Duration samplingInterval = this.getParameters().getSamplingInterval();
            this.scheduleTaskInExecutor(samplingInterval, samplingInterval);
            LOG.info("Profiling scheduled, sampling rate is " + samplingInterval);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void setProfilingScheduledExecutor() {
        this.lock.lock();
        try {
            if (this.executor == null) {
                this.executor = Executors.newSingleThreadScheduledExecutor(r -> {
                    Thread thread = new Thread(r, "Amazon-Profiler");
                    thread.setDaemon(true);
                    thread.interrupt();
                    return thread;
                });
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void stopProfiling() {
        this.lock.lock();
        try {
            this.isTerminated = true;
            if (this.executor != null) {
                this.executor.shutdown();
                this.executor.awaitTermination(2L, TimeUnit.SECONDS);
                this.futureSampleTask = null;
                this.executor = null;
            }
            this.overheadTimer.time(() -> this.performFlush(true), Timer.ProfilingTimes.flush);
            this.memoryProfiler.stopRecording();
        }
        catch (InterruptedException e) {
            LOG.log(Level.INFO, "InterruptedException received while waiting for executor to terminate.");
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public CompletableFuture<Void> asyncStopProfiling() {
        this.lock.lock();
        try {
            this.isTerminated = true;
        }
        finally {
            this.lock.unlock();
        }
        return CompletableFuture.runAsync(this::stopProfiling);
    }

    @Override
    public boolean isProfilingScheduled() {
        this.lock.lock();
        try {
            boolean bl = this.executor != null && !this.isTerminated;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected final void scheduleTaskInExecutor(Duration initialDelay, Duration delay) {
        this.lock.lock();
        try {
            if (this.isTerminated || this.executor == null) {
                return;
            }
            this.cancelTaskInExecutor();
            this.futureSampleTask = this.executor.scheduleWithFixedDelay(this, initialDelay.toNanos(), delay.toNanos(), TimeUnit.NANOSECONDS);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected final void cancelTaskInExecutor() {
        this.lock.lock();
        try {
            if (this.futureSampleTask != null) {
                this.futureSampleTask.cancel(false);
                this.futureSampleTask = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected final void waitAndCancelTaskInExecutor(long waitTimeInMs) {
        if (this.futureSampleTask != null) {
            try {
                this.futureSampleTask.get(waitTimeInMs, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new RuntimeException("Exception received while waiting for task to complete.", e);
            }
            finally {
                this.cancelTaskInExecutor();
            }
        }
    }

    private MemoryProfiler buildMemoryProfiler(MemoryProfilerParameters parameters) {
        boolean isEnabled = parameters.getAllocationProfilingEnabled() || parameters.getHeapSummaryEnabled();
        ArrayList<EventProcessor> eventProcessors = new ArrayList<EventProcessor>();
        if (parameters.getHeapSummaryEnabled()) {
            eventProcessors.add(new ObjectCountEventProcessor());
        }
        if (parameters.getAllocationProfilingEnabled()) {
            eventProcessors.add(new AllocationEventProcessor());
        }
        return new MemoryProfiler(isEnabled, eventProcessors);
    }

    private boolean isProfilingDisabled() {
        if (this.killSwitch.isKillSwitchOn(true)) {
            LOG.info("Disabling the profiler as the kill switch file has been found");
            return true;
        }
        return false;
    }

    protected void flush(boolean memoryRefresh) {
        this.lock.lock();
        try {
            if (this.isTerminated) {
                LOG.info("Skipping flush as profiler is terminated");
                return;
            }
            this.performFlush(memoryRefresh);
        }
        finally {
            this.lock.unlock();
        }
    }

    abstract void performFlush(boolean var1);

    abstract ProfilerParameters getParameters();

    abstract ProfilerFinalParameters getFinalParameters();
}

