/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent.profile;

import com.amazon.ion.IonSystem;
import com.amazon.ion.IonType;
import com.amazon.ion.IonWriter;
import com.amazon.ion.SymbolTable;
import com.amazon.ion.SymbolToken;
import com.amazon.ion.UnknownSymbolException;
import com.amazon.ion.system.IonBinaryWriterBuilder;
import com.amazon.ion.system.IonSystemBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.codeguruprofilerjavaagent.profile.CallGraph;
import software.amazon.codeguruprofilerjavaagent.profile.ClassSummary;
import software.amazon.codeguruprofilerjavaagent.profile.HeapSnapshot;
import software.amazon.codeguruprofilerjavaagent.profile.HeapSummary;
import software.amazon.codeguruprofilerjavaagent.profile.IonUtils;
import software.amazon.codeguruprofilerjavaagent.profile.Profile;
import software.amazon.codeguruprofilerjavaagent.profile.StateEncodings;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.AgentMetadataIonWriter;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u0000 !2\u00020\u0001:\u0003 !\"B\u0005\u00a2\u0006\u0002\u0010\u0002J1\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\u000eH\u0004\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0019H\u0004JQ\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\b2\u000e\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0016\u00a2\u0006\u0002\u0010\u001fR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileIonSerializer;", "", "()V", "system", "Lcom/amazon/ion/IonSystem;", "kotlin.jvm.PlatformType", "encodeSymbols", "", "Lcom/amazon/ion/SymbolToken;", "encodings", "", "", "", "symbolTable", "Lcom/amazon/ion/SymbolTable;", "(Ljava/util/Map;Lcom/amazon/ion/SymbolTable;)[Lcom/amazon/ion/SymbolToken;", "serialize", "", "profile", "Lsoftware/amazon/codeguruprofilerjavaagent/profile/Profile;", "out", "Ljava/io/OutputStream;", "writeHeapSummary", "heapSummary", "Lsoftware/amazon/codeguruprofilerjavaagent/profile/HeapSummary;", "Lcom/amazon/ion/IonWriter;", "writeProfile", "countsSymbol", "childrensToken", "stateMapping", "frameMapping", "(Lsoftware/amazon/codeguruprofilerjavaagent/profile/Profile;Lcom/amazon/ion/IonWriter;Lcom/amazon/ion/SymbolToken;Lcom/amazon/ion/SymbolToken;[Lcom/amazon/ion/SymbolToken;Ljava/util/Map;)V", "CallGraphSerializer", "Companion", "SymbolTokenWithoutText", "SkySailJavaAgent"})
@SourceDebugExtension(value={"SMAP\nProfileIonSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfileIonSerializer.kt\nsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileIonSerializer\n+ 2 IonUtils.kt\nsoftware/amazon/codeguruprofilerjavaagent/profile/IonUtils\n*L\n1#1,254:1\n91#2,4:255\n91#2,2:259\n98#2,8:261\n91#2,2:269\n76#2,2:271\n91#2,4:273\n78#2:277\n76#2,2:278\n91#2,2:280\n76#2,2:282\n91#2,4:284\n78#2:288\n93#2,2:289\n78#2:291\n93#2,2:292\n106#2,2:294\n100#2:296\n93#2,2:297\n*S KotlinDebug\n*F\n+ 1 ProfileIonSerializer.kt\nsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileIonSerializer\n*L\n78#1:255,4\n117#1:259,2\n118#1:261,8\n123#1:269,2\n128#1:271,2\n128#1:273,4\n128#1:277\n132#1:278,2\n132#1:280,2\n134#1:282,2\n134#1:284,4\n134#1:288\n132#1:289,2\n132#1:291\n123#1:292,2\n118#1:294,2\n118#1:296\n117#1:297,2\n*E\n"})
public class ProfileIonSerializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final IonSystem system = IonSystemBuilder.standard().build();
    @JvmField
    @NotNull
    public static final BigDecimal CURRENT_SCHEMA_VERSION;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(@NotNull Profile profile, @NotNull OutputStream out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        SymbolTable symbolTable = this.system.newLocalSymbolTable(new SymbolTable[0]);
        Intrinsics.checkNotNullExpressionValue((Object)symbolTable, (String)"system.newLocalSymbolTable()");
        SymbolTable symbols = symbolTable;
        SymbolToken symbolToken = symbols.intern("counts");
        Intrinsics.checkNotNullExpressionValue((Object)symbolToken, (String)"symbols.intern(ProfileIonKeys.COUNTS)");
        SymbolToken countsSymbol = symbolToken;
        SymbolToken symbolToken2 = symbols.intern("children");
        Intrinsics.checkNotNullExpressionValue((Object)symbolToken2, (String)"symbols.intern(ProfileIonKeys.CHILDREN)");
        SymbolToken childrensToken = symbolToken2;
        Map<Integer, String> map = StateEncodings.getEncodings();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getEncodings()");
        SymbolToken[] stateMapping = this.encodeSymbols(map, symbols);
        IonWriter ionWriter = IonBinaryWriterBuilder.standard().withInitialSymbolTable(symbols).build(out);
        Intrinsics.checkNotNullExpressionValue((Object)ionWriter, (String)"standard().withInitialSy\u2026Table(symbols).build(out)");
        IonWriter writer = ionWriter;
        Closeable closeable = (Closeable)writer;
        Throwable throwable = null;
        try {
            IonWriter it = (IonWriter)closeable;
            boolean bl = false;
            Map<Integer, String> map2 = profile.getFrameEncodings().getEncodings();
            Intrinsics.checkNotNullExpressionValue(map2, (String)"profile.frameEncodings.encodings");
            this.writeProfile(profile, it, countsSymbol, childrensToken, stateMapping, map2);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    protected final SymbolToken[] encodeSymbols(@NotNull Map<Integer, String> encodings, @NotNull SymbolTable symbolTable) {
        Intrinsics.checkNotNullParameter(encodings, (String)"encodings");
        Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        SymbolToken[] remapping = new SymbolToken[encodings.size()];
        int n = encodings.size();
        for (int i = 0; i < n; ++i) {
            remapping[i] = new SymbolTokenWithoutText(symbolTable.intern(encodings.get(i)).getSid());
        }
        return remapping;
    }

    public void writeProfile(@NotNull Profile profile, @NotNull IonWriter out, @NotNull SymbolToken countsSymbol, @NotNull SymbolToken childrensToken, @NotNull SymbolToken[] stateMapping, @NotNull Map<Integer, String> frameMapping) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)countsSymbol, (String)"countsSymbol");
        Intrinsics.checkNotNullParameter((Object)childrensToken, (String)"childrensToken");
        Intrinsics.checkNotNullParameter((Object)stateMapping, (String)"stateMapping");
        Intrinsics.checkNotNullParameter(frameMapping, (String)"frameMapping");
        IonUtils this_$iv = IonUtils.INSTANCE;
        boolean $i$f$writeStruct = false;
        out.stepIn(IonType.STRUCT);
        boolean bl = false;
        IonUtils.writeDecimal(out, "schemaVersion", CURRENT_SCHEMA_VERSION);
        IonUtils.writeTimestamp(out, "start", profile.getStart());
        IonUtils.writeTimestamp(out, "end", profile.getEnd());
        out.setFieldName("callgraph");
        CallGraph callGraph = profile.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)callGraph, (String)"profile.root");
        CallGraphSerializer.INSTANCE.write(out, callGraph, countsSymbol, childrensToken, stateMapping, frameMapping);
        out.setFieldName("heapSummary");
        HeapSummary heapSummary = profile.getHeapSummary();
        Intrinsics.checkNotNullExpressionValue((Object)heapSummary, (String)"profile.heapSummary");
        this.writeHeapSummary(heapSummary, out);
        out.setFieldName("agentMetadata");
        AgentMetadataIonWriter.write(out, profile.getAgentMetadata(), profile.getSamplingMetadata());
        profile.getAgentDebugInfo().write(out, "debugInfo");
        out.stepOut();
    }

    /*
     * WARNING - void declaration
     */
    protected final void writeHeapSummary(@NotNull HeapSummary heapSummary, @NotNull IonWriter out) {
        Intrinsics.checkNotNullParameter((Object)heapSummary, (String)"heapSummary");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        HeapSnapshot latestSnapshot = heapSummary.getLatestSnapshot();
        IonUtils this_$iv = IonUtils.INSTANCE;
        boolean $i$f$writeStruct = false;
        out.stepIn(IonType.STRUCT);
        boolean bl = false;
        String fieldName$iv = "snapshots";
        boolean $i$f$writeList = false;
        out.setFieldName(fieldName$iv);
        boolean $i$f$writeList2 = false;
        out.stepIn(IonType.LIST);
        boolean bl2 = false;
        if (latestSnapshot != null && latestSnapshot.getHeapUsedBytes() != null) {
            IonUtils this_$iv2;
            IonUtils this_$iv3 = IonUtils.INSTANCE;
            boolean $i$f$writeStruct2 = false;
            out.stepIn(IonType.STRUCT);
            boolean bl3 = false;
            IonUtils.writeTimestamp(out, "captureTime", latestSnapshot.getCaptureTimestamp());
            IonUtils.writeInt(out, "uptimeMillis", latestSnapshot.getUptimeMillis());
            Long l = latestSnapshot.getHeapUsedBytes();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"latestSnapshot.heapUsedBytes");
            IonUtils.writeInt(out, "heapUsedBytes", ((Number)l).longValue());
            IonUtils ionUtils = IonUtils.INSTANCE;
            String fieldName$iv2 = "settings";
            boolean $i$f$writeStruct3 = false;
            out.setFieldName(fieldName$iv2);
            IonUtils this_$iv$iv = this_$iv2;
            boolean $i$f$writeStruct4 = false;
            out.stepIn(IonType.STRUCT);
            boolean bl4 = false;
            Long l2 = latestSnapshot.getSettings().getMaxHeapSizeBytes();
            Intrinsics.checkNotNullExpressionValue((Object)l2, (String)"latestSnapshot.settings.maxHeapSizeBytes");
            IonUtils.writeInt(out, "maxHeapSizeBytes", ((Number)l2).longValue());
            out.stepOut();
            this_$iv2 = IonUtils.INSTANCE;
            fieldName$iv2 = "classSummaries";
            $i$f$writeStruct3 = false;
            out.setFieldName(fieldName$iv2);
            this_$iv$iv = this_$iv2;
            $i$f$writeStruct4 = false;
            out.stepIn(IonType.STRUCT);
            boolean bl5 = false;
            for (ClassSummary classSummary : latestSnapshot.getClassSummaries()) {
                void this_$iv4;
                IonUtils ionUtils2 = IonUtils.INSTANCE;
                String fieldName$iv3 = classSummary.getObjectType();
                boolean $i$f$writeStruct5 = false;
                out.setFieldName(fieldName$iv3);
                void this_$iv$iv2 = this_$iv4;
                boolean $i$f$writeStruct6 = false;
                out.stepIn(IonType.STRUCT);
                boolean bl6 = false;
                IonUtils.writeInt(out, "sizeBytes", classSummary.getObjectSizeBytes());
                IonUtils.writeInt(out, "count", classSummary.getObjectCount());
                out.stepOut();
            }
            out.stepOut();
            out.stepOut();
        }
        out.stepOut();
        out.stepOut();
    }

    static {
        BigDecimal bigDecimal = BigDecimal.valueOf(1.0);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(1.0)");
        CURRENT_SCHEMA_VERSION = bigDecimal;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0002\b\u0003\b\u00c4\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JO\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u00a2\u0006\u0002\u0010\u0012J5\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\rH\u0002\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileIonSerializer$CallGraphSerializer;", "", "()V", "write", "", "out", "Lcom/amazon/ion/IonWriter;", "root", "Lsoftware/amazon/codeguruprofilerjavaagent/profile/CallGraph;", "countsSymbol", "Lcom/amazon/ion/SymbolToken;", "childrensToken", "stateMapping", "", "frameMapping", "", "", "", "(Lcom/amazon/ion/IonWriter;Lsoftware/amazon/codeguruprofilerjavaagent/profile/CallGraph;Lcom/amazon/ion/SymbolToken;Lcom/amazon/ion/SymbolToken;[Lcom/amazon/ion/SymbolToken;Ljava/util/Map;)V", "writeCounts", "counts", "", "(Lcom/amazon/ion/IonWriter;[JLcom/amazon/ion/SymbolToken;[Lcom/amazon/ion/SymbolToken;)V", "Operation", "SkySailJavaAgent"})
    @SourceDebugExtension(value={"SMAP\nProfileIonSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfileIonSerializer.kt\nsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileIonSerializer$CallGraphSerializer\n+ 2 IonUtils.kt\nsoftware/amazon/codeguruprofilerjavaagent/profile/IonUtils\n*L\n1#1,254:1\n91#2,4:255\n*S KotlinDebug\n*F\n+ 1 ProfileIonSerializer.kt\nsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileIonSerializer$CallGraphSerializer\n*L\n243#1:255,4\n*E\n"})
    protected static final class CallGraphSerializer {
        @NotNull
        public static final CallGraphSerializer INSTANCE = new CallGraphSerializer();

        private CallGraphSerializer() {
        }

        public final void write(@NotNull IonWriter out, @NotNull CallGraph root, @NotNull SymbolToken countsSymbol, @NotNull SymbolToken childrensToken, @NotNull SymbolToken[] stateMapping, @NotNull Map<Integer, String> frameMapping) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)countsSymbol, (String)"countsSymbol");
            Intrinsics.checkNotNullParameter((Object)childrensToken, (String)"childrensToken");
            Intrinsics.checkNotNullParameter((Object)stateMapping, (String)"stateMapping");
            Intrinsics.checkNotNullParameter(frameMapping, (String)"frameMapping");
            ArrayDeque<Operation> operations = new ArrayDeque<Operation>();
            operations.addFirst(new Operation.StartNode(root, true));
            operations.addLast(Operation.CloseNode.INSTANCE);
            while (!((Collection)operations).isEmpty()) {
                Operation current = (Operation)operations.removeFirst();
                if (current instanceof Operation.StartNode) {
                    CallGraph node = ((Operation.StartNode)current).getNode();
                    if (!((Operation.StartNode)current).isRoot()) {
                        out.setFieldName(frameMapping.get(node.getFrame()));
                    }
                    out.stepIn(IonType.STRUCT);
                    long[] lArray = node.getCounts();
                    Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"node.counts");
                    this.writeCounts(out, lArray, countsSymbol, stateMapping);
                    CallGraph[] callGraphArray = node.getChildren();
                    Intrinsics.checkNotNullExpressionValue((Object)callGraphArray, (String)"node.children");
                    if (!(!(((Object[])callGraphArray).length == 0))) continue;
                    operations.addFirst(Operation.CloseChildren.INSTANCE);
                    Intrinsics.checkNotNullExpressionValue((Object)node.getChildren(), (String)"node.children");
                    for (int i = ArraysKt.getLastIndex((Object[])(v9572)); -1 < i; --i) {
                        CallGraph child = node.getChildren()[i];
                        if (!child.hasCounts()) continue;
                        operations.addFirst(Operation.CloseNode.INSTANCE);
                        Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
                        operations.addFirst(new Operation.StartNode(child, false, 2, null));
                    }
                    operations.addFirst(Operation.StartChildren.INSTANCE);
                    continue;
                }
                if (current instanceof Operation.StartChildren) {
                    out.setFieldNameSymbol(childrensToken);
                    out.stepIn(IonType.STRUCT);
                    continue;
                }
                if (current instanceof Operation.CloseChildren) {
                    out.stepOut();
                    continue;
                }
                if (!(current instanceof Operation.CloseNode)) continue;
                out.stepOut();
            }
        }

        private final void writeCounts(IonWriter out, long[] counts, SymbolToken countsSymbol, SymbolToken[] stateMapping) {
            if (counts.length == 0) {
                return;
            }
            out.setFieldNameSymbol(countsSymbol);
            IonUtils this_$iv = IonUtils.INSTANCE;
            boolean $i$f$writeStruct = false;
            out.stepIn(IonType.STRUCT);
            boolean bl = false;
            int n = counts.length;
            for (int i = 0; i < n; ++i) {
                if (counts[i] <= 0L) continue;
                out.setFieldNameSymbol(stateMapping[i]);
                out.writeInt(counts[i]);
            }
            out.stepOut();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0004\u0007\b\t\n\u00a8\u0006\u000b"}, d2={"Lsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileIonSerializer$CallGraphSerializer$Operation;", "", "()V", "CloseChildren", "CloseNode", "StartChildren", "StartNode", "Lsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileIonSerializer$CallGraphSerializer$Operation$CloseChildren;", "Lsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileIonSerializer$CallGraphSerializer$Operation$CloseNode;", "Lsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileIonSerializer$CallGraphSerializer$Operation$StartChildren;", "Lsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileIonSerializer$CallGraphSerializer$Operation$StartNode;", "SkySailJavaAgent"})
        public static abstract class Operation {
            private Operation() {
            }

            public /* synthetic */ Operation(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileIonSerializer$CallGraphSerializer$Operation$CloseChildren;", "Lsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileIonSerializer$CallGraphSerializer$Operation;", "()V", "SkySailJavaAgent"})
            public static final class CloseChildren
            extends Operation {
                @NotNull
                public static final CloseChildren INSTANCE = new CloseChildren();

                private CloseChildren() {
                    super(null);
                }
            }

            @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileIonSerializer$CallGraphSerializer$Operation$CloseNode;", "Lsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileIonSerializer$CallGraphSerializer$Operation;", "()V", "SkySailJavaAgent"})
            public static final class CloseNode
            extends Operation {
                @NotNull
                public static final CloseNode INSTANCE = new CloseNode();

                private CloseNode() {
                    super(null);
                }
            }

            @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileIonSerializer$CallGraphSerializer$Operation$StartChildren;", "Lsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileIonSerializer$CallGraphSerializer$Operation;", "()V", "SkySailJavaAgent"})
            public static final class StartChildren
            extends Operation {
                @NotNull
                public static final StartChildren INSTANCE = new StartChildren();

                private StartChildren() {
                    super(null);
                }
            }

            @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileIonSerializer$CallGraphSerializer$Operation$StartNode;", "Lsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileIonSerializer$CallGraphSerializer$Operation;", "node", "Lsoftware/amazon/codeguruprofilerjavaagent/profile/CallGraph;", "isRoot", "", "(Lsoftware/amazon/codeguruprofilerjavaagent/profile/CallGraph;Z)V", "()Z", "getNode", "()Lsoftware/amazon/codeguruprofilerjavaagent/profile/CallGraph;", "SkySailJavaAgent"})
            public static final class StartNode
            extends Operation {
                @NotNull
                private final CallGraph node;
                private final boolean isRoot;

                public StartNode(@NotNull CallGraph node, boolean isRoot) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    super(null);
                    this.node = node;
                    this.isRoot = isRoot;
                }

                public /* synthetic */ StartNode(CallGraph callGraph, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
                    if ((n & 2) != 0) {
                        bl = false;
                    }
                    this(callGraph, bl);
                }

                @NotNull
                public final CallGraph getNode() {
                    return this.node;
                }

                public final boolean isRoot() {
                    return this.isRoot;
                }
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileIonSerializer$Companion;", "", "()V", "CURRENT_SCHEMA_VERSION", "Ljava/math/BigDecimal;", "SkySailJavaAgent"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0003H\u0016J\n\u0010\b\u001a\u0004\u0018\u00010\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileIonSerializer$SymbolTokenWithoutText;", "Lcom/amazon/ion/SymbolToken;", "sid", "", "(I)V", "assumeText", "", "getSid", "getText", "SkySailJavaAgent"})
    protected static final class SymbolTokenWithoutText
    implements SymbolToken {
        private final int sid;

        public SymbolTokenWithoutText(int sid) {
            this.sid = sid;
        }

        @Nullable
        public Void getText() {
            return null;
        }

        @NotNull
        public Void assumeText() {
            throw new UnknownSymbolException(this.sid);
        }

        public int getSid() {
            return this.sid;
        }
    }
}

