/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.validation.internal;

import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyResponseEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayV2HTTPEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayV2HTTPResponse;
import com.amazonaws.services.lambda.runtime.events.APIGatewayV2WebSocketResponse;
import com.amazonaws.services.lambda.runtime.events.ActiveMQEvent;
import com.amazonaws.services.lambda.runtime.events.ApplicationLoadBalancerRequestEvent;
import com.amazonaws.services.lambda.runtime.events.ApplicationLoadBalancerResponseEvent;
import com.amazonaws.services.lambda.runtime.events.CloudFormationCustomResourceEvent;
import com.amazonaws.services.lambda.runtime.events.CloudWatchLogsEvent;
import com.amazonaws.services.lambda.runtime.events.KafkaEvent;
import com.amazonaws.services.lambda.runtime.events.KinesisAnalyticsFirehoseInputPreprocessingEvent;
import com.amazonaws.services.lambda.runtime.events.KinesisAnalyticsInputPreprocessingResponse;
import com.amazonaws.services.lambda.runtime.events.KinesisAnalyticsStreamsInputPreprocessingEvent;
import com.amazonaws.services.lambda.runtime.events.KinesisEvent;
import com.amazonaws.services.lambda.runtime.events.KinesisFirehoseEvent;
import com.amazonaws.services.lambda.runtime.events.RabbitMQEvent;
import com.amazonaws.services.lambda.runtime.events.SNSEvent;
import com.amazonaws.services.lambda.runtime.events.SQSBatchResponse;
import com.amazonaws.services.lambda.runtime.events.SQSEvent;
import com.amazonaws.services.lambda.runtime.events.ScheduledEvent;
import com.amazonaws.services.lambda.runtime.events.StreamsEventResponse;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.SpecVersion;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.lambda.powertools.common.internal.LambdaHandlerProcessor;
import software.amazon.lambda.powertools.utilities.jmespath.Base64Function;
import software.amazon.lambda.powertools.utilities.jmespath.Base64GZipFunction;
import software.amazon.lambda.powertools.validation.Validation;
import software.amazon.lambda.powertools.validation.ValidationConfig;
import software.amazon.lambda.powertools.validation.ValidationException;
import software.amazon.lambda.powertools.validation.ValidationUtils;

@Aspect
public class ValidationAspect {
    private static final Logger LOG = LoggerFactory.getLogger(ValidationAspect.class);
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ ValidationAspect ajc$perSingletonInstance;

    static {
        try {
            ValidationAspect.ajc$perSingletonInstance = new ValidationAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    @Pointcut(value="@annotation(validation)")
    public /* synthetic */ void callAt(Validation validation) {
    }

    @Around(value="callAt(validation) && execution(@Validation * *.*(..))", argNames="pjp,validation")
    public Object around(ProceedingJoinPoint pjp, Validation validation) throws Throwable {
        Object[] proceedArgs = pjp.getArgs();
        boolean validationNeeded = false;
        if (validation.schemaVersion() != SpecVersion.VersionFlag.V201909) {
            ValidationConfig.get().setSchemaVersion(validation.schemaVersion());
        }
        APIGatewayProxyResponseEvent validationResult = null;
        boolean failFast = false;
        if (LambdaHandlerProcessor.placedOnRequestHandler((ProceedingJoinPoint)pjp)) {
            validationNeeded = true;
            if (!validation.inboundSchema().isEmpty()) {
                APIGatewayProxyRequestEvent event;
                JsonSchema inboundJsonSchema = ValidationUtils.getJsonSchema(validation.inboundSchema(), true);
                Object obj = pjp.getArgs()[0];
                if (validation.envelope() != null && !validation.envelope().isEmpty()) {
                    ValidationUtils.validate(obj, inboundJsonSchema, validation.envelope());
                } else if (obj instanceof APIGatewayProxyRequestEvent) {
                    event = (APIGatewayProxyRequestEvent)obj;
                    validationResult = this.validateAPIGatewayProxyBody(event.getBody(), inboundJsonSchema, null, null);
                    failFast = true;
                } else if (obj instanceof APIGatewayV2HTTPEvent) {
                    event = (APIGatewayV2HTTPEvent)obj;
                    validationResult = this.validateAPIGatewayV2HTTPBody(event.getBody(), inboundJsonSchema, null, null);
                    failFast = true;
                } else if (obj instanceof SNSEvent) {
                    event = (SNSEvent)obj;
                    event.getRecords().forEach(snsRecord -> ValidationUtils.validate(snsRecord.getSNS().getMessage(), inboundJsonSchema));
                } else if (obj instanceof SQSEvent) {
                    event = (SQSEvent)obj;
                    validationResult = this.validateSQSEventMessages(event.getRecords(), inboundJsonSchema);
                } else if (obj instanceof ScheduledEvent) {
                    event = (ScheduledEvent)obj;
                    ValidationUtils.validate((Map<String, Object>)event.getDetail(), inboundJsonSchema);
                } else if (obj instanceof ApplicationLoadBalancerRequestEvent) {
                    event = (ApplicationLoadBalancerRequestEvent)obj;
                    ValidationUtils.validate(event.getBody(), inboundJsonSchema);
                } else if (obj instanceof CloudWatchLogsEvent) {
                    event = (CloudWatchLogsEvent)obj;
                    ValidationUtils.validate(Base64GZipFunction.decompress((byte[])Base64Function.decode((byte[])event.getAwsLogs().getData().getBytes(StandardCharsets.UTF_8))), inboundJsonSchema);
                } else if (obj instanceof CloudFormationCustomResourceEvent) {
                    event = (CloudFormationCustomResourceEvent)obj;
                    ValidationUtils.validate((Map<String, Object>)event.getResourceProperties(), inboundJsonSchema);
                } else if (obj instanceof KinesisEvent) {
                    event = (KinesisEvent)obj;
                    validationResult = this.validateKinesisEventRecords(event.getRecords(), inboundJsonSchema);
                } else if (obj instanceof KinesisFirehoseEvent) {
                    event = (KinesisFirehoseEvent)obj;
                    event.getRecords().forEach(eventRecord -> ValidationUtils.validate(Base64Function.decode((ByteBuffer)eventRecord.getData()), inboundJsonSchema));
                } else if (obj instanceof KafkaEvent) {
                    event = (KafkaEvent)obj;
                    event.getRecords().forEach((s, records) -> records.forEach(eventRecord -> ValidationUtils.validate(Base64Function.decode((String)eventRecord.getValue()), inboundJsonSchema)));
                } else if (obj instanceof ActiveMQEvent) {
                    event = (ActiveMQEvent)obj;
                    event.getMessages().forEach(message -> ValidationUtils.validate(Base64Function.decode((String)message.getData()), inboundJsonSchema));
                } else if (obj instanceof RabbitMQEvent) {
                    event = (RabbitMQEvent)obj;
                    event.getRmqMessagesByQueue().forEach((s, records) -> records.forEach(message -> ValidationUtils.validate(Base64Function.decode((String)message.getData()), inboundJsonSchema)));
                } else if (obj instanceof KinesisAnalyticsFirehoseInputPreprocessingEvent) {
                    event = (KinesisAnalyticsFirehoseInputPreprocessingEvent)obj;
                    event.getRecords().forEach(eventRecord -> ValidationUtils.validate(Base64Function.decode((ByteBuffer)eventRecord.getData()), inboundJsonSchema));
                } else if (obj instanceof KinesisAnalyticsStreamsInputPreprocessingEvent) {
                    event = (KinesisAnalyticsStreamsInputPreprocessingEvent)obj;
                    event.getRecords().forEach(eventRecord -> ValidationUtils.validate(Base64Function.decode((ByteBuffer)eventRecord.getData()), inboundJsonSchema));
                } else {
                    LOG.warn("Unhandled event type {}, please use the 'envelope' parameter to specify what to validate", (Object)obj.getClass().getName());
                }
            }
        }
        if (failFast && validationResult != null) {
            LOG.error("Incoming API event's body failed inbound schema validation.");
            return validationResult;
        }
        Object result = pjp.proceed(proceedArgs);
        if (validationResult != null && result != null) {
            SQSBatchResponse response;
            SQSBatchResponse validationResponse;
            if (result instanceof SQSBatchResponse && validationResult instanceof SQSBatchResponse) {
                validationResponse = (SQSBatchResponse)validationResult;
                response = (SQSBatchResponse)result;
                if (response.getBatchItemFailures() == null) {
                    response.setBatchItemFailures(validationResponse.getBatchItemFailures());
                } else {
                    response.getBatchItemFailures().addAll(validationResponse.getBatchItemFailures());
                }
            } else if (result instanceof StreamsEventResponse && validationResult instanceof StreamsEventResponse) {
                validationResponse = (StreamsEventResponse)validationResult;
                response = (StreamsEventResponse)result;
                if (response.getBatchItemFailures() == null) {
                    response.setBatchItemFailures(validationResponse.getBatchItemFailures());
                } else {
                    response.getBatchItemFailures().addAll(validationResponse.getBatchItemFailures());
                }
            }
        }
        if (result != null && validationNeeded && !validation.outboundSchema().isEmpty()) {
            JsonSchema outboundJsonSchema = ValidationUtils.getJsonSchema(validation.outboundSchema(), true);
            APIGatewayProxyResponseEvent overridenResponse = null;
            if (result instanceof APIGatewayProxyResponseEvent) {
                APIGatewayProxyResponseEvent response = (APIGatewayProxyResponseEvent)result;
                overridenResponse = this.validateAPIGatewayProxyBody(response.getBody(), outboundJsonSchema, response.getHeaders(), response.getMultiValueHeaders());
            } else if (result instanceof APIGatewayV2HTTPResponse) {
                APIGatewayV2HTTPResponse response = (APIGatewayV2HTTPResponse)result;
                overridenResponse = this.validateAPIGatewayV2HTTPBody(response.getBody(), outboundJsonSchema, response.getHeaders(), response.getMultiValueHeaders());
            } else if (result instanceof APIGatewayV2WebSocketResponse) {
                APIGatewayV2WebSocketResponse response = (APIGatewayV2WebSocketResponse)result;
                ValidationUtils.validate(response.getBody(), outboundJsonSchema);
            } else if (result instanceof ApplicationLoadBalancerResponseEvent) {
                ApplicationLoadBalancerResponseEvent response = (ApplicationLoadBalancerResponseEvent)result;
                ValidationUtils.validate(response.getBody(), outboundJsonSchema);
            } else if (result instanceof KinesisAnalyticsInputPreprocessingResponse) {
                KinesisAnalyticsInputPreprocessingResponse response = (KinesisAnalyticsInputPreprocessingResponse)result;
                response.getRecords().forEach(record -> ValidationUtils.validate(Base64Function.decode((ByteBuffer)record.getData()), outboundJsonSchema));
            } else {
                LOG.warn("Unhandled response type {}, please use the 'envelope' parameter to specify what to validate", (Object)result.getClass().getName());
            }
            if (overridenResponse != null) {
                result = overridenResponse;
                LOG.error("API response failed outbound schema validation.");
            }
        }
        return result;
    }

    private StreamsEventResponse validateKinesisEventRecords(List<KinesisEvent.KinesisEventRecord> records, JsonSchema inboundJsonSchema) {
        StreamsEventResponse response = StreamsEventResponse.builder().withBatchItemFailures(new ArrayList()).build();
        ListIterator<KinesisEvent.KinesisEventRecord> listIterator = records.listIterator();
        while (listIterator.hasNext()) {
            KinesisEvent.KinesisEventRecord eventRecord = listIterator.next();
            try {
                ValidationUtils.validate(Base64Function.decode((ByteBuffer)eventRecord.getKinesis().getData()), inboundJsonSchema);
            }
            catch (ValidationException e) {
                LOG.error("Validation error on message {}: {}", (Object)eventRecord.getKinesis().getSequenceNumber(), (Object)e.getMessage());
                listIterator.remove();
                response.getBatchItemFailures().add(StreamsEventResponse.BatchItemFailure.builder().withItemIdentifier(eventRecord.getKinesis().getSequenceNumber()).build());
            }
        }
        return response;
    }

    private SQSBatchResponse validateSQSEventMessages(List<SQSEvent.SQSMessage> messages, JsonSchema inboundJsonSchema) {
        SQSBatchResponse response = SQSBatchResponse.builder().withBatchItemFailures(new ArrayList()).build();
        ListIterator<SQSEvent.SQSMessage> listIterator = messages.listIterator();
        while (listIterator.hasNext()) {
            SQSEvent.SQSMessage message = listIterator.next();
            try {
                ValidationUtils.validate(message.getBody(), inboundJsonSchema);
            }
            catch (ValidationException e) {
                LOG.error("Validation error on message {}: {}", (Object)message.getMessageId(), (Object)e.getMessage());
                listIterator.remove();
                response.getBatchItemFailures().add(SQSBatchResponse.BatchItemFailure.builder().withItemIdentifier(message.getMessageId()).build());
            }
        }
        return response;
    }

    private APIGatewayProxyResponseEvent validateAPIGatewayProxyBody(String body, JsonSchema jsonSchema, Map<String, String> headers, Map<String, List<String>> multivalueHeaders) {
        APIGatewayProxyResponseEvent result = null;
        try {
            ValidationUtils.validate(body, jsonSchema);
        }
        catch (ValidationException e) {
            LOG.error("There were validation errors: {}", (Object)e.getMessage());
            result = new APIGatewayProxyResponseEvent();
            result.setBody(e.getMessage());
            result.setHeaders(headers == null ? Collections.emptyMap() : headers);
            result.setMultiValueHeaders(multivalueHeaders == null ? Collections.emptyMap() : multivalueHeaders);
            result.setStatusCode(Integer.valueOf(400));
            result.setIsBase64Encoded(Boolean.valueOf(false));
        }
        return result;
    }

    private APIGatewayV2HTTPResponse validateAPIGatewayV2HTTPBody(String body, JsonSchema jsonSchema, Map<String, String> headers, Map<String, List<String>> multivalueHeaders) {
        APIGatewayV2HTTPResponse result = null;
        try {
            ValidationUtils.validate(body, jsonSchema);
        }
        catch (ValidationException e) {
            LOG.error("There were validation errors: {}", (Object)e.getMessage());
            result = new APIGatewayV2HTTPResponse();
            result.setBody(e.getMessage());
            result.setHeaders(headers == null ? Collections.emptyMap() : headers);
            result.setMultiValueHeaders(multivalueHeaders == null ? Collections.emptyMap() : multivalueHeaders);
            result.setStatusCode(400);
            result.setIsBase64Encoded(false);
        }
        return result;
    }

    public static ValidationAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("software.amazon.lambda.powertools.validation.internal.ValidationAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

